/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DocsPath;
import org.apache.spark.sql.delta.DocsPath$class;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.schema.Invariant;
import org.apache.spark.sql.delta.schema.InvariantViolationException;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class DeltaErrors$
implements DocsPath,
DeltaLogging {
    public static final DeltaErrors$ MODULE$;
    private final String DeltaSourceIgnoreDeleteErrorMessage;
    private final String DeltaSourceIgnoreChangesErrorMessage;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaErrors$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public String baseDocsPath(SparkConf conf) {
        return DocsPath$class.baseDocsPath(this, conf);
    }

    public String baseDocsPath(SparkSession spark) {
        return this.baseDocsPath(spark.sparkContext().getConf());
    }

    public String DeltaSourceIgnoreDeleteErrorMessage() {
        return this.DeltaSourceIgnoreDeleteErrorMessage;
    }

    public String DeltaSourceIgnoreChangesErrorMessage() {
        return this.DeltaSourceIgnoreChangesErrorMessage;
    }

    public String deltaFileNotFoundHint(String path, String docAddress) {
        Object x$7 = null;
        String x$8 = "delta.error.fileNotFound";
        String x$9 = path;
        Map<TagDefinition, String> x$10 = this.recordDeltaEvent$default$3();
        this.recordDeltaEvent(null, x$8, x$10, x$9);
        String faq = new StringBuilder().append((Object)docAddress).append((Object)"/delta/delta-intro.html#frequently-asked-questions").toString();
        return new StringBuilder().append((Object)"A file referenced in the transaction log cannot be found. This occurs when data has been manually deleted from the file system rather than using the table `DELETE` statement. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"For more information, see ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{faq}))).toString();
    }

    public String formatColumn(String colName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}));
    }

    public String formatColumnList(Seq<String> colNames) {
        return ((TraversableOnce)colNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String colName) {
                return DeltaErrors$.MODULE$.formatColumn(colName);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    public String formatSchema(StructType schema2) {
        return schema2.treeString();
    }

    public AnalysisException analysisException(String msg, Option<Object> line, Option<Object> startPosition, Option<LogicalPlan> plan, Option<Throwable> cause) {
        return new AnalysisException(msg, line, startPosition, plan, cause);
    }

    public Option<Object> analysisException$default$2() {
        return None$.MODULE$;
    }

    public Option<Object> analysisException$default$3() {
        return None$.MODULE$;
    }

    public Option<LogicalPlan> analysisException$default$4() {
        return None$.MODULE$;
    }

    public Option<Throwable> analysisException$default$5() {
        return None$.MODULE$;
    }

    public Throwable notNullInvariantException(Invariant invariant) {
        return new InvariantViolationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new UnresolvedAttribute(invariant.column()).name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", which is defined as ", ", is missing from the data being "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invariant.rule().name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"written into the table."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public Throwable staticPartitionsNotSupportedException() {
        return new AnalysisException("Specifying static partitions in the partition spec is currently not supported during inserts", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable operationNotSupportedException(String operation, TableIdentifier tableIdentifier) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: `", "` is not supported "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for Delta tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentifier}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable operationNotSupportedException(String operation) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: `", "` is not supported for Delta tables"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable emptyDataException() {
        return new AnalysisException("Data used in creating the Delta table doesn't have any columns.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a Delta table."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deltaTableIdentifier})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(String operation, DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a Delta table. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deltaTableIdentifier}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is only supported for Delta tables."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaTableException(String operation) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is only supported for Delta tables."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable notADeltaSourceException(String command, Option<LogicalPlan> plan) {
        String planName = plan.isDefined() ? plan.toString() : "";
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " destination only supports Delta sources.\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, planName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Option<LogicalPlan> notADeltaSourceException$default$2() {
        return None$.MODULE$;
    }

    public Throwable missingTableIdentifierException(String operationName) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please provide the path or table identifier for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operationName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterTableChangeColumnException(String oldColumns, String newColumns) {
        return new AnalysisException(new StringBuilder().append((Object)"ALTER TABLE CHANGE COLUMN is not supported for changing column ").append((Object)oldColumns).append((Object)" to ").append((Object)newColumns).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable alterTableReplaceColumnsException(StructType oldSchema, StructType newSchema, String reason) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ALTER TABLE REPLACE COLUMNS operation. Reason: ", "\n         |\n         |Failed to change schema from:\n         |", "\n         |to:\n         |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reason, this.formatSchema(oldSchema), this.formatSchema(newSchema)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unsetNonExistentPropertyException(String propertyKey, DeltaTableIdentifier deltaTableIdentifier) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to unset non-existent property '", "' in table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{propertyKey, deltaTableIdentifier})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable ambiguousPartitionColumnException(String columnName, Seq<StructField> colMatches) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ambiguous partition column ", " can be"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(columnName)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList((Seq<String>)((Seq)colMatches.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())))}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable vacuumBasePathMissingException(Path baseDeltaPath) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please provide the base path (", ") when Vacuuming Delta tables. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseDeltaPath}))).append((Object)"Vacuuming specific partitions is currently not supported.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unknownConfigurationKeyException(String confKey) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown configuration was specified: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{confKey})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable useDeltaOnOtherFormatPathException(String operation, String path, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incompatible format detected.\n        |\n        |You are trying to ", " `", "` using Delta Lake, but there is no\n        |transaction log present. Check the upstream job to make sure that it is writing\n        |using format(\"delta\") and that you are trying to ", " the table base path.\n        |\n        |To disable this check, SET spark.databricks.delta.formatCheck.enabled=false\n        |To learn more about Delta, see ", "/delta/index.html\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, path, operation, this.baseDocsPath(spark)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable useOtherFormatOnDeltaPathException(String operation, String deltaRootPath, String path, String format, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incompatible format detected.\n        |\n        |A transaction log for Delta Lake was found at `", "/_delta_log`,\n        |but you are trying to ", " `", "` using format(\"", "\"). You must use\n        |'format(\"delta\")' when reading and writing to a delta table.\n        |\n        |To disable this check, SET spark.databricks.delta.formatCheck.enabled=false\n        |To learn more about Delta, see ", "/delta/index.html\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deltaRootPath, operation, path, format, this.baseDocsPath(spark)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pathNotSpecifiedException() {
        return new IllegalArgumentException("'path' is not specified");
    }

    public Throwable pathNotExistsException(String path) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable pathAlreadyExistsException(Path path) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable logFileNotFoundException(Path path, long version, Metadata metadata2) {
        CalendarInterval logRetention = DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData(metadata2);
        CalendarInterval checkpointRetention = DeltaConfigs$.MODULE$.CHECKPOINT_RETENTION_DURATION().fromMetaData(metadata2);
        return new FileNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Unable to reconstruct state at version ", " as the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, BoxesRunTime.boxToLong((long)version)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transaction log has been truncated due to manual deletion or the log retention policy "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "=", ") and checkpoint retention policy "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DeltaConfigs$.MODULE$.LOG_RETENTION().key(), logRetention}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DeltaConfigs$.MODULE$.CHECKPOINT_RETENTION_DURATION().key(), checkpointRetention}))).toString());
    }

    public Throwable logFileNotFoundExceptionForStreamingSource(FileNotFoundException e) {
        return new FileNotFoundException(new StringBuilder().append((Object)e.getMessage()).append((Object)" If you never deleted it, it's ").append((Object)"likely your query is lagging behind. Please delete its checkpoint to restart").append((Object)" from scratch. To avoid this happening again, you can update your retention ").append((Object)"policy of your Delta table").toString()).initCause(e);
    }

    public Throwable multipleLoadPathsException(Seq<String> paths) {
        throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |Delta Lake does not support multiple input paths in the load() API.\n        |paths: ", ". To build a single DataFrame by loading\n        |multiple paths from the same Delta table, please load the root path of\n        |the Delta table with the corresponding partition filters. If the multiple paths\n        |are from different Delta tables, please use Dataset's union()/unionByName() APIs\n        |to combine the DataFrames generated by separate load() API calls."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths.mkString("[", ",", "]")})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionColumnNotFoundException(String colName, Seq<Attribute> schema2) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column ", " not found in schema "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(colName)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$2) {
                return x$2.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionPathParseException(String fragment) {
        return new AnalysisException(new StringBuilder().append((Object)"A partition path fragment should be the form like `part1=foo/part2=bar`. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The partition path: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fragment}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable partitionPathInvolvesNonPartitionColumnException(Seq<String> badColumns, String fragment) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-partitioning column(s) ", " are specified: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList(badColumns), fragment})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonPartitionColumnAbsentException(boolean colsDropped) {
        String msg = colsDropped ? " Columns which are of NullType have been dropped." : "";
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data written into Delta needs to contain at least one non-partitioned column.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable replaceWhereMismatchException(String replaceWhere, String badPartitions) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data written out does not match replaceWhere '", "'.\n         |Invalid data would be written to partitions ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replaceWhere, badPartitions})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable illegalDeltaOptionException(String name, String input, String explain) {
        return new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid value '", "' for option '", "', ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input, name, explain})));
    }

    public Throwable modifyAppendOnlyTableException() {
        return new UnsupportedOperationException(new StringBuilder().append((Object)"This table is configured to only allow appends. If you would like to permit ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updates or deletes, use 'ALTER TABLE <table_name> SET TBLPROPERTIES "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "=false)'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DeltaConfigs$.MODULE$.IS_APPEND_ONLY().key()}))).toString());
    }

    public Throwable missingPartFilesException(CheckpointMetaData c, AnalysisException ae) {
        return new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find all part files of the checkpoint version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)c.version())})), ae);
    }

    public Throwable deltaVersionsNotContiguousException(Seq<Object> deltaVersions) {
        return new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"versions (", ") are not contiguous"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deltaVersions})));
    }

    public Throwable schemaChangedException(StructType oldSchema, StructType newSchema) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected schema change:\n        |old schema: ", "\n        |\n        |new schema: ", "\n        |\n        |Please try restarting the query. If this issue repeats across query restarts without making\n        |progress, you have made an incompatible schema change and need to start your query from\n        |scratch using a new checkpoint directory.\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatSchema(oldSchema), this.formatSchema(newSchema)})))).stripMargin());
    }

    public Throwable streamWriteNullTypeException() {
        return new AnalysisException("Delta doesn't accept NullTypes in the schema for streaming writes.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable schemaNotSetException() {
        return new AnalysisException("Table schema is not set.  Write data into it or use CREATE TABLE to set the schema.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable specifySchemaAtReadTimeException() {
        return new AnalysisException("Delta does not support specifying the schema at read time.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable outputModeNotSupportedException(String dataSource, OutputMode outputMode) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data source ", " does not support ", " output mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataSource, outputMode})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateSetColumnNotFoundException(String col, Seq<String> colList) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SET column ", " not found given columns: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(col), this.formatColumnList(colList)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateSetConflictException(Seq<String> cols) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is a conflict from these SET columns: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList(cols)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable updateNonStructTypeFieldNotSupportedException(String col, DataType s) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating nested fields is only supported for StructType, but you are trying to update "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a field of ", ", which is of type: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(col), s}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable truncateTablePartitionNotSupportedException() {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on Delta tables does not support"})).s((Seq)Nil$.MODULE$)).append((Object)" partition predicates; use DELETE to delete specific partitions or rows.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnPartitionColumnNotSupportedException(String name) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a bloom filter index on a partitioning column is unsupported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnNestedColumnNotSupportedException(String name) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating a bloom filer index on a nested column is currently unsupported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterOnColumnTypeNotSupportedException(String name, DataType dataType) {
        return new AnalysisException(new StringBuilder().append((Object)"Creating a bloom filter index on a column with type ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is unsupported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.catalogString(), name}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterMultipleConfForSingleColumnException(String name) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple bloom filter index configurations passed to command for column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterCreateOnNonExistingColumnsException(Seq<String> unknownColumns) {
        return new AnalysisException(new StringBuilder().append((Object)"Cannot create bloom filter indices for the following non-existent column(s): ").append((Object)unknownColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterInvalidParameterValueException(String message) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot create bloom filter index, invalid parameter value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterDropOnNonIndexedColumnException(String name) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot drop bloom filter index on a non indexed column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable bloomFilterDropOnNonExistingColumnsException(Seq<String> unknownColumns) {
        return new AnalysisException(new StringBuilder().append((Object)"Cannot drop bloom filter indices for the following non-existent column(s): ").append((Object)unknownColumns.mkString(", ")).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multipleSourceRowMatchingTargetRowInMergeException() {
        return new UnsupportedOperationException("Cannot perform MERGE as multiple source rows matched and attempted to update the same target row in the Delta table.");
    }

    public Throwable subqueryNotSupportedException(String op, Expression cond) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subqueries are not supported in the ", " (condition = ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, cond.sql()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multiColumnInPredicateNotSupportedException(String operation) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multi-column In predicates are not supported in the ", " condition."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedSubqueryNotSupportedException(String operation) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nested subquery is not supported in the ", " condition."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nestedFieldNotSupported(String operation, String field) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nested field is not supported in the ", " (field = ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, field})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable inSubqueryNotSupportedException(String operation) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In subquery is not supported in the ", " condition."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createExternalTableWithoutLogException(Path path, String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |You are trying to create an external table ", "\n         |from `", "` using Delta Lake, but there is no transaction log present at\n         |`", "/_delta_log`. Check the upstream job to make sure that it is writing using\n         |format(\"delta\") and that the path is the root of the table.\n         |\n         |To learn more about Delta, see ", "/delta/index.html\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, path, path, this.baseDocsPath(spark)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createExternalTableWithoutSchemaException(Path path, String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |You are trying to create an external table ", "\n         |from `", "` using Delta Lake, but the schema is not specified when the\n         |input path is empty.\n         |\n         |To learn more about Delta, see ", "/delta/index.html\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, path, this.baseDocsPath(spark)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable createManagedTableWithoutSchemaException(String tableName, SparkSession spark) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |You are trying to create a managed table ", "\n         |using Delta Lake, but the schema is not specified.\n         |\n         |To learn more about Delta, see ", "/delta/index.html\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, this.baseDocsPath(spark)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable aggsNotSupportedException(String op, Expression cond) {
        String condStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(condition = ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cond.sql()}));
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aggregate functions are not supported in the ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, condStr})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable nonDeterministicNotSupportedException(String op, Expression cond) {
        String condStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(condition = ", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cond.sql()}));
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-deterministic functions are not supported in the ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{op, condStr})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noHistoryFound(Path logPath) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No commits found at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logPath})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable noReproducibleHistoryFound(Path logPath) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No reproducible commits found at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logPath})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable timestampEarlierThanCommitRetention(Timestamp userTimestamp, Timestamp commitTs, String timestampString) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided timestamp (", ") is before the earliest version available to this\n         |table (", "). Please use a timestamp after ", ".\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userTimestamp, commitTs, timestampString})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable temporallyUnstableInput(Timestamp userTimestamp, Timestamp commitTs, String timestampString, long commitVersion) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided timestamp: ", " is after the latest commit timestamp of\n         |", ". If you wish to query this version of the table, please either provide\n         |the version with \"VERSION AS OF ", "\" or use the exact timestamp\n         |of the last commit: \"TIMESTAMP AS OF '", "'\".\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userTimestamp, commitTs, BoxesRunTime.boxToLong((long)commitVersion), timestampString})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable versionNotExistException(long userVersion, long earliest, long latest) {
        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot time travel Delta table to version ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)userVersion)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Available versions: [", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)earliest), BoxesRunTime.boxToLong((long)latest)}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable timeTravelNotSupportedException() {
        return new AnalysisException("Cannot time travel views, subqueries or streams.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable multipleTimeTravelSyntaxUsed() {
        return new AnalysisException("Cannot specify time travel in multiple formats.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable provideOneOfInTimeTravel() {
        return new IllegalArgumentException("Please either provide 'timestampAsOf' or 'versionAsOf' for time travel.");
    }

    public Throwable deltaLogAlreadyExistsException(String path) {
        return new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A Delta Lake log already exists at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable commitAlreadyExistsException(long version, Path logPath) {
        return new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit of version ", " already exists in the log: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version), logPath.toUri().toString()})));
    }

    public Throwable missingProviderForConvertException(String path) {
        return new AnalysisException(new StringBuilder().append((Object)"CONVERT TO DELTA only supports parquet tables. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please rewrite your target as parquet.`", "` if it's a parquet directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable convertNonParquetFilesException(String path, String sourceName) {
        return new AnalysisException(new StringBuilder().append((Object)"CONVERT TO DELTA only supports parquet files, but you are trying to ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"convert a ", " source: `", "`.`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceName, sourceName, path}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unexpectedPartitionColumnFromFileNameException(String path, String parsedCol, String expectedCol) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting partition column ", ", but"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(expectedCol)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" found partition column ", " from parsing the file name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumn(parsedCol), path}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable unexpectedNumPartitionColumnsFromFileNameException(String path, Seq<String> parsedCols, Seq<String> expectedCols) {
        return new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting ", " partition column(s): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedCols.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", but found ", " partition column(s): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList(expectedCols), BoxesRunTime.boxToInteger((int)parsedCols.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " from parsing the file name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList(parsedCols), path}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable castPartitionValueException(String partitionValue, DataType dataType) {
        return new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to cast partition value `", "` to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionValue, dataType})));
    }

    public Throwable emptyDirectoryException(String directory) {
        return new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No file found in the directory: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
    }

    public Throwable alterTableSetLocationSchemaMismatchException(StructType original, StructType destination) {
        return new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |The schema of the new Delta location is different than the current table schema.\n        |original schema:\n        |  ", "\n        |destination schema:\n        |  ", "\n        |\n        |If this is an intended change, you may turn this check off by running:\n        |%sql set spark.databricks.delta.alterLocation.bypassSchemaCheck = true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatSchema(original), this.formatSchema(destination)})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    public Throwable describeViewHistory() {
        return new AnalysisException("Cannot describe the history of a view.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private DeltaErrors$() {
        MODULE$ = this;
        DocsPath$class.$init$(this);
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
        this.DeltaSourceIgnoreDeleteErrorMessage = "Detected deleted data from streaming source. This is currently not supported. If you'd like to ignore deletes, set the option 'ignoreDeletes' to 'true'.";
        this.DeltaSourceIgnoreChangesErrorMessage = "Detected a data update in the source table. This is currently not supported. If you'd like to ignore updates, set the option 'ignoreChanges' to 'true'. If you would like the data update to be reflected, please restart this query with a fresh checkpoint directory.";
    }
}

