/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rEd\u0001B\u0001\u0003\u00015\u00111\u0003R3mi\u0006D\u0015n\u001d;pefl\u0015M\\1hKJT!a\u0001\u0003\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\t\t\u0001\"\\3uKJLgnZ\u0005\u00033Y\u0011A\u0002R3mi\u0006dunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\tI\u0016dG/\u0019'pOB\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002\t\t\u0016dG/\u0019'pO\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\bnCb\\U-_:QKJd\u0015n\u001d;\u0011\u0005=\u0019\u0013B\u0001\u0013\u0011\u0005\rIe\u000e\u001e\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!J#\u0006\u0005\u0002\u001e\u0001!)1$\na\u00019!9\u0011%\nI\u0001\u0002\u0004\u0011\u0003\"B\u0004\u0001\t\u0013aS#A\u0017\u0011\u00059zS\"\u0001\u0003\n\u0005A\"!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002\u001a\u0001\t\u0013\u0019\u0014!G4fiN+'/[1mSj\f'\r\\3IC\u0012|w\u000e]\"p]\u001a,\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\tA!\u001e;jY&\u0011\u0011H\u000e\u0002\u001a'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003<\u0001\u0011\u0005A(\u0001\u0006hKRD\u0015n\u001d;pef$\"!P(\u0011\u0007y2\u0015J\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!!\u0012\t\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\u0004'\u0016\f(BA#\u0011!\tQU*D\u0001L\u0015\ta%!A\u0004bGRLwN\\:\n\u00059[%AC\"p[6LG/\u00138g_\")\u0001K\u000fa\u0001#\u0006AA.[7ji>\u0003H\u000fE\u0002\u0010%\nJ!a\u0015\t\u0003\r=\u0003H/[8o\u0011\u0015Y\u0004\u0001\"\u0001V)\ridk\u0017\u0005\u0006/R\u0003\r\u0001W\u0001\u0006gR\f'\u000f\u001e\t\u0003\u001feK!A\u0017\t\u0003\t1{gn\u001a\u0005\u00069R\u0003\r!X\u0001\u0004K:$\u0007cA\bS1\")q\f\u0001C\u0001A\u0006)r-\u001a;BGRLg/Z\"p[6LG/\u0011;US6,GcB1\u0004:\r\u00153\u0011\n\t\u0004E\u0006MaBA\u000fd\u000f\u0015!'\u0001#\u0001f\u0003M!U\r\u001c;b\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s!\tibMB\u0003\u0002\u0005!\u0005qmE\u0002g\u001dQAQA\n4\u0005\u0002%$\u0012!\u001a\u0005\u0006W\u001a$I\u0001\\\u0001\u000eO\u0016$8i\\7nSRLeNZ8\u0015\t%kWo \u0005\u0006]*\u0004\ra\\\u0001\tY><7\u000b^8sKB\u0011\u0001o]\u0007\u0002c*\u0011!OA\u0001\bgR|'/Y4f\u0013\t!\u0018O\u0001\u0005M_\u001e\u001cFo\u001c:f\u0011\u00151(\u000e1\u0001x\u0003!\u0011\u0017m]3QCRD\u0007C\u0001=~\u001b\u0005I(B\u0001>|\u0003\t17O\u0003\u0002}\u0011\u00051\u0001.\u00193p_BL!A`=\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0003\u0003Q\u0007\u0019\u0001-\u0002\u000fY,'o]5p]\"A\u0011Q\u00014\u0005\u0002\t\t9!\u0001\u0006hKR\u001cu.\\7jiN$\"\"!\u0003\u0002\\\u0006u\u0017\u0011]Ar!\u0015y\u00111BA\b\u0013\r\ti\u0001\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003#\t\u0019\"D\u0001g\r\u0019\t)B\u001a!\u0002\u0018\t11i\\7nSR\u001c\u0012\"a\u0005\u000f\u00033\ty\"!\n\u0011\u0007)\u000bY\"C\u0002\u0002\u001e-\u0013AbQ8n[&$X*\u0019:lKJ\u00042aDA\u0011\u0013\r\t\u0019\u0003\u0005\u0002\b!J|G-^2u!\ry\u0011qE\u0005\u0004\u0003S\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007bCA\u0001\u0003'\u0011)\u001a!C\u0001\u0003[)\u0012\u0001\u0017\u0005\u000b\u0003c\t\u0019B!E!\u0002\u0013A\u0016\u0001\u0003<feNLwN\u001c\u0011\t\u0017\u0005U\u00121\u0003BK\u0002\u0013\u0005\u0011QF\u0001\ni&lWm\u001d;b[BD!\"!\u000f\u0002\u0014\tE\t\u0015!\u0003Y\u0003)!\u0018.\\3ti\u0006l\u0007\u000f\t\u0005\bM\u0005MA\u0011AA\u001f)\u0019\ty!a\u0010\u0002B!9\u0011\u0011AA\u001e\u0001\u0004A\u0006bBA\u001b\u0003w\u0001\r\u0001\u0017\u0005\t\u0003\u000b\n\u0019\u0002\"\u0011\u0002H\u0005iq/\u001b;i)&lWm\u001d;b[B$B!a\u0004\u0002J!9\u0011QGA\"\u0001\u0004A\u0006\u0002CA'\u0003'!\t%!\f\u0002\u0019\u001d,G\u000fV5nKN$\u0018-\u001c9\t\u0011\u0005E\u00131\u0003C!\u0003[\t!bZ3u-\u0016\u00148/[8o\u0011)\t)&a\u0005\u0002\u0002\u0013\u0005\u0011qK\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002\u0010\u0005e\u00131\f\u0005\n\u0003\u0003\t\u0019\u0006%AA\u0002aC\u0011\"!\u000e\u0002TA\u0005\t\u0019\u0001-\t\u0015\u0005}\u00131CI\u0001\n\u0003\t\t'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r$f\u0001-\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002rA\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002z\u0005M\u0011\u0013!C\u0001\u0003C\nabY8qs\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0002~\u0005M\u0011\u0011!C!\u0003\u007f\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000bA\u0001\\1oO*\u0011\u00111R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0006\u0015%AB*ue&tw\r\u0003\u0006\u0002\u0014\u0006M\u0011\u0011!C\u0001\u0003+\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012A\t\u0005\u000b\u00033\u000b\u0019\"!A\u0005\u0002\u0005m\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\u000b\u0019\u000bE\u0002\u0010\u0003?K1!!)\u0011\u0005\r\te.\u001f\u0005\n\u0003K\u000b9*!AA\u0002\t\n1\u0001\u001f\u00132\u0011)\tI+a\u0005\u0002\u0002\u0013\u0005\u00131V\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0016\t\u0007\u0003_\u000b),!(\u000e\u0005\u0005E&bAAZ!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0016\u0011\u0017\u0002\t\u0013R,'/\u0019;pe\"Q\u00111XA\n\u0003\u0003%\t!!0\u0002\u0011\r\fg.R9vC2$B!a0\u0002FB\u0019q\"!1\n\u0007\u0005\r\u0007CA\u0004C_>dW-\u00198\t\u0015\u0005\u0015\u0016\u0011XA\u0001\u0002\u0004\ti\n\u0003\u0006\u0002J\u0006M\u0011\u0011!C!\u0003\u0017\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002E!Q\u0011qZA\n\u0003\u0003%\t%!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!!\t\u0015\u0005U\u00171CA\u0001\n\u0003\n9.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u007f\u000bI\u000e\u0003\u0006\u0002&\u0006M\u0017\u0011!a\u0001\u0003;CaA\\A\u0002\u0001\u0004y\u0007bBAp\u0003\u0007\u0001\ra^\u0001\bY><\u0007+\u0019;i\u0011\u00199\u00161\u0001a\u00011\"AA,a\u0001\u0011\u0002\u0003\u0007Q\fC\u0004\u0002h\u001a$I!!;\u000255|gn\u001c;p]&TXmQ8n[&$H+[7fgR\fW\u000e]:\u0016\t\u0005-\u00181\u001f\u000b\u0005\u0003[\fy\u0010E\u0003\u0010\u0003\u0017\ty\u000f\u0005\u0003\u0002r\u0006MH\u0002\u0001\u0003\t\u0003k\f)O1\u0001\u0002x\n\tA+\u0005\u0003\u0002z\u0006e\u0001cA\b\u0002|&\u0019\u0011Q \t\u0003\u000f9{G\u000f[5oO\"A!\u0011AAs\u0001\u0004\ti/A\u0004d_6l\u0017\u000e^:\t\u000f\t\u0015a\r\"\u0003\u0003\b\u0005y\u0001/\u0019:bY2,GnU3be\u000eD\u0007\u0007\u0006\t\u0002\u0010\t%!1\u0002B\b\u0005;\u0011\tCa\t\u0003&!1qAa\u0001A\u00025BqA!\u0004\u0003\u0004\u0001\u0007A'\u0001\u0003d_:4\u0007\u0002CAp\u0005\u0007\u0001\rA!\u0005\u0011\t\tM!\u0011\u0004\b\u0004\u001f\tU\u0011b\u0001B\f!\u00051\u0001K]3eK\u001aLA!a$\u0003\u001c)\u0019!q\u0003\t\t\u000f\t}!1\u0001a\u00011\u0006!A/[7f\u0011\u00199&1\u0001a\u00011\"1ALa\u0001A\u0002aCqAa\n\u0003\u0004\u0001\u0007\u0001,\u0001\u0003ti\u0016\u0004\bb\u0002B\u0016M\u0012%!QF\u0001\u001aY\u0006\u001cHoQ8n[&$()\u001a4pe\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0004\u00030\tE\"Q\u0007\t\u0005\u001fI\u000by\u0001\u0003\u0005\u0003\u0002\t%\u0002\u0019\u0001B\u001a!\u0011qd)a\u0004\t\u000f\t}!\u0011\u0006a\u00011\u001eI!\u0011\b4\u0002\u0002#\u0005!1H\u0001\u0007\u0007>lW.\u001b;\u0011\t\u0005E!Q\b\u0004\n\u0003+1\u0017\u0011!E\u0001\u0005\u007f\u0019bA!\u0010\u0003B\u0005\u0015\u0002\u0003\u0003B\"\u0005\u0013B\u0006,a\u0004\u000e\u0005\t\u0015#b\u0001B$!\u00059!/\u001e8uS6,\u0017\u0002\u0002B&\u0005\u000b\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001d1#Q\bC\u0001\u0005\u001f\"\"Aa\u000f\t\u0015\u0005='QHA\u0001\n\u000b\n\t\u000e\u0003\u0006\u0003V\tu\u0012\u0011!CA\u0005/\nQ!\u00199qYf$b!a\u0004\u0003Z\tm\u0003bBA\u0001\u0005'\u0002\r\u0001\u0017\u0005\b\u0003k\u0011\u0019\u00061\u0001Y\u0011)\u0011yF!\u0010\u0002\u0002\u0013\u0005%\u0011M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\u0019Ga\u001b\u0011\t=\u0011&Q\r\t\u0006\u001f\t\u001d\u0004\fW\u0005\u0004\u0005S\u0002\"A\u0002+va2,'\u0007\u0003\u0006\u0003n\tu\u0013\u0011!a\u0001\u0003\u001f\t1\u0001\u001f\u00131\u0011)\u0011\tH!\u0010\u0002\u0002\u0013%!1O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003vA!\u00111\u0011B<\u0013\u0011\u0011I(!\"\u0003\r=\u0013'.Z2u\r\u0019\u0011iH\u001a\u0001\u0003\u0000\ta\")\u001e4gKJLgn\u001a'pO\u0012+G.\u001a;j_:LE/\u001a:bi>\u00148#\u0002B>\u001d\t\u0005\u0005#\u0002 \u0003\u0004\n\u0015\u0015bAA\\\u0011B\u0019\u0001Pa\"\n\u0007\t%\u0015P\u0001\u0006GS2,7\u000b^1ukND1B!$\u0003|\t\u0005\t\u0015!\u0003\u0003\u0002\u0006QQO\u001c3fe2L\u0018N\\4\t\u0015\tE%1\u0010B\u0001B\u0003%\u0001,\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0003\u0016\nm$\u0011!Q\u0001\na\u000b!\"\\1y-\u0016\u00148/[8o\u0011-\u0011IJa\u001f\u0003\u0002\u0003\u0006IAa'\u0002\u001bY,'o]5p]\u001e+G\u000f^3s!\u0015y!QT<Y\u0013\r\u0011y\n\u0005\u0002\n\rVt7\r^5p]FBqA\nB>\t\u0003\u0011\u0019\u000b\u0006\u0006\u0003&\n\u001d&\u0011\u0016BV\u0005[\u0003B!!\u0005\u0003|!A!Q\u0012BQ\u0001\u0004\u0011\t\tC\u0004\u0003\u0012\n\u0005\u0006\u0019\u0001-\t\u000f\tU%\u0011\u0015a\u00011\"A!\u0011\u0014BQ\u0001\u0004\u0011Y\n\u0003\u0006\u00032\nm$\u0019!C\u0005\u0005g\u000bQBZ5mKN$v\u000eR3mKR,WC\u0001B[!\u0019\u00119L!0\u0003\u00066\u0011!\u0011\u0018\u0006\u0005\u0005w\u000b\t,A\u0004nkR\f'\r\\3\n\t\t}&\u0011\u0018\u0002\u0006#V,W/\u001a\u0005\n\u0005\u0007\u0014Y\b)A\u0005\u0005k\u000baBZ5mKN$v\u000eR3mKR,\u0007\u0005\u0003\u0006\u0003H\nm$\u0019!C\u0005\u0005\u0013\f\u0001#\\1zE\u0016$U\r\\3uK\u001aKG.Z:\u0016\u0005\t-\u0007C\u0002B\\\u0005\u001b\u0014))\u0003\u0003\u0003P\ne&aC!se\u0006L()\u001e4gKJD\u0011Ba5\u0003|\u0001\u0006IAa3\u0002#5\f\u0017PY3EK2,G/\u001a$jY\u0016\u001c\b\u0005\u0003\u0007\u0003X\nm\u0004\u0019!a\u0001\n\u0013\u0011I.\u0001\u0005mCN$h)\u001b7f+\t\u0011)\t\u0003\u0007\u0003^\nm\u0004\u0019!a\u0001\n\u0013\u0011y.\u0001\u0007mCN$h)\u001b7f?\u0012*\u0017\u000f\u0006\u0003\u0003b\n\u001d\bcA\b\u0003d&\u0019!Q\u001d\t\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003K\u0013Y.!AA\u0002\t\u0015\u0005\"\u0003Bv\u0005w\u0002\u000b\u0015\u0002BC\u0003%a\u0017m\u001d;GS2,\u0007\u0005\u0003\u0006\u0003p\nm\u0004\u0019!C\u0005\u0005c\fQ\u0002[1t\u001d\u0016DHoQ1mY\u0016$WCAA`\u0011)\u0011)Pa\u001fA\u0002\u0013%!q_\u0001\u0012Q\u0006\u001ch*\u001a=u\u0007\u0006dG.\u001a3`I\u0015\fH\u0003\u0002Bq\u0005sD!\"!*\u0003t\u0006\u0005\t\u0019AA`\u0011%\u0011iPa\u001f!B\u0013\ty,\u0001\biCNtU\r\u001f;DC2dW\r\u001a\u0011\t\u0011\r\u0005!1\u0010C\u0005\u0007\u0007\tA!\u001b8jiR\u0011!\u0011\u001d\u0005\t\u0007\u000f\u0011Y\b\"\u0003\u0004\n\u0005\u00012\u000f[8vY\u0012$U\r\\3uK\u001aKG.\u001a\u000b\u0005\u0003\u007f\u001bY\u0001\u0003\u0005\u0004\u000e\r\u0015\u0001\u0019\u0001BC\u0003\u00111\u0017\u000e\\3\t\u0011\rE!1\u0010C\u0005\u0007'\t1C\\3fIN$\u0016.\\3BI*,8\u000f^7f]R$B!a0\u0004\u0016!A1QBB\b\u0001\u0004\u0011)\t\u0003\u0005\u0004\u001a\tmD\u0011BB\u0002\u0003-1G.^:i\u0005V4g-\u001a:\t\u0011\ru!1\u0010C\u0005\u0007\u0007\t!#];fk\u00164\u0015\u000e\\3t\u0013:\u0014UO\u001a4fe\"A1\u0011\u0005B>\t\u0003\u0012\t0A\u0004iCNtU\r\u001f;\t\u0011\r\u0015\"1\u0010C!\u0007O\tAA\\3yiR\u0011!Q\u0011\u0005\n\u0007W1\u0017\u0013!C\u0001\u0007[\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAB\u0018U\r\u0011\u0013Q\r\u0005\n\u0007g1\u0017\u0013!C\u0001\u0007k\tAcZ3u\u0007>lW.\u001b;tI\u0011,g-Y;mi\u0012\"TCAB\u001cU\ri\u0016Q\r\u0005\b\u0003kq\u0006\u0019AB\u001e!\u0011\u0019id!\u0011\u000e\u0005\r}\"bA\u0003\u0002\n&!11IB \u0005%!\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0004Hy\u0003\r!a0\u0002'\r\fgNU3ukJtG*Y:u\u0007>lW.\u001b;\t\u0013\r-c\f%AA\u0002\u0005}\u0016!E7vgR\u0014UMU3de\u0016\fG/\u00192mK\"91q\n\u0001\u0005\u0002\rE\u0013AE2iK\u000e\\g+\u001a:tS>tW\t_5tiN$BA!9\u0004T!9\u0011\u0011AB'\u0001\u0004A\u0006bBB,\u0001\u0011%1\u0011L\u0001\u000fa\u0006\u0014\u0018\r\u001c7fYN+\u0017M]2i)\u001d\t71LB/\u0007?BqAa\b\u0004V\u0001\u0007\u0001\f\u0003\u0004X\u0007+\u0002\r\u0001\u0017\u0005\u00079\u000eU\u0003\u0019\u0001-\t\u000f\r\r\u0004\u0001\"\u0003\u0002.\u0005!r-\u001a;FCJd\u0017.Z:u\t\u0016dG/\u0019$jY\u0016Dqaa\u001a\u0001\t\u0013\ti#A\u000fhKR,\u0015M\u001d7jKN$(+\u001a9s_\u0012,8-\u001b2mK\u000e{W.\\5u\u0011%\u0019Y\u0007AI\u0001\n\u0003\u0019i'A\u0010hKR\f5\r^5wK\u000e{W.\\5u\u0003R$\u0016.\\3%I\u00164\u0017-\u001e7uIM*\"aa\u001c+\t\u0005}\u0016Q\r")
public class DeltaHistoryManager
implements DeltaLogging {
    public final DeltaLog org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog;
    private final int maxKeysPerList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Object> getCommits$default$4() {
        return DeltaHistoryManager$.MODULE$.getCommits$default$4();
    }

    public static int $lessinit$greater$default$2() {
        return DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private SerializableConfiguration getSerializableHadoopConf() {
        return new SerializableConfiguration(this.spark().sessionState().newHadoopConf());
    }

    public Seq<CommitInfo> getHistory(Option<Object> limitOpt) {
        long listStart = BoxesRunTime.unboxToLong((Object)limitOpt.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaHistoryManager $outer;

            public final long apply(int limit) {
                return this.apply$mcJI$sp(limit);
            }

            public long apply$mcJI$sp(int limit) {
                return scala.math.package$.MODULE$.max(this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update(this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update$default$1()).version() - (long)limit + 1L, 0L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaHistoryManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$$getEarliestDeltaFile();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        return this.getHistory(listStart, (Option<Object>)None$.MODULE$);
    }

    public Seq<CommitInfo> getHistory(long start, Option<Object> end) {
        SparkSession _spark = this.spark();
        SerializableConfiguration conf = this.getSerializableHadoopConf();
        String logPath = this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath().toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeltaHistoryManager.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.actions.CommitInfo").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(DeltaHistoryManager $outer) {
            }
        }
        Dataset info = this.spark().range(start, BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaHistoryManager $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update(this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update$default$1()).version();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })) + 1L).mapPartitions((Function1)new Serializable(this, conf, logPath){
            public static final long serialVersionUID = 0L;
            private final SerializableConfiguration conf$1;
            private final String logPath$1;

            public final Iterator<CommitInfo> apply(Iterator<Long> versions) {
                LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), this.conf$1.value());
                Path basePath = new Path(this.logPath$1);
                FileSystem fs = basePath.getFileSystem(this.conf$1.value());
                return versions.flatMap((Function1)new Serializable(this, logStore, basePath, fs){
                    public static final long serialVersionUID = 0L;
                    private final LogStore logStore$1;
                    private final Path basePath$1;
                    private final FileSystem fs$1;

                    public final Iterable<CommitInfo> apply(Long commit2) {
                        Iterable iterable;
                        try {
                            CommitInfo ci = DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(this.logStore$1, this.basePath$1, Predef$.MODULE$.Long2long(commit2));
                            FileStatus metadata2 = this.fs$1.getFileStatus(FileNames$.MODULE$.deltaFile(this.basePath$1, Predef$.MODULE$.Long2long(commit2)));
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ci.withTimestamp(metadata2.getModificationTime())));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        }
                        return iterable;
                    }
                    {
                        this.logStore$1 = logStore$1;
                        this.basePath$1 = basePath$1;
                        this.fs$1 = fs$1;
                    }
                });
            }
            {
                this.conf$1 = conf$1;
                this.logPath$1 = logPath$1;
            }
        }, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(this))));
        return Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])info.collect())).reverse());
    }

    public Commit getActiveCommitAtTime(Timestamp timestamp, boolean canReturnLastCommit, boolean mustBeRecreatable) {
        Commit commit2;
        long time = timestamp.getTime();
        long earliest = mustBeRecreatable ? this.getEarliestReproducibleCommit() : this.org$apache$spark$sql$delta$DeltaHistoryManager$$getEarliestDeltaFile();
        long latestVersion = this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update$default$1()).version();
        if (latestVersion - earliest > (long)(2 * this.maxKeysPerList)) {
            commit2 = this.parallelSearch(time, earliest, latestVersion + 1L);
        } else {
            Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.store(), this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath(), earliest, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(latestVersion + 1L))));
            commit2 = (Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0)new Serializable(this, commits){
                public static final long serialVersionUID = 0L;
                private final Commit[] commits$2;

                public final Commit apply() {
                    return (Commit)Predef$.MODULE$.refArrayOps((Object[])this.commits$2).head();
                }
                {
                    this.commits$2 = commits$2;
                }
            });
        }
        Commit commit3 = commit2;
        Timestamp commitTs = new Timestamp(commit3.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        if (commit3.timestamp() > time) {
            throw DeltaErrors$.MODULE$.timestampEarlierThanCommitRetention(timestamp, commitTs, tsString);
        }
        if (commit3.version() == latestVersion && !canReturnLastCommit && commit3.timestamp() < time) {
            throw DeltaErrors$.MODULE$.temporallyUnstableInput(timestamp, commitTs, tsString, commit3.version());
        }
        return commit3;
    }

    public boolean getActiveCommitAtTime$default$3() {
        return true;
    }

    public void checkVersionExists(long version) {
        long earliest = this.getEarliestReproducibleCommit();
        long latest = this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.update$default$1()).version();
        if (version < earliest || version > latest) {
            throw DeltaErrors$.MODULE$.versionNotExistException(version, earliest, latest);
        }
    }

    private Commit parallelSearch(long time, long start, long end) {
        return DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(this.spark(), this.getSerializableHadoopConf(), this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath().toString(), time, start, end, this.maxKeysPerList);
    }

    public long org$apache$spark$sql$delta$DeltaHistoryManager$$getEarliestDeltaFile() {
        Option earliestVersionOpt = Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.store().listFrom(FileNames$.MODULE$.deltaFile(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath(), 0L)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isDeltaFile(f.getPath());
            }
        }).take(1).toArray(ClassTag$.MODULE$.apply(FileStatus.class))).headOption();
        if (earliestVersionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.noHistoryFound(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath());
        }
        return FileNames$.MODULE$.deltaVersion(((FileStatus)earliestVersionOpt.get()).getPath());
    }

    private long getEarliestReproducibleCommit() {
        Iterator files = this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.store().listFrom(FileNames$.MODULE$.deltaFile(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath(), 0L)).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isDeltaFile(f.getPath()) || FileNames$.MODULE$.isCheckpointFile(f.getPath());
            }
        });
        HashMap checkpointMap = new HashMap();
        long smallestDeltaVersion = Long.MAX_VALUE;
        while (files.hasNext()) {
            BoxedUnit boxedUnit;
            Path nextFilePath = ((FileStatus)files.next()).getPath();
            if (FileNames$.MODULE$.isDeltaFile(nextFilePath)) {
                long version = FileNames$.MODULE$.deltaVersion(nextFilePath);
                if (version == 0L) {
                    return version;
                }
                smallestDeltaVersion = scala.math.package$.MODULE$.min(version, smallestDeltaVersion);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (FileNames$.MODULE$.isCheckpointFile(nextFilePath)) {
                int preCount;
                long checkpointVersion = FileNames$.MODULE$.checkpointVersion(nextFilePath);
                Option<Object> parts = FileNames$.MODULE$.numCheckpointParts(nextFilePath);
                if (parts.isEmpty() && smallestDeltaVersion <= checkpointVersion) {
                    return checkpointVersion;
                }
                int numParts = BoxesRunTime.unboxToInt((Object)parts.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 1;
                    }
                }));
                if (numParts == (preCount = BoxesRunTime.unboxToInt((Object)checkpointMap.getOrElse((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                }))) + 1 && smallestDeltaVersion <= checkpointVersion) {
                    return checkpointVersion;
                }
                boxedUnit = checkpointMap.put((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Object)BoxesRunTime.boxToInteger((int)(preCount + 1)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (smallestDeltaVersion < Long.MAX_VALUE) {
            throw DeltaErrors$.MODULE$.noReproducibleHistoryFound(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath());
        }
        throw DeltaErrors$.MODULE$.noHistoryFound(this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog.logPath());
    }

    public DeltaHistoryManager(DeltaLog deltaLog, int maxKeysPerList) {
        this.org$apache$spark$sql$delta$DeltaHistoryManager$$deltaLog = deltaLog;
        this.maxKeysPerList = maxKeysPerList;
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
    }

    public static class Commit
    implements CommitMarker,
    Product,
    Serializable {
        private final long version;
        private final long timestamp;

        public long version() {
            return this.version;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public Commit withTimestamp(long timestamp) {
            long x$15 = timestamp;
            long x$16 = this.copy$default$1();
            return this.copy(x$16, x$15);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp();
        }

        @Override
        public long getVersion() {
            return this.version();
        }

        public Commit copy(long version, long timestamp) {
            return new Commit(version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.version());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit2 = (Commit)x$1;
            if (this.version() != commit2.version()) return false;
            if (this.timestamp() != commit2.timestamp()) return false;
            if (!commit2.canEqual(this)) return false;
            return true;
        }

        public Commit(long version, long timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            Product.class.$init$((Product)this);
        }
    }

    public static class BufferingLogDeletionIterator
    implements Iterator<FileStatus> {
        private final Iterator<FileStatus> underlying;
        private final long maxTimestamp;
        private final long maxVersion;
        private final Function1<Path, Object> versionGetter;
        private final Queue<FileStatus> filesToDelete;
        private final ArrayBuffer<FileStatus> maybeDeleteFiles;
        private FileStatus lastFile;
        private boolean hasNextCalled;

        public Iterator<FileStatus> seq() {
            return Iterator.class.seq((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.class.isEmpty((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.class.isTraversableAgain((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.class.hasDefiniteSize((Iterator)this);
        }

        public Iterator<FileStatus> take(int n) {
            return Iterator.class.take((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> drop(int n) {
            return Iterator.class.drop((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> slice(int from, int until) {
            return Iterator.class.slice((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<FileStatus, B> f) {
            return Iterator.class.map((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.class.$plus$plus((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<FileStatus, GenTraversableOnce<B>> f) {
            return Iterator.class.flatMap((Iterator)this, f);
        }

        public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
            return Iterator.class.filter((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<FileStatus, B, Object> p) {
            return Iterator.class.corresponds((Iterator)this, that, p);
        }

        public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
            return Iterator.class.withFilter((Iterator)this, p);
        }

        public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
            return Iterator.class.filterNot((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<FileStatus, B> pf) {
            return Iterator.class.collect((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, FileStatus, B> op) {
            return Iterator.class.scanLeft((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<FileStatus, B, B> op) {
            return Iterator.class.scanRight((Iterator)this, z, op);
        }

        public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
            return Iterator.class.takeWhile((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
            return Iterator.class.partition((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
            return Iterator.class.span((Iterator)this, p);
        }

        public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
            return Iterator.class.dropWhile((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<FileStatus, B>> zip(Iterator<B> that) {
            return Iterator.class.zip((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.class.padTo((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
            return Iterator.class.zipWithIndex((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<FileStatus, U> f) {
            Iterator.class.foreach((Iterator)this, f);
        }

        public boolean forall(Function1<FileStatus, Object> p) {
            return Iterator.class.forall((Iterator)this, p);
        }

        public boolean exists(Function1<FileStatus, Object> p) {
            return Iterator.class.exists((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.class.contains((Iterator)this, (Object)elem);
        }

        public Option<FileStatus> find(Function1<FileStatus, Object> p) {
            return Iterator.class.find((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p) {
            return Iterator.class.indexWhere((Iterator)this, p);
        }

        public <B> int indexOf(B elem) {
            return Iterator.class.indexOf((Iterator)this, elem);
        }

        public BufferedIterator<FileStatus> buffered() {
            return Iterator.class.buffered((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.class.grouped((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
        }

        public int length() {
            return Iterator.class.length((Iterator)this);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
            return Iterator.class.duplicate((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.class.sameElements((Iterator)this, that);
        }

        public Traversable<FileStatus> toTraversable() {
            return Iterator.class.toTraversable((Iterator)this);
        }

        public Iterator<FileStatus> toIterator() {
            return Iterator.class.toIterator((Iterator)this);
        }

        public Stream<FileStatus> toStream() {
            return Iterator.class.toStream((Iterator)this);
        }

        public String toString() {
            return Iterator.class.toString((Iterator)this);
        }

        public <B> int sliding$default$2() {
            return Iterator.class.sliding$default$2((Iterator)this);
        }

        public List<FileStatus> reversed() {
            return TraversableOnce.class.reversed((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.class.size((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.class.nonEmpty((TraversableOnce)this);
        }

        public int count(Function1<FileStatus, Object> p) {
            return TraversableOnce.class.count((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<FileStatus, B> pf) {
            return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
            return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
            return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, FileStatus, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.class.product((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
        }

        public List<FileStatus> toList() {
            return TraversableOnce.class.toList((TraversableOnce)this);
        }

        public Iterable<FileStatus> toIterable() {
            return TraversableOnce.class.toIterable((TraversableOnce)this);
        }

        public Seq<FileStatus> toSeq() {
            return TraversableOnce.class.toSeq((TraversableOnce)this);
        }

        public IndexedSeq<FileStatus> toIndexedSeq() {
            return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.class.toBuffer((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.class.toSet((TraversableOnce)this);
        }

        public Vector<FileStatus> toVector() {
            return TraversableOnce.class.toVector((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, FileStatus, Col> cbf) {
            return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<FileStatus, Tuple2<T, U>> ev) {
            return TraversableOnce.class.toMap((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.class.mkString((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
        }

        private Queue<FileStatus> filesToDelete() {
            return this.filesToDelete;
        }

        private ArrayBuffer<FileStatus> maybeDeleteFiles() {
            return this.maybeDeleteFiles;
        }

        private FileStatus lastFile() {
            return this.lastFile;
        }

        private void lastFile_$eq(FileStatus x$1) {
            this.lastFile = x$1;
        }

        private boolean hasNextCalled() {
            return this.hasNextCalled;
        }

        private void hasNextCalled_$eq(boolean x$1) {
            this.hasNextCalled = x$1;
        }

        private void init() {
            if (this.underlying.hasNext()) {
                this.lastFile_$eq((FileStatus)this.underlying.next());
                this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{this.lastFile()}));
            }
        }

        public boolean org$apache$spark$sql$delta$DeltaHistoryManager$BufferingLogDeletionIterator$$shouldDeleteFile(FileStatus file) {
            return file.getModificationTime() <= this.maxTimestamp && BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) <= this.maxVersion;
        }

        private boolean needsTimeAdjustment(FileStatus file) {
            return BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)this.lastFile().getPath())) < BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) && this.lastFile().getModificationTime() >= file.getModificationTime();
        }

        private void flushBuffer() {
            if (this.maybeDeleteFiles().lastOption().exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BufferingLogDeletionIterator $outer;

                public final boolean apply(FileStatus file) {
                    return this.$outer.org$apache$spark$sql$delta$DeltaHistoryManager$BufferingLogDeletionIterator$$shouldDeleteFile(file);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })) {
                this.filesToDelete().enqueue(this.maybeDeleteFiles());
            }
            this.maybeDeleteFiles().clear();
        }

        private void queueFilesInBuffer() {
            boolean continueBuffering = true;
            while (continueBuffering) {
                if (this.underlying.hasNext()) {
                    FileStatus currentFile = (FileStatus)this.underlying.next();
                    Predef$.MODULE$.require(currentFile != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "FileStatus iterator returned null";
                        }
                    });
                    if (this.needsTimeAdjustment(currentFile)) {
                        currentFile = new FileStatus(currentFile.getLen(), currentFile.isDirectory(), (int)currentFile.getReplication(), currentFile.getBlockSize(), this.lastFile().getModificationTime() + 1L, currentFile.getPath());
                        this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                    } else {
                        this.flushBuffer();
                        this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                        continueBuffering = false;
                    }
                    this.lastFile_$eq(currentFile);
                    continue;
                }
                this.flushBuffer();
                return;
            }
        }

        public boolean hasNext() {
            this.hasNextCalled_$eq(true);
            if (this.filesToDelete().isEmpty()) {
                this.queueFilesInBuffer();
            }
            return this.filesToDelete().nonEmpty();
        }

        public FileStatus next() {
            if (this.hasNextCalled()) {
                this.hasNextCalled_$eq(false);
                return (FileStatus)this.filesToDelete().dequeue();
            }
            throw new NoSuchElementException();
        }

        public BufferingLogDeletionIterator(Iterator<FileStatus> underlying, long maxTimestamp, long maxVersion, Function1<Path, Object> versionGetter) {
            this.underlying = underlying;
            this.maxTimestamp = maxTimestamp;
            this.maxVersion = maxVersion;
            this.versionGetter = versionGetter;
            TraversableOnce.class.$init$((TraversableOnce)this);
            Iterator.class.$init$((Iterator)this);
            this.filesToDelete = new Queue();
            this.maybeDeleteFiles = new ArrayBuffer();
            this.hasNextCalled = false;
            this.init();
        }
    }
}

