/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_LOG_STORE_CLASS$;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.sql.Timestamp;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.CommitStats;
import org.apache.spark.sql.delta.ConcurrentTransactionException;
import org.apache.spark.sql.delta.ConcurrentWriteException;
import org.apache.spark.sql.delta.DeltaConcurrentModificationException;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.MetadataChangedException;
import org.apache.spark.sql.delta.OptimisticTransactionImpl;
import org.apache.spark.sql.delta.OptimisticTransactionImpl$;
import org.apache.spark.sql.delta.OptimisticTransactionImpl$$anonfun$checkAndRetry$1$;
import org.apache.spark.sql.delta.OptimisticTransactionImpl$$anonfun$org$apache$spark$sql$delta$OptimisticTransactionImpl$;
import org.apache.spark.sql.delta.ProtocolChangedException;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.util.control.NonFatal$;

public abstract class OptimisticTransactionImpl$class {
    public static SparkSession spark(OptimisticTransactionImpl $this) {
        return SparkSession$.MODULE$.active();
    }

    public static long readVersion(OptimisticTransactionImpl $this) {
        return $this.snapshot().version();
    }

    public static Metadata metadata(OptimisticTransactionImpl $this) {
        return (Metadata)$this.newMetadata().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;

            public final Metadata apply() {
                return this.$outer.snapshotMetadata();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void updateMetadata(OptimisticTransactionImpl $this, Metadata metadata2) {
        Metadata metadata3;
        Predef$.MODULE$.assert(!$this.hasWritten(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot update the metadata in a transaction that has already written data.";
            }
        });
        Predef$.MODULE$.assert($this.newMetadata().isEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot change the metadata more than once in a transaction.";
            }
        });
        if ($this.readVersion() == -1L) {
            Map<String, String> updatedConfigs;
            Map<String, String> x$21 = updatedConfigs = DeltaConfigs$.MODULE$.mergeGlobalConfigs($this.spark().sessionState().conf(), metadata2.configuration(), new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2()));
            String x$22 = metadata2.copy$default$1();
            String x$23 = metadata2.copy$default$2();
            String x$24 = metadata2.copy$default$3();
            Format x$25 = metadata2.copy$default$4();
            String x$26 = metadata2.copy$default$5();
            Seq<String> x$27 = metadata2.copy$default$6();
            Option<Object> x$28 = metadata2.copy$default$8();
            metadata3 = metadata2.copy(x$22, x$23, x$24, x$25, x$26, x$27, x$21, x$28);
        } else {
            metadata3 = metadata2;
        }
        Metadata updatedMetadata = metadata3;
        $this.verifyNewMetadata(updatedMetadata);
        $this.newMetadata_$eq((Option<Metadata>)new Some((Object)updatedMetadata));
    }

    public static void verifyNewMetadata(OptimisticTransactionImpl $this, Metadata metadata2) {
        SchemaUtils$.MODULE$.checkColumnNameDuplication(metadata2.schema(), "in the metadata update");
        ParquetSchemaConverter$.MODULE$.checkFieldNames(SchemaUtils$.MODULE$.explodeNestedFieldNames(metadata2.dataSchema()));
    }

    public static Seq filterFiles(OptimisticTransactionImpl $this) {
        return $this.filterFiles((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
    }

    public static Seq filterFiles(OptimisticTransactionImpl $this, Seq filters) {
        $this.dependsOnFiles_$eq(true);
        return $this.snapshot().filesForScan((Seq<Attribute>)Nil$.MODULE$, (Seq<Expression>)filters, $this.snapshot().filesForScan$default$3()).files();
    }

    public static void readWholeTable(OptimisticTransactionImpl $this) {
        $this.dependsOnFiles_$eq(true);
    }

    public static long txnVersion(OptimisticTransactionImpl $this, String id) {
        $this.readTxn().$plus$eq((Object)id);
        return BoxesRunTime.unboxToLong((Object)$this.snapshot().transactions().getOrElse((Object)id, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
    }

    public static long commit(OptimisticTransactionImpl $this, Seq actions, DeltaOperations.Operation op) throws ConcurrentModificationException {
        return BoxesRunTime.unboxToLong($this.recordDeltaOperation($this.deltaLog(), "delta.commit", $this.recordDeltaOperation$default$3(), new Serializable($this, actions, op){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;
            private final Seq actions$2;
            private final DeltaOperations.Operation op$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            /*
             * WARNING - void declaration
             */
            public long apply$mcJ$sp() {
                try {
                    void var1_6;
                    boolean isBlindAppend;
                    Seq finalActions = this.$outer.prepareCommit((Seq<Action>)this.actions$2, this.op$1);
                    boolean onlyAddFiles = ((IterableLike)finalActions.collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 instanceof FileAction) {
                                FileAction fileAction = (FileAction)A1;
                                object = fileAction;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Action x1) {
                            Action action = x1;
                            boolean bl = action instanceof FileAction;
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(FileAction x$1) {
                            return x$1 instanceof AddFile;
                        }
                    });
                    boolean bl = isBlindAppend = onlyAddFiles && !this.$outer.dependsOnFiles();
                    if (BoxesRunTime.unboxToBoolean((Object)this.$outer.spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_COMMIT_INFO_ENABLED()))) {
                        this.$outer.commitInfo_$eq(CommitInfo$.MODULE$.apply(this.$outer.clock().getTimeMillis(), this.op$1.name(), this.op$1.jsonEncodedValues(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.$outer.readVersion())).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(long x$2) {
                                return this.apply$mcZJ$sp(x$2);
                            }

                            public boolean apply$mcZJ$sp(long x$2) {
                                return x$2 >= 0L;
                            }
                        }), (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)isBlindAppend))));
                        CommitInfo commitInfo = this.$outer.commitInfo();
                        finalActions = (Seq)finalActions.$plus$colon((Object)commitInfo, Seq$.MODULE$.canBuildFrom());
                    }
                    long commitVersion = OptimisticTransactionImpl$class.org$apache$spark$sql$delta$OptimisticTransactionImpl$$doCommit(this.$outer, this.$outer.snapshot().version() + 1L, finalActions, 0);
                    this.$outer.logInfo((Function0)new Serializable(this, commitVersion){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ OptimisticTransactionImpl$.anonfun.commit.1 $outer;
                        private final long commitVersion$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed delta #", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.commitVersion$1), this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().logPath()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.commitVersion$1 = commitVersion$1;
                        }
                    });
                    this.$outer.postCommit(commitVersion, finalActions);
                    long version = commitVersion;
                    return (long)var1_6;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof DeltaConcurrentModificationException) {
                        DeltaConcurrentModificationException deltaConcurrentModificationException = (DeltaConcurrentModificationException)throwable2;
                        this.$outer.recordDeltaEvent(this.$outer.deltaLog(), new StringBuilder().append((Object)"delta.commit.conflict.").append((Object)deltaConcurrentModificationException.conflictType()).toString(), this.$outer.recordDeltaEvent$default$3(), this.$outer.recordDeltaEvent$default$4());
                        throw deltaConcurrentModificationException;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    DeltaLog x$29 = this.$outer.deltaLog();
                    String x$30 = "delta.commit.failure";
                    Map x$31 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString(e))}));
                    Map<TagDefinition, String> x$32 = this.$outer.recordDeltaEvent$default$3();
                    this.$outer.recordDeltaEvent(x$29, x$30, x$32, x$31);
                    throw e;
                }
            }

            public /* synthetic */ OptimisticTransactionImpl org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.actions$2 = actions$2;
                this.op$1 = op$1;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static Seq prepareCommit(OptimisticTransactionImpl $this, Seq actions, DeltaOperations.Operation op) {
        void var3_3;
        Predef$.MODULE$.assert(!$this.committed(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Transaction already committed.";
            }
        });
        Seq finalActions = (Seq)Option$.MODULE$.option2Iterable($this.newMetadata()).toSeq().$plus$plus((GenTraversableOnce)actions, Seq$.MODULE$.canBuildFrom());
        Seq metadataChanges = (Seq)finalActions.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Metadata) {
                    Metadata metadata2 = (Metadata)A1;
                    object = metadata2;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x2) {
                Action action = x2;
                boolean bl = action instanceof Metadata;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(metadataChanges.length() <= 1, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot change the metadata more than once in a transaction.";
            }
        });
        metadataChanges.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;

            public final void apply(Metadata m) {
                this.$outer.verifyNewMetadata(m);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if ($this.snapshot().version() == -1L) {
            $this.deltaLog().ensureLogDirectoryExist();
            if (!finalActions.exists((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Action x$4) {
                    return x$4 instanceof Protocol;
                }
            })) {
                Protocol protocol = new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2());
                finalActions = (Seq)finalActions.$plus$colon((Object)protocol, Seq$.MODULE$.canBuildFrom());
            }
        }
        finalActions = (Seq)finalActions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Action apply(Action x0$1) {
                Map<String, String> updatedConf;
                Action action = x0$1;
                if (!(action instanceof Metadata)) return action;
                Metadata metadata2 = (Metadata)action;
                if (this.$outer.snapshot().version() != -1L) return action;
                Map<String, String> x$33 = updatedConf = DeltaConfigs$.MODULE$.mergeGlobalConfigs(this.$outer.spark().sessionState().conf(), metadata2.configuration(), new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2()));
                String x$34 = metadata2.copy$default$1();
                String x$35 = metadata2.copy$default$2();
                String x$36 = metadata2.copy$default$3();
                Format x$37 = metadata2.copy$default$4();
                String x$38 = metadata2.copy$default$5();
                Seq<String> x$39 = metadata2.copy$default$6();
                Option<Object> x$40 = metadata2.copy$default$8();
                return metadata2.copy(x$34, x$35, x$36, x$37, x$38, x$39, x$33, x$40);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        $this.deltaLog().protocolWrite($this.snapshot().protocol(), !actions.headOption().exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Action x$6) {
                return x$6 instanceof Protocol;
            }
        }));
        Seq removes = (Seq)actions.collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof RemoveFile) {
                    RemoveFile removeFile = (RemoveFile)A1;
                    object = removeFile;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x3) {
                Action action = x3;
                boolean bl = action instanceof RemoveFile;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (removes.exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RemoveFile x$7) {
                return x$7.dataChange();
            }
        })) {
            $this.deltaLog().assertRemovable();
        }
        return var3_3;
    }

    public static void postCommit(OptimisticTransactionImpl $this, long commitVersion, Seq commitActions) {
        $this.committed_$eq(true);
        if (commitVersion != 0L && commitVersion % (long)$this.deltaLog().checkpointInterval() == 0L) {
            try {
                $this.deltaLog().checkpoint();
            }
            catch (IllegalStateException illegalStateException) {
                $this.logWarning((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Failed to checkpoint table state.";
                    }
                }, illegalStateException);
            }
        }
    }

    public static long org$apache$spark$sql$delta$OptimisticTransactionImpl$$doCommit(OptimisticTransactionImpl $this, long attemptVersion, Seq actions, int attemptNumber) {
        return BoxesRunTime.unboxToLong($this.deltaLog().lockInterruptibly(new Serializable($this, attemptVersion, actions, attemptNumber){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;
            public final long attemptVersion$1;
            public final Seq actions$1;
            private final int attemptNumber$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                long l;
                try {
                    this.$outer.logDebug((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ OptimisticTransactionImpl$$anonfun$org$apache$spark$sql$delta$OptimisticTransactionImpl$.doCommit.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to commit version ", " with ", " actions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.attemptVersion$1), BoxesRunTime.boxToInteger((int)this.$outer.actions$1.size())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.deltaLog().store().write(FileNames$.MODULE$.deltaFile(this.$outer.deltaLog().logPath(), this.attemptVersion$1), (Iterator<String>)((IterableLike)this.actions$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Action x$8) {
                            return x$8.json();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toIterator(), this.$outer.deltaLog().store().write$default$3());
                    long commitTime = System.nanoTime();
                    Snapshot postCommitSnapshot = this.$outer.deltaLog().update(this.$outer.deltaLog().update$default$1());
                    if (postCommitSnapshot.version() < this.attemptVersion$1) {
                        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The committed version is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.attemptVersion$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the current version is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)postCommitSnapshot.version())}))).toString());
                    }
                    IntRef numAbsolutePaths = IntRef.create((int)0);
                    ObjectRef pathHolder = ObjectRef.create(null);
                    HashSet distinctPartitions = new HashSet();
                    Seq adds = (Seq)this.actions$1.collect((PartialFunction)new Serializable(this, numAbsolutePaths, pathHolder, distinctPartitions){
                        public static final long serialVersionUID = 0L;
                        private final IntRef numAbsolutePaths$1;
                        private final ObjectRef pathHolder$1;
                        private final HashSet distinctPartitions$1;

                        public final <A1 extends Action, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x4;
                            if (A1 instanceof AddFile) {
                                AddFile addFile = (AddFile)A1;
                                this.pathHolder$1.elem = new Path(new URI(addFile.path()));
                                if (((Path)this.pathHolder$1.elem).isAbsolute()) {
                                    ++this.numAbsolutePaths$1.elem;
                                }
                                this.distinctPartitions$1.$plus$eq(addFile.partitionValues());
                                object = addFile;
                            } else {
                                object = function1.apply(x4);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Action x4) {
                            Action action = x4;
                            boolean bl = action instanceof AddFile;
                            return bl;
                        }
                        {
                            this.numAbsolutePaths$1 = numAbsolutePaths$1;
                            this.pathHolder$1 = pathHolder$1;
                            this.distinctPartitions$1 = distinctPartitions$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    CommitStats stats = new CommitStats(this.$outer.snapshot().version(), this.attemptVersion$1, postCommitSnapshot.version(), TimeUnit.NANOSECONDS.toMillis(commitTime - this.$outer.txnStartNano()), TimeUnit.NANOSECONDS.toMillis(commitTime - this.$outer.commitStartNano()), adds.size(), ((SeqLike)this.actions$1.collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Action, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x5;
                            if (A1 instanceof RemoveFile) {
                                RemoveFile removeFile = (RemoveFile)A1;
                                object = removeFile;
                            } else {
                                object = function1.apply(x5);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Action x5) {
                            Action action = x5;
                            boolean bl = action instanceof RemoveFile;
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).size(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)adds.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(AddFile x$9) {
                            return x$9.dataChange();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(AddFile x$10) {
                            return x$10.size();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), postCommitSnapshot.numOfFiles(), postCommitSnapshot.sizeInBytes(), postCommitSnapshot.protocol(), (CommitInfo)Option$.MODULE$.apply((Object)this.$outer.commitInfo()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final CommitInfo apply(CommitInfo x$11) {
                            None$ x$41 = None$.MODULE$;
                            None$ x$42 = None$.MODULE$;
                            Option<Object> x$43 = x$11.copy$default$1();
                            Timestamp x$44 = x$11.copy$default$2();
                            Option<String> x$45 = x$11.copy$default$3();
                            Option<String> x$46 = x$11.copy$default$4();
                            String x$47 = x$11.copy$default$5();
                            Map<String, String> x$48 = x$11.copy$default$6();
                            Option<JobInfo> x$49 = x$11.copy$default$7();
                            Option<NotebookInfo> x$50 = x$11.copy$default$8();
                            Option<String> x$51 = x$11.copy$default$9();
                            Option<Object> x$52 = x$11.copy$default$12();
                            return x$11.copy(x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, (Option<Object>)x$41, (Option<String>)x$42, x$52);
                        }
                    }).orNull(Predef$.MODULE$.$conforms()), this.$outer.newMetadata(), numAbsolutePaths.elem, distinctPartitions.size(), null);
                    DeltaLog x$53 = this.$outer.deltaLog();
                    String x$54 = "delta.commit.stats";
                    CommitStats x$55 = stats;
                    Map<TagDefinition, String> x$56 = this.$outer.recordDeltaEvent$default$3();
                    this.$outer.recordDeltaEvent(x$53, x$54, x$56, x$55);
                    l = this.attemptVersion$1;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    l = this.$outer.checkAndRetry(this.attemptVersion$1, (Seq<Action>)this.actions$1, this.attemptNumber$1);
                }
                return l;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.attemptVersion$1 = attemptVersion$1;
                this.actions$1 = actions$1;
                this.attemptNumber$1 = attemptNumber$1;
            }
        }));
    }

    public static long checkAndRetry(OptimisticTransactionImpl $this, long checkVersion, Seq actions, int attemptNumber) {
        return BoxesRunTime.unboxToLong($this.recordDeltaOperation($this.deltaLog(), "delta.commit.retry", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_LOG_STORE_CLASS$.MODULE$), (Object)$this.deltaLog().store().getClass().getName())}))), new Serializable($this, checkVersion, actions, attemptNumber){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OptimisticTransactionImpl $outer;
            public final long checkVersion$1;
            public final Seq actions$3;
            private final int attemptNumber$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                this.$outer.deltaLog().update(this.$outer.deltaLog().update$default$1());
                long nextAttempt = this.$outer.deltaLog().snapshot().version() + 1L;
                new RichLong(Predef$.MODULE$.longWrapper(this.checkVersion$1)).until((Object)BoxesRunTime.boxToLong((long)nextAttempt)).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OptimisticTransactionImpl$.anonfun.checkAndRetry.1 $outer;

                    public final void apply(long version) {
                        this.apply$mcVJ$sp(version);
                    }

                    public void apply$mcVJ$sp(long version) {
                        Seq winningCommitActions = (Seq)this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().store().read(FileNames$.MODULE$.deltaFile(this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().logPath(), version)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Action apply(String json) {
                                return Action$.MODULE$.fromJson(json);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq metadataUpdates = (Seq)winningCommitActions.collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Action, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x6;
                                if (A1 instanceof Metadata) {
                                    Metadata metadata2 = (Metadata)A1;
                                    object = metadata2;
                                } else {
                                    object = function1.apply(x6);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Action x6) {
                                Action action = x6;
                                boolean bl = action instanceof Metadata;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq txns = (Seq)winningCommitActions.collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Action, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x7;
                                if (A1 instanceof SetTransaction) {
                                    SetTransaction setTransaction = (SetTransaction)A1;
                                    object = setTransaction;
                                } else {
                                    object = function1.apply(x7);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Action x7) {
                                Action action = x7;
                                boolean bl = action instanceof SetTransaction;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq protocol = (Seq)winningCommitActions.collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Action, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x8;
                                if (A1 instanceof Protocol) {
                                    Protocol protocol = (Protocol)A1;
                                    object = protocol;
                                } else {
                                    object = function1.apply(x8);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Action x8) {
                                Action action = x8;
                                boolean bl = action instanceof Protocol;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Option commitInfo = winningCommitActions.collectFirst((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Action, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x9;
                                if (A1 instanceof CommitInfo) {
                                    CommitInfo commitInfo = (CommitInfo)A1;
                                    object = commitInfo;
                                } else {
                                    object = function1.apply(x9);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Action x9) {
                                Action action = x9;
                                boolean bl = action instanceof CommitInfo;
                                return bl;
                            }
                        }).map((Function1)new Serializable(this, version){
                            public static final long serialVersionUID = 0L;
                            private final long version$1;

                            public final CommitInfo apply(CommitInfo ci) {
                                return ci.copy((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.version$1)), ci.copy$default$2(), ci.copy$default$3(), ci.copy$default$4(), ci.copy$default$5(), ci.copy$default$6(), ci.copy$default$7(), ci.copy$default$8(), ci.copy$default$9(), ci.copy$default$10(), ci.copy$default$11(), ci.copy$default$12());
                            }
                            {
                                this.version$1 = version$1;
                            }
                        });
                        Seq fileActions = (Seq)winningCommitActions.collect((PartialFunction)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final <A1 extends Action, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x10;
                                if (A1 instanceof FileAction) {
                                    FileAction fileAction = (FileAction)A1;
                                    object = fileAction;
                                } else {
                                    object = function1.apply(x10);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Action x10) {
                                Action action = x10;
                                boolean bl = action instanceof FileAction;
                                return bl;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        if (protocol.nonEmpty()) {
                            protocol.foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ OptimisticTransactionImpl$$anonfun$checkAndRetry$1$.anonfun.apply.mcJ.sp.1 $outer;

                                public final void apply(Protocol p) {
                                    this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$anonfun$$$outer().org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().protocolRead(p);
                                    this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$anonfun$$$outer().org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().protocolWrite(p, this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$anonfun$$$outer().org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().deltaLog().protocolWrite$default$2());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            this.$outer.actions$3.foreach((Function1)new Serializable(this, commitInfo){
                                public static final long serialVersionUID = 0L;
                                private final Option commitInfo$1;

                                public final void apply(Action x0$2) {
                                    Action action = x0$2;
                                    if (action instanceof Protocol) {
                                        throw new ProtocolChangedException((Option<CommitInfo>)this.commitInfo$1);
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                {
                                    this.commitInfo$1 = commitInfo$1;
                                }
                            });
                        }
                        if (metadataUpdates.nonEmpty()) {
                            throw new MetadataChangedException((Option<CommitInfo>)commitInfo);
                        }
                        if (this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().dependsOnFiles() && fileActions.nonEmpty()) {
                            throw new ConcurrentWriteException((Option<CommitInfo>)commitInfo);
                        }
                        Set txnOverlap = (Set)((TraversableOnce)txns.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(SetTransaction x$12) {
                                return x$12.appId();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toSet().intersect((GenSet)this.$outer.org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer().readTxn().toSet());
                        if (txnOverlap.nonEmpty()) {
                            throw new ConcurrentTransactionException((Option<CommitInfo>)commitInfo);
                        }
                    }

                    public /* synthetic */ OptimisticTransactionImpl$.anonfun.checkAndRetry.1 org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.logInfo((Function0)new Serializable(this, nextAttempt){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ OptimisticTransactionImpl$.anonfun.checkAndRetry.1 $outer;
                    private final long nextAttempt$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No logical conflicts with deltas [", ", ", "), retrying."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.checkVersion$1), BoxesRunTime.boxToLong((long)this.nextAttempt$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextAttempt$1 = nextAttempt$1;
                    }
                });
                return OptimisticTransactionImpl$class.org$apache$spark$sql$delta$OptimisticTransactionImpl$$doCommit(this.$outer, nextAttempt, this.actions$3, this.attemptNumber$2 + 1);
            }

            public /* synthetic */ OptimisticTransactionImpl org$apache$spark$sql$delta$OptimisticTransactionImpl$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.checkVersion$1 = checkVersion$1;
                this.actions$3 = actions$3;
                this.attemptNumber$2 = attemptNumber$2;
            }
        }));
    }

    public static void $init$(OptimisticTransactionImpl $this) {
        Metadata metadata2;
        $this.org$apache$spark$sql$delta$OptimisticTransactionImpl$_setter_$_spark_$eq($this.spark());
        $this.org$apache$spark$sql$delta$OptimisticTransactionImpl$_setter_$protocol_$eq($this.snapshot().protocol());
        $this.org$apache$spark$sql$delta$OptimisticTransactionImpl$_setter_$readTxn_$eq(new ArrayBuffer());
        $this.committed_$eq(false);
        $this.newMetadata_$eq((Option<Metadata>)None$.MODULE$);
        $this.org$apache$spark$sql$delta$OptimisticTransactionImpl$_setter_$txnStartNano_$eq(System.nanoTime());
        $this.commitStartNano_$eq(-1L);
        $this.dependsOnFiles_$eq(false);
        if ($this.readVersion() == -1L) {
            Map<String, String> updatedConfig;
            Map<String, String> x$13 = updatedConfig = DeltaConfigs$.MODULE$.mergeGlobalConfigs($this.spark().sessionState().conf(), (Map<String, String>)Predef$.MODULE$.Map().empty(), new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2()));
            String x$14 = Metadata$.MODULE$.apply$default$1();
            String x$15 = Metadata$.MODULE$.apply$default$2();
            String x$16 = Metadata$.MODULE$.apply$default$3();
            Format x$17 = Metadata$.MODULE$.apply$default$4();
            String x$18 = Metadata$.MODULE$.apply$default$5();
            Seq<String> x$19 = Metadata$.MODULE$.apply$default$6();
            Option<Object> x$20 = Metadata$.MODULE$.apply$default$8();
            metadata2 = new Metadata(x$14, x$15, x$16, x$17, x$18, x$19, x$13, x$20);
        } else {
            metadata2 = $this.snapshot().metadata();
        }
        $this.org$apache$spark$sql$delta$OptimisticTransactionImpl$_setter_$snapshotMetadata_$eq(metadata2);
    }
}

