/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.OptimisticTransactionImpl;
import org.apache.spark.sql.delta.files.DelayedCommitProtocol;
import org.apache.spark.sql.delta.files.TransactionalWrite$;
import org.apache.spark.sql.delta.schema.DeltaInvariantCheckerExec;
import org.apache.spark.sql.delta.schema.Invariant;
import org.apache.spark.sql.delta.schema.Invariants$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.Nothing$;

public abstract class TransactionalWrite$class {
    public static DelayedCommitProtocol getCommitter(OptimisticTransactionImpl $this, Path outputPath) {
        return new DelayedCommitProtocol("delta", outputPath.toString(), (Option<Object>)None$.MODULE$);
    }

    public static Tuple2 normalizeData(OptimisticTransactionImpl $this, Dataset data, Seq partitionCols) {
        Dataset<Row> normalizedData = SchemaUtils$.MODULE$.normalizeColumnNames($this.metadata().schema(), data);
        Dataset<Row> cleanedData = SchemaUtils$.MODULE$.dropNullTypeColumns(normalizedData);
        StructType structType = cleanedData.schema();
        StructType structType2 = normalizedData.schema();
        QueryExecution queryExecution = !(structType != null ? !structType.equals(structType2) : structType2 != null) ? data.queryExecution() : cleanedData.queryExecution();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)queryExecution), (Object)cleanedData.queryExecution().analyzed().output());
    }

    public static Seq getPartitioningColumns(OptimisticTransactionImpl $this, StructType partitionSchema2, Seq output, boolean colsDropped) {
        Seq partitionColumns = (Seq)partitionSchema2.map((Function1)new Serializable($this, output){
            public static final long serialVersionUID = 0L;
            public final Seq output$2;

            public final Attribute apply(StructField col) {
                return (Attribute)this.output$2.find((Function1)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final StructField col$1;

                    public final boolean apply(Attribute f) {
                        String string = f.name();
                        String string2 = this.col$1.name();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.col$1 = col$1;
                    }
                }).getOrElse((Function0)new Serializable(this, col){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TransactionalWrite$.anonfun.1 $outer;
                    private final StructField col$1;

                    public final Nothing$ apply() {
                        throw DeltaErrors$.MODULE$.partitionColumnNotFoundException(this.col$1.name(), (Seq<Attribute>)this.$outer.output$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                    }
                });
            }
            {
                this.output$2 = output$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (partitionColumns.nonEmpty() && partitionColumns.length() == output.length()) {
            throw DeltaErrors$.MODULE$.nonPartitionColumnAbsentException(colsDropped);
        }
        return partitionColumns;
    }

    public static Seq writeFiles(OptimisticTransactionImpl $this, Dataset data) {
        return $this.writeFiles(data, (Option<DeltaOptions>)None$.MODULE$, false);
    }

    public static Seq writeFiles(OptimisticTransactionImpl $this, Dataset data, Option writeOptions) {
        return $this.writeFiles(data, (Option<DeltaOptions>)writeOptions, false);
    }

    public static Seq writeFiles(OptimisticTransactionImpl $this, Dataset data, boolean isOptimize) {
        return $this.writeFiles(data, (Option<DeltaOptions>)None$.MODULE$, isOptimize);
    }

    public static Seq writeFiles(OptimisticTransactionImpl $this, Dataset data, Option writeOptions, boolean isOptimize) {
        $this.hasWritten_$eq(true);
        SparkSession spark = data.sparkSession();
        StructType partitionSchema2 = $this.metadata().partitionSchema();
        Path outputPath = $this.deltaLog().dataPath();
        Tuple2<QueryExecution, Seq<Attribute>> tuple2 = $this.normalizeData(data, $this.metadata().partitionColumns());
        if (tuple2 != null) {
            Seq output;
            Tuple2 tuple22;
            QueryExecution queryExecution = (QueryExecution)tuple2._1();
            Seq output2 = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)queryExecution, (Object)output2);
            QueryExecution queryExecution2 = (QueryExecution)tuple23._1();
            Seq<Attribute> partitioningColumns = $this.getPartitioningColumns(partitionSchema2, (Seq<Attribute>)output, (output = (Seq)tuple23._2()).length() < data.schema().size());
            DelayedCommitProtocol committer = $this.getCommitter(outputPath);
            Seq<Invariant> invariants = Invariants$.MODULE$.getFromSchema($this.metadata().schema(), spark);
            SQLExecution$.MODULE$.withNewExecutionId(spark, queryExecution2, (Function0)new Serializable($this, spark, outputPath, queryExecution2, output, partitioningColumns, committer, invariants){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OptimisticTransactionImpl $outer;
                private final SparkSession spark$1;
                private final Path outputPath$1;
                private final QueryExecution queryExecution$1;
                private final Seq output$1;
                private final Seq partitioningColumns$1;
                private final DelayedCommitProtocol committer$1;
                private final Seq invariants$1;

                public final Set<String> apply() {
                    FileFormatWriter.OutputSpec outputSpec = new FileFormatWriter.OutputSpec(this.outputPath$1.toString(), Predef$.MODULE$.Map().empty(), this.output$1);
                    DeltaInvariantCheckerExec physicalPlan = new DeltaInvariantCheckerExec(this.queryExecution$1.executedPlan(), (Seq<Invariant>)this.invariants$1);
                    return FileFormatWriter$.MODULE$.write(this.spark$1, (SparkPlan)physicalPlan, this.$outer.snapshot().fileFormat(), (FileCommitProtocol)this.committer$1, outputSpec, this.spark$1.sessionState().newHadoopConfWithOptions(this.$outer.metadata().configuration()), this.partitioningColumns$1, (Option)None$.MODULE$, (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.spark$1 = spark$1;
                    this.outputPath$1 = outputPath$1;
                    this.queryExecution$1 = queryExecution$1;
                    this.output$1 = output$1;
                    this.partitioningColumns$1 = partitioningColumns$1;
                    this.committer$1 = committer$1;
                    this.invariants$1 = invariants$1;
                }
            });
            return committer.addedStatuses();
        }
        throw new MatchError(tuple2);
    }

    public static void $init$(OptimisticTransactionImpl $this) {
        $this.hasWritten_$eq(false);
    }
}

