/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$class;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001=\u0011A\u0002\u0013#G'2{wm\u0015;pe\u0016T!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006I\u0016dG/\u0019\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\tAAj\\4Ti>\u0014X\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002\u001e=5\t\u0001\"\u0003\u0002 \u0011\tI1\u000b]1sW\u000e{gN\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005\tB-\u001a4bk2$\b*\u00193p_B\u001cuN\u001c4\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B2p]\u001aT!a\n\u0006\u0002\r!\fGm\\8q\u0013\tICEA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075rs\u0006\u0005\u0002\u0018\u0001!)1D\u000ba\u00019!)\u0011E\u000ba\u0001E!)1\u0006\u0001C\u0001cQ\u0011QF\r\u0005\u0006gA\u0002\r\u0001N\u0001\u0003g\u000e\u0004\"!H\u001b\n\u0005YB!\u0001D*qCJ\\7i\u001c8uKb$\b\"\u0002\u001d\u0001\t#I\u0014aE4fi\u0006\u001bG/\u001b<f\u0011\u0006$wn\u001c9D_:4W#\u0001\u0012\t\u000bm\u0002A\u0011\u0003\u001f\u0002\u001d\u001d,GOR5mK\u000e{g\u000e^3yiR\u0011Qh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u001a\n!AZ:\n\u0005\t{$a\u0003$jY\u0016\u001cuN\u001c;fqRDQ\u0001\u0012\u001eA\u0002\u0015\u000bA\u0001]1uQB\u0011aHR\u0005\u0003\u000f~\u0012A\u0001U1uQ\")\u0011\n\u0001C!\u0015\u0006!!/Z1e)\tYe\fE\u0002M)^s!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005As\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\t\u0019&#A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&aA*fc*\u00111K\u0005\t\u00031ns!!E-\n\u0005i\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\n\t\u000b\u0011C\u0005\u0019A#\t\u000b\u0001\u0004A\u0011A1\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\t,gm\u001b\t\u0003#\rL!\u0001\u001a\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006\t~\u0003\r!\u0012\u0005\u0006O~\u0003\r\u0001[\u0001\bC\u000e$\u0018n\u001c8t!\ra\u0015nV\u0005\u0003UZ\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bY~\u0003\n\u00111\u0001n\u0003%yg/\u001a:xe&$X\r\u0005\u0002\u0012]&\u0011qN\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\t\b\u0001\"\u0003s\u000359(/\u001b;f\u0013:$XM\u001d8bYR!!m\u001d;v\u0011\u0015!\u0005\u000f1\u0001F\u0011\u00159\u0007\u000f1\u0001i\u0011\u0015a\u0007\u000f1\u0001n\u0011\u00159\b\u0001\"\u0003y\u00039\u0019'/Z1uKR+W\u000e\u001d)bi\"$\"!R=\t\u000b\u00113\b\u0019A#\t\u000bm\u0004A\u0011\t?\u0002\u00111L7\u000f\u001e$s_6$2!`A\u0002!\ra\u0015N \t\u0003}}L1!!\u0001@\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006\tj\u0004\r!\u0012\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0003=IgN^1mS\u0012\fG/Z\"bG\",G#\u00012\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010\u0005a\"/Z:pYZ,\u0007+\u0019;i\u001f:\u0004\u0006._:jG\u0006d7\u000b^8sC\u001e,GcA#\u0002\u0012!1A)a\u0003A\u0002\u0015Cq!!\u0006\u0001\t\u0003\n9\"A\u000bjgB\u000b'\u000f^5bY^\u0013\u0018\u000e^3WSNL'\r\\3\u0015\u00075\fI\u0002\u0003\u0004E\u0003'\u0001\r!\u0012\u0005\n\u0003;\u0001\u0011\u0013!C!\u0003?\tqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003CQ3!\\A\u0012W\t\t)\u0003\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0018%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0012\u0011\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class HDFSLogStore
implements LogStore {
    public final Configuration org$apache$spark$sql$delta$storage$HDFSLogStore$$defaultHadoopConf;

    @Override
    public final Seq<String> read(String path) {
        return LogStore$class.read(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore$class.write(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore$class.listFrom(this, path);
    }

    public Configuration getActiveHadoopConf() {
        return (Configuration)SparkSession$.MODULE$.getActiveSession().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Configuration apply(SparkSession x$1) {
                return x$1.sessionState().newHadoopConf();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSLogStore $outer;

            public final Configuration apply() {
                return this.$outer.org$apache$spark$sql$delta$storage$HDFSLogStore$$defaultHadoopConf;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public FileContext getFileContext(Path path) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)this.getActiveHadoopConf());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        FSDataInputStream stream = this.getFileContext(path).open(path);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$2) {
                    return x$2.trim();
                }
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        stream.close();
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        boolean isLocalFs = path.getFileSystem(this.getActiveHadoopConf()) instanceof RawLocalFileSystem;
        if (!isLocalFs) {
            this.writeInternal(path, actions, overwrite);
            return;
        }
        HDFSLogStore hDFSLogStore = this;
        synchronized (hDFSLogStore) {
            this.writeInternal(path, actions, overwrite);
            return;
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private void writeInternal(Path path, Iterator<String> actions, boolean overwrite) {
        FileContext fc = this.getFileContext(path);
        if (!overwrite && fc.util().exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$3) {
                    return new StringBuilder().append((Object)x$3).append((Object)"\n").toString();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$4) {
                    return x$4.getBytes(StandardCharsets.UTF_8);
                }
            }).foreach((Function1)new Serializable(this, stream){
                public static final long serialVersionUID = 0L;
                private final FSDataOutputStream stream$1;

                public final void apply(byte[] x$1) {
                    this.stream$1.write(x$1);
                }
                {
                    this.stream$1 = stream$1;
                }
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path, new Options.Rename[]{renameOpt});
                renameDone = true;
                return;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
    }

    private Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getName(), UUID.randomUUID()})));
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        FileContext fc = this.getFileContext(path);
        if (fc.util().exists(path.getParent())) {
            FileStatus[] files = fc.util().listStatus(path.getParent());
            return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files).filter((Function1)new Serializable(this, path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final boolean apply(FileStatus x$5) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$5.getPath().getName())).$greater$eq((Object)this.path$1.getName());
                }
                {
                    this.path$1 = path$1;
                }
            })).sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$6) {
                    return x$6.getPath().getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).iterator();
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path.getParent()})));
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return this.getFileContext(path).makeQualified(path);
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    public HDFSLogStore(SparkConf sparkConf, Configuration defaultHadoopConf) {
        this.org$apache$spark$sql$delta$storage$HDFSLogStore$$defaultHadoopConf = defaultHadoopConf;
        LogStore$class.$init$(this);
    }

    public HDFSLogStore(SparkContext sc) {
        this(sc.getConf(), sc.hadoopConfiguration());
    }
}

