/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.delta.util.TimestampFormatter;

public final class DateTimeUtils$ {
    public static final DateTimeUtils$ MODULE$;
    private final long NANOS_PER_MICROS;
    private final long MICROS_PER_MILLIS;
    private final long MILLIS_PER_SECOND;
    private final long SECONDS_PER_DAY;
    private final long MICROS_PER_SECOND;
    private final long NANOS_PER_MILLIS;
    private final long NANOS_PER_SECOND;
    private final long MICROS_PER_DAY;
    private final long MILLIS_PER_MINUTE;
    private final long MILLIS_PER_HOUR;
    private final long MILLIS_PER_DAY;

    static {
        new DateTimeUtils$();
    }

    public final long NANOS_PER_MICROS() {
        return this.NANOS_PER_MICROS;
    }

    public final long MICROS_PER_MILLIS() {
        return this.MICROS_PER_MILLIS;
    }

    public final long MILLIS_PER_SECOND() {
        return this.MILLIS_PER_SECOND;
    }

    public final long SECONDS_PER_DAY() {
        return this.SECONDS_PER_DAY;
    }

    public final long MICROS_PER_SECOND() {
        return this.MICROS_PER_SECOND;
    }

    public final long NANOS_PER_MILLIS() {
        return this.NANOS_PER_MILLIS;
    }

    public final long NANOS_PER_SECOND() {
        return this.NANOS_PER_SECOND;
    }

    public final long MICROS_PER_DAY() {
        return this.MICROS_PER_DAY;
    }

    public final long MILLIS_PER_MINUTE() {
        return this.MILLIS_PER_MINUTE;
    }

    public final long MILLIS_PER_HOUR() {
        return this.MILLIS_PER_HOUR;
    }

    public final long MILLIS_PER_DAY() {
        return this.MILLIS_PER_DAY;
    }

    public TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    public TimeZone getTimeZone(String timeZoneId) {
        ZoneId zoneId = ZoneId.of(timeZoneId, ZoneId.SHORT_IDS);
        return TimeZone.getTimeZone(zoneId);
    }

    public String timestampToString(TimestampFormatter tf, long us) {
        return tf.format(us);
    }

    public long instantToMicros(Instant instant) {
        long us = Math.multiplyExact(instant.getEpochSecond(), this.MICROS_PER_SECOND());
        long result = Math.addExact(us, TimeUnit.NANOSECONDS.toMicros(instant.getNano()));
        return result;
    }

    public Instant microsToInstant(long us) {
        long secs = Math.floorDiv(us, this.MICROS_PER_SECOND());
        long mos = Math.floorMod(us, this.MICROS_PER_SECOND());
        return Instant.ofEpochSecond(secs, mos * this.NANOS_PER_MICROS());
    }

    public int instantToDays(Instant instant) {
        long seconds = instant.getEpochSecond();
        long days = Math.floorDiv(seconds, this.SECONDS_PER_DAY());
        return (int)days;
    }

    public long fromJavaTimestamp(Timestamp t) {
        return t == null ? 0L : TimeUnit.MILLISECONDS.toMicros(t.getTime()) + TimeUnit.NANOSECONDS.toMicros(t.getNanos()) % this.NANOS_PER_MICROS();
    }

    private DateTimeUtils$() {
        MODULE$ = this;
        this.NANOS_PER_MICROS = 1000L;
        this.MICROS_PER_MILLIS = 1000L;
        this.MILLIS_PER_SECOND = 1000L;
        this.SECONDS_PER_DAY = 86400L;
        this.MICROS_PER_SECOND = this.MILLIS_PER_SECOND() * this.MICROS_PER_MILLIS();
        this.NANOS_PER_MILLIS = this.NANOS_PER_MICROS() * this.MICROS_PER_MILLIS();
        this.NANOS_PER_SECOND = this.NANOS_PER_MICROS() * this.MICROS_PER_SECOND();
        this.MICROS_PER_DAY = this.SECONDS_PER_DAY() * this.MICROS_PER_SECOND();
        this.MILLIS_PER_MINUTE = 60L * this.MILLIS_PER_SECOND();
        this.MILLIS_PER_HOUR = 60L * this.MILLIS_PER_MINUTE();
        this.MILLIS_PER_DAY = this.SECONDS_PER_DAY() * this.MILLIS_PER_SECOND();
    }
}

