/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import com.databricks.spark.util.DatabricksLogging$class;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.metering.DeltaLogging$class;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$$anonfun$org$apache$spark$sql$delta$util$DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter$class;
import org.apache.spark.sql.delta.util.SerializableFileStatus;
import org.apache.spark.sql.delta.util.SerializableFileStatus$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class DeltaFileOperations$
implements DeltaLogging {
    public static final DeltaFileOperations$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaFileOperations$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging$class.recordDeltaEvent(this, deltaLog, opType, tags, data);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging$class.recordDeltaOperation(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging$class.recordDeltaOperation$default$3(this);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging$class.recordDeltaEvent$default$3(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging$class.recordDeltaEvent$default$4(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging$class.logConsole(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging$class.recordUsage(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging$class.recordEvent(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging$class.recordOperation(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging$class.recordUsage$default$3(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging$class.recordUsage$default$4(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging$class.recordUsage$default$5(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging$class.recordUsage$default$6(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging$class.recordUsage$default$7(this);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging$class.recordEvent$default$2(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging$class.recordEvent$default$3(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging$class.recordEvent$default$4(this);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging$class.recordOperation$default$2(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging$class.recordOperation$default$4(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging$class.recordOperation$default$5(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging$class.recordOperation$default$6(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging$class.recordOperation$default$7(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging$class.recordOperation$default$8(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging$class.recordOperation$default$9(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter$class.withStatusCode(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter$class.withStatusCode$default$3(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Path absolutePath(String basePath, String child) {
        Path path;
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            path = p;
        } else {
            Path merged = new Path(basePath, p);
            String mergedUri = merged.toUri().toString();
            path = child.endsWith("/") && !mergedUri.endsWith("/") ? new Path(new URI(new StringBuilder().append((Object)mergedUri).append((Object)"/").toString())) : merged;
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path tryRelativizePath(FileSystem fs, Path basePath, Path child) {
        Path path;
        URI childUri = child.toUri();
        if (!child.isAbsolute()) {
            path = child;
            return path;
        }
        try {
            path = new Path(fs.makeQualified(basePath).toUri().relativize(fs.makeQualified(child).toUri()));
            return path;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to relativize the path (", "). This can happen when absolute paths make\n               |it into the transaction log, which start with the scheme s3://, wasbs:// or adls://.\n               |This is a bug that has existed before DBR 5.0. To fix this issue, please upgrade\n               |your writer jobs to DBR 5.0 and please run:\n               |%scala com.databricks.delta.Delta.fixAbsolutePathsInLog(\"", "\")\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{child, child})))).stripMargin());
        }
    }

    private boolean isThrottlingError(Throwable t) {
        return Option$.MODULE$.apply((Object)t.getMessage()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT).contains("slow down");
            }
        });
    }

    private void randomBackoff(String opName, Throwable t, int base, int jitter) {
        int sleepTime = Random$.MODULE$.nextInt(jitter) + base;
        this.logWarning((Function0<String>)new Serializable(opName, sleepTime){
            public static final long serialVersionUID = 0L;
            private final String opName$1;
            private final int sleepTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " ms to rate limit ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.sleepTime$1), this.opName$1}));
            }
            {
                this.opName$1 = opName$1;
                this.sleepTime$1 = sleepTime$1;
            }
        }, t);
        Thread.sleep(sleepTime);
    }

    private int randomBackoff$default$3() {
        return 100;
    }

    private int randomBackoff$default$4() {
        return 1000;
    }

    public Iterator<SerializableFileStatus> org$apache$spark$sql$delta$util$DeltaFileOperations$$listUsingLogStore(LogStore logStore, Iterator<String> subDirs, boolean recurse, Function1<String, Object> hiddenFileNameFilter) {
        Iterator<SerializableFileStatus> filesAndDirs = subDirs.flatMap((Function1)new Serializable(logStore, hiddenFileNameFilter){
            public static final long serialVersionUID = 0L;
            private final LogStore logStore$1;
            private final Function1 hiddenFileNameFilter$2;

            public final Iterator<SerializableFileStatus> apply(String dir) {
                return DeltaFileOperations$.MODULE$.org$apache$spark$sql$delta$util$DeltaFileOperations$$list$1(dir, 10, this.logStore$1, this.hiddenFileNameFilter$2);
            }
            {
                this.logStore$1 = logStore$1;
                this.hiddenFileNameFilter$2 = hiddenFileNameFilter$2;
            }
        });
        return recurse ? this.org$apache$spark$sql$delta$util$DeltaFileOperations$$recurseDirectories(logStore, filesAndDirs, hiddenFileNameFilter) : filesAndDirs;
    }

    public Iterator<SerializableFileStatus> org$apache$spark$sql$delta$util$DeltaFileOperations$$recurseDirectories(LogStore logStore, Iterator<SerializableFileStatus> filesAndDirs, Function1<String, Object> hiddenFileNameFilter) {
        return filesAndDirs.flatMap((Function1)new Serializable(logStore, hiddenFileNameFilter){
            public static final long serialVersionUID = 0L;
            public final LogStore logStore$2;
            public final Function1 hiddenFileNameFilter$3;

            public final GenTraversableOnce<SerializableFileStatus> apply(SerializableFileStatus x0$1) {
                SerializableFileStatus serializableFileStatus;
                SerializableFileStatus serializableFileStatus2 = x0$1;
                Iterator iterator = serializableFileStatus2 != null && (serializableFileStatus = serializableFileStatus2).isDir() ? package$.MODULE$.Iterator().single((Object)serializableFileStatus).$plus$plus((Function0)new Serializable(this, serializableFileStatus){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$delta$util$DeltaFileOperations$$recurseDirectories$1 $outer;
                    private final SerializableFileStatus x2$1;

                    public final Iterator<SerializableFileStatus> apply() {
                        return DeltaFileOperations$.MODULE$.org$apache$spark$sql$delta$util$DeltaFileOperations$$listUsingLogStore(this.$outer.logStore$2, (Iterator<String>)package$.MODULE$.Iterator().single((Object)this.x2$1.path()), true, (Function1<String, Object>)this.$outer.hiddenFileNameFilter$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x2$1 = x2$1;
                    }
                }) : package$.MODULE$.Iterator().single((Object)serializableFileStatus2);
                return iterator;
            }
            {
                this.logStore$2 = logStore$2;
                this.hiddenFileNameFilter$3 = hiddenFileNameFilter$3;
            }
        });
    }

    public boolean defaultHiddenFileFilter(String fileName) {
        return fileName.startsWith("_") || fileName.startsWith(".");
    }

    public Dataset<SerializableFileStatus> recursiveListDirs(SparkSession spark, Seq<String> subDirs, Broadcast<SerializableConfiguration> hadoopConf, Function1<String, Object> hiddenFileNameFilter, Option<Object> fileListingParallelism) {
        if (subDirs.isEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.delta.util.SerializableFileStatus").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1() {
                }
            }
            return spark.emptyDataset(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1())));
        }
        int listParallelism = BoxesRunTime.unboxToInt((Object)fileListingParallelism.getOrElse((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.spark$1.sparkContext().defaultParallelism();
            }
            {
                this.spark$1 = spark$1;
            }
        }));
        RDD qual$1 = spark.sparkContext().parallelize(subDirs, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        Serializable x$4 = new Serializable(hadoopConf, hiddenFileNameFilter){
            public static final long serialVersionUID = 0L;
            private final Broadcast hadoopConf$1;
            private final Function1 hiddenFileNameFilter$1;

            public final Iterator<SerializableFileStatus> apply(Iterator<String> dirs) {
                LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)this.hadoopConf$1.value()).value());
                return DeltaFileOperations$.MODULE$.org$apache$spark$sql$delta$util$DeltaFileOperations$$listUsingLogStore(logStore, dirs, false, (Function1<String, Object>)this.hiddenFileNameFilter$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
                this.hiddenFileNameFilter$1 = hiddenFileNameFilter$1;
            }
        };
        boolean x$5 = qual$1.mapPartitions$default$2();
        RDD qual$2 = qual$1.mapPartitions((Function1)x$4, x$5, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        int x$6 = listParallelism;
        Ordering x$7 = qual$2.repartition$default$2(x$6);
        RDD dirsAndFiles = qual$2.repartition(x$6, x$7);
        RDD allDirsAndFiles = dirsAndFiles.mapPartitions((Function1)new Serializable(hadoopConf, hiddenFileNameFilter){
            public static final long serialVersionUID = 0L;
            private final Broadcast hadoopConf$1;
            private final Function1 hiddenFileNameFilter$1;

            public final Iterator<SerializableFileStatus> apply(Iterator<SerializableFileStatus> firstLevelDirsAndFiles) {
                LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)this.hadoopConf$1.value()).value());
                return DeltaFileOperations$.MODULE$.org$apache$spark$sql$delta$util$DeltaFileOperations$$recurseDirectories(logStore, firstLevelDirsAndFiles, (Function1<String, Object>)this.hiddenFileNameFilter$1);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
                this.hiddenFileNameFilter$1 = hiddenFileNameFilter$1;
            }
        }, dirsAndFiles.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.util.SerializableFileStatus").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1() {
            }
        }
        return spark.createDataset(allDirsAndFiles, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1())));
    }

    public Function1<String, Object> recursiveListDirs$default$4() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String fileName) {
                return DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName);
            }
        };
    }

    public Option<Object> recursiveListDirs$default$5() {
        return None$.MODULE$;
    }

    public boolean tryDeleteNonRecursive(FileSystem fs, Path path, int tries) {
        Throwable throwable2;
        block6: {
            boolean bl;
            try {
                bl = fs.delete(path, false);
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof FileNotFoundException) {
                    bl2 = true;
                } else if (throwable3 instanceof IOException) {
                    bl2 = false;
                } else {
                    Throwable e;
                    Option option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty() || !this.isThrottlingError(e = (Throwable)option.get()) || tries <= 0) break block6;
                    this.randomBackoff("deletes", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                    bl2 = this.tryDeleteNonRecursive(fs, path, tries - 1);
                }
                bl = bl2;
            }
            return bl;
        }
        throw throwable2;
    }

    public int tryDeleteNonRecursive$default$3() {
        return 3;
    }

    public Tuple2<Iterator<String>, String> getAllSubDirectories(String base, String path) {
        String[] baseSplits = base.split("/");
        String[] pathSplits = (String[])Predef$.MODULE$.refArrayOps((Object[])path.split("/")).drop(baseSplits.length);
        Iterator it = package$.MODULE$.Iterator().tabulate(pathSplits.length - 1, (Function1)new Serializable(baseSplits, pathSplits){
            public static final long serialVersionUID = 0L;
            private final String[] baseSplits$1;
            private final String[] pathSplits$1;

            public final String apply(int i) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.baseSplits$1).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.pathSplits$1).take(i + 1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("/");
            }
            {
                this.baseSplits$1 = baseSplits$1;
                this.pathSplits$1 = pathSplits$1;
            }
        });
        return new Tuple2((Object)it, (Object)path);
    }

    public void registerTempFileDeletionTaskFailureListener(Configuration conf, Path tempPath) {
        TaskContext tc = TaskContext$.MODULE$.get();
        if (tc == null) {
            throw new IllegalStateException("Not running on a Spark task thread");
        }
        tc.addTaskFailureListener((Function2)new Serializable(conf, tempPath){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            public final Path tempPath$1;

            public final void apply(TaskContext x$2, Throwable x$3) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.tempPath$1.getFileSystem(this.conf$1).delete(this.tempPath$1, false));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    DeltaFileOperations$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.registerTempFileDeletionTaskFailureListener.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tempPath$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    bl = boxedUnit;
                }
            }
            {
                this.conf$1 = conf$1;
                this.tempPath$1 = tempPath$1;
            }
        });
    }

    public final Iterator org$apache$spark$sql$delta$util$DeltaFileOperations$$list$1(String dir, int tries, LogStore logStore$1, Function1 hiddenFileNameFilter$2) {
        Throwable throwable2;
        block4: {
            Iterator iterator;
            this.logInfo((Function0<String>)new Serializable(dir){
                public static final long serialVersionUID = 0L;
                private final String dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir$1}));
                }
                {
                    this.dir$1 = dir$1;
                }
            });
            try {
                iterator = logStore$1.listFrom(new Path(dir, "\u0000")).filterNot((Function1)new Serializable(hiddenFileNameFilter$2){
                    public static final long serialVersionUID = 0L;
                    private final Function1 hiddenFileNameFilter$2;

                    public final boolean apply(FileStatus f) {
                        return BoxesRunTime.unboxToBoolean((Object)this.hiddenFileNameFilter$2.apply((Object)f.getPath().getName()));
                    }
                    {
                        this.hiddenFileNameFilter$2 = hiddenFileNameFilter$2;
                    }
                }).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final SerializableFileStatus apply(FileStatus status) {
                        return SerializableFileStatus$.MODULE$.fromStatus(status);
                    }
                });
            }
            catch (Throwable throwable2) {
                Iterator iterator2;
                Throwable e;
                Throwable throwable3 = throwable2;
                Option option = NonFatal$.MODULE$.unapply(throwable3);
                if (!option.isEmpty() && this.isThrottlingError(e = (Throwable)option.get()) && tries > 0) {
                    this.randomBackoff("listing", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                    iterator2 = this.org$apache$spark$sql$delta$util$DeltaFileOperations$$list$1(dir, tries - 1, logStore$1, hiddenFileNameFilter$2);
                } else {
                    if (!(throwable3 instanceof FileNotFoundException)) break block4;
                    iterator2 = package$.MODULE$.Iterator().empty();
                }
                iterator = iterator2;
            }
            return iterator;
        }
        throw throwable2;
    }

    private DeltaFileOperations$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        DeltaProgressReporter$class.$init$(this);
        DatabricksLogging$class.$init$(this);
        DeltaLogging$class.$init$(this);
    }
}

