/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class FileNames$ {
    public static final FileNames$ MODULE$;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;

    static {
        new FileNames$();
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Path deltaFile(Path path, long version) {
        long arg$macro$4 = version;
        return new Path(path, new StringOps("%020d.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$4)})));
    }

    public Path sampleFile(Path path, long version) {
        long arg$macro$5 = version;
        return new Path(path, new StringOps("%020d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$5)})));
    }

    public Path checksumFile(Path path, long version) {
        long arg$macro$6 = version;
        return new Path(path, new StringOps("%020d.crc").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$6)})));
    }

    public long deltaVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json"))).toLong();
    }

    public long checksumVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc"))).toLong();
    }

    public Path checkpointPrefix(Path path, long version) {
        long arg$macro$7 = version;
        return new Path(path, new StringOps("%020d.checkpoint").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$7)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        long arg$macro$8 = version;
        return new Path(path, new StringOps("%020d.checkpoint.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$8)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return (Seq)package$.MODULE$.Range().apply(1, numParts + 1).map((Function1)new Serializable(path, version, numParts){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            private final long version$1;
            private final int numParts$1;

            public final Path apply(int i) {
                long arg$macro$9 = this.version$1;
                int arg$macro$10 = i;
                int arg$macro$11 = this.numParts$1;
                return new Path(this.path$1, new StringOps("%020d.checkpoint.%010d.%010d.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$9), BoxesRunTime.boxToInteger((int)arg$macro$10), BoxesRunTime.boxToInteger((int)arg$macro$11)})));
            }
            {
                this.path$1 = path$1;
                this.version$1 = version$1;
                this.numParts$1 = numParts$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        return Predef$.MODULE$.refArrayOps((Object[])segments).size() != 5 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[3])).toInt()));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isDeltaFile(Path path) {
        return this.deltaFilePattern().matcher(path.getName()).matches();
    }

    public boolean isChecksumFile(Path path) {
        return this.checksumFilePattern().matcher(path.getName()).matches();
    }

    public long checkpointVersion(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0])).toLong();
    }

    private FileNames$() {
        MODULE$ = this;
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
    }
}

