/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetArrayItem;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Hour;
import org.apache.spark.sql.catalyst.expressions.IntegerLiteral$;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Month;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.StringLiteral$;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.TruncDate;
import org.apache.spark.sql.catalyst.expressions.TruncTimestamp;
import org.apache.spark.sql.catalyst.expressions.UserDefinedExpression;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.delta.DateFormatPartitionExpr;
import org.apache.spark.sql.delta.DatePartitionExpr;
import org.apache.spark.sql.delta.DayPartitionExpr;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.ExtractBaseColumn$;
import org.apache.spark.sql.delta.GeneratedColumnsTableFeature$;
import org.apache.spark.sql.delta.HourPartitionExpr;
import org.apache.spark.sql.delta.IdentityPartitionExpr;
import org.apache.spark.sql.delta.MonthPartitionExpr;
import org.apache.spark.sql.delta.OptimizablePartitionExpression;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.SubstringPartitionExpr;
import org.apache.spark.sql.delta.SupportedGenerationExpressions$;
import org.apache.spark.sql.delta.TimestampTruncPartitionExpr;
import org.apache.spark.sql.delta.TruncDatePartitionExpr;
import org.apache.spark.sql.delta.YearMonthDayHourPartitionExpr;
import org.apache.spark.sql.delta.YearMonthDayPartitionExpr;
import org.apache.spark.sql.delta.YearMonthPartitionExpr;
import org.apache.spark.sql.delta.YearPartitionExpr;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.AnalysisHelper;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class GeneratedColumn$
implements DeltaLogging,
AnalysisHelper {
    public static GeneratedColumn$ MODULE$;
    private final String DATE_FORMAT_YEAR_MONTH;
    private final String DATE_FORMAT_YEAR_MONTH_DAY;
    private final String DATE_FORMAT_YEAR_MONTH_DAY_HOUR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GeneratedColumn$();
    }

    @Override
    public Expression tryResolveReferences(SparkSession sparkSession, Expression expr, LogicalPlan planContainingExpr) {
        return AnalysisHelper.tryResolveReferences$(this, sparkSession, expr, planContainingExpr);
    }

    @Override
    public Seq<Expression> tryResolveReferencesForExpressions(SparkSession sparkSession, Seq<Expression> exprs, LogicalPlan planContainingExpr) {
        return AnalysisHelper.tryResolveReferencesForExpressions$(this, sparkSession, exprs, planContainingExpr);
    }

    @Override
    public Seq<Expression> resolveReferencesForExpressions(SparkSession sparkSession, Seq<Expression> exprs, LogicalPlan planProvidingAttrs) {
        return AnalysisHelper.resolveReferencesForExpressions$(this, sparkSession, exprs, planProvidingAttrs);
    }

    @Override
    public Dataset<Row> toDataset(SparkSession sparkSession, LogicalPlan logicalPlan) {
        return AnalysisHelper.toDataset$(this, sparkSession, logicalPlan);
    }

    @Override
    public void improveUnsupportedOpError(Function0<BoxedUnit> f) {
        AnalysisHelper.improveUnsupportedOpError$(this, f);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean satisfyGeneratedColumnProtocol(Protocol protocol) {
        return protocol.isFeatureSupported(GeneratedColumnsTableFeature$.MODULE$);
    }

    public boolean isGeneratedColumn(StructField field) {
        return field.metadata().contains(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY());
    }

    public boolean isGeneratedColumn(Protocol protocol, StructField field) {
        return this.satisfyGeneratedColumnProtocol(protocol) && this.isGeneratedColumn(field);
    }

    public boolean hasGeneratedColumns(StructType schema) {
        return schema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
    }

    public Seq<StructField> getGeneratedColumns(Snapshot snapshot) {
        return this.satisfyGeneratedColumnProtocol(snapshot.protocol()) ? (Seq)snapshot.metadata().schema().partition((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)))._1() : Nil$.MODULE$;
    }

    public boolean enforcesGeneratedColumns(Protocol protocol, Metadata metadata) {
        return this.satisfyGeneratedColumnProtocol(protocol) && metadata.schema().exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
    }

    public Option<String> getGenerationExpressionStr(org.apache.spark.sql.types.Metadata metadata) {
        return metadata.contains(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY()) ? new Some((Object)metadata.getString(DeltaSourceUtils$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY())) : None$.MODULE$;
    }

    public Option<Expression> getGenerationExpression(StructField field) {
        return this.getGenerationExpressionStr(field.metadata()).map((Function1 & Serializable & scala.Serializable)exprStr -> MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr));
    }

    private Option<String> getGenerationExpressionStr(StructField field) {
        return this.getGenerationExpressionStr(field.metadata());
    }

    private Expression parseGenerationExpression(SparkSession spark, String exprString) {
        return spark.sessionState().sqlParser().parseExpression(exprString);
    }

    public void validateGeneratedColumns(SparkSession spark, StructType schema) {
        Dataset dataset;
        Tuple2 tuple2 = schema.partition((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.MODULE$.isGeneratedColumn(field)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq generatedColumns = (Seq)tuple2._1();
        Seq normalColumns = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)generatedColumns, (Object)normalColumns);
        Tuple2 tuple23 = tuple22;
        Seq generatedColumns2 = (Seq)tuple23._1();
        Seq normalColumns2 = (Seq)tuple23._2();
        LocalRelation relation = new LocalRelation(StructType$.MODULE$.apply(normalColumns2).toAttributes(), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3());
        Seq selectExprs = (Seq)generatedColumns2.map((Function1 & Serializable & scala.Serializable)f -> {
            Option<String> option = MODULE$.getGenerationExpressionStr((StructField)f);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw DeltaErrors$.MODULE$.expressionsNotFoundInGeneratedColumn(f.name());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            String exprString = (String)some.value();
            Expression expr = MODULE$.parseGenerationExpression(spark, exprString);
            Column column = new Column(expr).alias(f.name());
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        try {
            Project plan = new Project((Seq)selectExprs.map((Function1 & Serializable & scala.Serializable)x$2 -> (NamedExpression)x$2.expr(), Seq$.MODULE$.canBuildFrom()), (LogicalPlan)relation);
            dataset = Dataset$.MODULE$.ofRows(spark, (LogicalPlan)plan);
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AnalysisException && (analysisException = (AnalysisException)throwable2).getMessage() != null) {
                Seq regexCandidates = (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("A column or function parameter with name .*?cannot be resolved. Did you mean one of the following?.*?")).r(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("cannot resolve.*?given input columns:.*?")).r(), (List)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("Column.*?does not exist.")).r(), (List)Nil$.MODULE$)));
                if (regexCandidates.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.$anonfun$validateGeneratedColumns$4(analysisException, x$3)))) {
                    throw DeltaErrors$.MODULE$.generatedColumnsReferToWrongColumns(analysisException);
                }
                throw analysisException;
            }
            throw throwable;
        }
        Dataset dfWithExprs = dataset;
        dfWithExprs.queryExecution().analyzed().transformAllExpressions((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Alias alias;
                    object = alias = (Alias)A1;
                } else {
                    boolean bl = A1 instanceof GetStructField ? true : A1 instanceof GetArrayItem;
                    if (bl) {
                        object = A1;
                    } else {
                        if (A1 instanceof UserDefinedExpression) {
                            A1 A12 = A1;
                            throw DeltaErrors$.MODULE$.generatedColumnsUDF(A12);
                        }
                        if (!A1.deterministic()) {
                            throw DeltaErrors$.MODULE$.generatedColumnsNonDeterministicExpression(A1);
                        }
                        if (A1 instanceof AggregateExpression) {
                            throw DeltaErrors$.MODULE$.generatedColumnsAggregateExpression(A1);
                        }
                        if (!SupportedGenerationExpressions$.MODULE$.expressions().contains((Object)A1.getClass())) {
                            throw DeltaErrors$.MODULE$.generatedColumnsUnsupportedExpression(A1);
                        }
                        object = function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                boolean bl;
                Expression expression = x1;
                boolean bl2 = expression instanceof Alias ? true : ((bl = expression instanceof GetStructField ? true : expression instanceof GetArrayItem) ? true : (expression instanceof UserDefinedExpression ? true : (!expression.deterministic() ? true : (expression instanceof AggregateExpression ? true : !SupportedGenerationExpressions$.MODULE$.expressions().contains((Object)expression.getClass())))));
                return bl2;
            }
        });
        ((IterableLike)generatedColumns2.zip((GenIterable)dfWithExprs.schema(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GeneratedColumn$.$anonfun$validateGeneratedColumns$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Set<String> getGeneratedColumnsAndColumnsUsedByGeneratedColumns(StructType schema) {
        Seq generationExprs = (Seq)schema.flatMap((Function1 & Serializable & scala.Serializable)col -> Option$.MODULE$.option2Iterable(MODULE$.getGenerationExpressionStr((StructField)col).map((Function1 & Serializable & scala.Serializable)exprStr -> {
            Expression expr = MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr);
            return new Column(expr).alias(col.name());
        })), Seq$.MODULE$.canBuildFrom());
        if (generationExprs.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        Dataset df = Dataset$.MODULE$.ofRows(SparkSession$.MODULE$.active(), (LogicalPlan)new LocalRelation(schema.toAttributes(), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3()));
        LogicalPlan logicalPlan = df.select(generationExprs).queryExecution().analyzed();
        if (!(logicalPlan instanceof Project)) {
            throw DeltaErrors$.MODULE$.unexpectedProject(logicalPlan.toString());
        }
        Project project = (Project)logicalPlan;
        Seq exprs = project.projectList();
        Seq seq = (Seq)exprs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression = x0$1;
            if (!(namedExpression instanceof Alias)) {
                throw DeltaErrors$.MODULE$.unexpectedAlias(String.valueOf(namedExpression));
            }
            Alias alias = (Alias)namedExpression;
            Expression expr = alias.child();
            String column = alias.name();
            Seq seq = (Seq)((TraversableOnce)expr.references().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Attribute attribute = x0$2;
                if (!(attribute instanceof AttributeReference)) {
                    throw DeltaErrors$.MODULE$.unexpectedAttributeReference(String.valueOf(attribute));
                }
                AttributeReference attributeReference = (AttributeReference)attribute;
                String string = attributeReference.name();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq().$colon$plus((Object)column, Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Seq generatedColumnsAndColumnsUsedByGeneratedColumns = seq;
        return ((TraversableOnce)generatedColumnsAndColumnsUsedByGeneratedColumns.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toLowerCase(Locale.ROOT), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private String createFieldPath(Seq<String> nameParts) {
        return ((TraversableOnce)nameParts.map((Function1 & Serializable & scala.Serializable)part -> package$.MODULE$.quoteIfNeeded(part), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public Map<String, Seq<OptimizablePartitionExpression>> getOptimizablePartitionExpressions(StructType schema, StructType partitionSchema) {
        Seq partitionGenerationExprs = (Seq)partitionSchema.flatMap((Function1 & Serializable & scala.Serializable)col -> Option$.MODULE$.option2Iterable(MODULE$.getGenerationExpressionStr((StructField)col).map((Function1 & Serializable & scala.Serializable)exprStr -> {
            Expression expr = MODULE$.parseGenerationExpression(SparkSession$.MODULE$.active(), (String)exprStr);
            return new Column(expr).alias(col.name());
        })), Seq$.MODULE$.canBuildFrom());
        if (partitionGenerationExprs.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        SparkSession spark = SparkSession$.MODULE$.active();
        Function2 resolver = spark.sessionState().analyzer().resolver();
        Function1 & Serializable & scala.Serializable nameNormalizer = spark.sessionState().conf().caseSensitiveAnalysis() ? (Function1 & Serializable & scala.Serializable)x -> x : (Function1 & Serializable & scala.Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT);
        Dataset df = Dataset$.MODULE$.ofRows(SparkSession$.MODULE$.active(), (LogicalPlan)new LocalRelation(schema.toAttributes(), LocalRelation$.MODULE$.$lessinit$greater$default$2(), LocalRelation$.MODULE$.$lessinit$greater$default$3()));
        LogicalPlan logicalPlan = df.select(partitionGenerationExprs).queryExecution().analyzed();
        if (!(logicalPlan instanceof Project)) {
            throw DeltaErrors$.MODULE$.unexpectedProject(logicalPlan.toString());
        }
        Project project = (Project)logicalPlan;
        Seq exprs = project.projectList();
        Seq seq = (Seq)exprs.flatMap(arg_0 -> GeneratedColumn$.$anonfun$getOptimizablePartitionExpressions$5(this, resolver, schema, nameNormalizer, arg_0), Seq$.MODULE$.canBuildFrom());
        Seq extractedPartitionExprs = seq;
        return (Map)extractedPartitionExprs.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> (String)x$6._1()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq<OptimizablePartitionExpression> mergedExprs;
            String name;
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                name = (String)tuple2._1();
                Seq group = (Seq)tuple2._2();
                Seq groupedExprs = (Seq)group.map((Function1 & Serializable & scala.Serializable)x$7 -> (OptimizablePartitionExpression)x$7._2(), Seq$.MODULE$.canBuildFrom());
                mergedExprs = MODULE$.mergePartitionExpressionsIfPossible((Seq<OptimizablePartitionExpression>)groupedExprs);
                if (MODULE$.log().isDebugEnabled()) {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Optimizable partition expressions for column ").append(name).append(":").toString());
                    mergedExprs.foreach((Function1 & Serializable & scala.Serializable)expr -> {
                        GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> expr.toString());
                        return BoxedUnit.UNIT;
                    });
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), mergedExprs);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq<OptimizablePartitionExpression> mergePartitionExpressionsIfPossible(Seq<OptimizablePartitionExpression> exprs) {
        Some some;
        Option year = ((TraversableLike)exprs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof YearPartitionExpr) {
                    YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)A1;
                    object = yearPartitionExpr;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x1) {
                OptimizablePartitionExpression optimizablePartitionExpression = x1;
                boolean bl = optimizablePartitionExpression instanceof YearPartitionExpr;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        Option month = ((TraversableLike)exprs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof MonthPartitionExpr) {
                    MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)A1;
                    object = monthPartitionExpr;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x2) {
                OptimizablePartitionExpression optimizablePartitionExpression = x2;
                boolean bl = optimizablePartitionExpression instanceof MonthPartitionExpr;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        Option day = ((TraversableLike)exprs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof DayPartitionExpr) {
                    DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)A1;
                    object = dayPartitionExpr;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x3) {
                OptimizablePartitionExpression optimizablePartitionExpression = x3;
                boolean bl = optimizablePartitionExpression instanceof DayPartitionExpr;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        Option hour = ((TraversableLike)exprs.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OptimizablePartitionExpression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof HourPartitionExpr) {
                    HourPartitionExpr hourPartitionExpr = (HourPartitionExpr)A1;
                    object = hourPartitionExpr;
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(OptimizablePartitionExpression x4) {
                OptimizablePartitionExpression optimizablePartitionExpression = x4;
                boolean bl = optimizablePartitionExpression instanceof HourPartitionExpr;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption();
        boolean bl = false;
        Seq seq = null;
        Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)Option$.MODULE$.option2Iterable(year).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(month), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(day), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(hour), Iterable$.MODULE$.canBuildFrom());
        if (iterable instanceof Seq) {
            bl = true;
            seq = (Seq)iterable;
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(4) == 0) {
                Product year2 = (Product)((SeqLike)some2.get()).apply(0);
                Product month2 = (Product)((SeqLike)some2.get()).apply(1);
                Product day2 = (Product)((SeqLike)some2.get()).apply(2);
                Product hour2 = (Product)((SeqLike)some2.get()).apply(3);
                if (year2 instanceof YearPartitionExpr) {
                    YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year2;
                    if (month2 instanceof MonthPartitionExpr) {
                        MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month2;
                        if (day2 instanceof DayPartitionExpr) {
                            DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)day2;
                            if (hour2 instanceof HourPartitionExpr) {
                                HourPartitionExpr hourPartitionExpr = (HourPartitionExpr)hour2;
                                return (Seq)((SeqLike)exprs.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthDayHourPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart(), dayPartitionExpr.dayPart(), hourPartitionExpr.hourPart()), Seq$.MODULE$.canBuildFrom());
                            }
                        }
                    }
                }
            }
        }
        if (bl && !(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
            Product year3 = (Product)((SeqLike)some.get()).apply(0);
            Product month3 = (Product)((SeqLike)some.get()).apply(1);
            Product day3 = (Product)((SeqLike)some.get()).apply(2);
            if (year3 instanceof YearPartitionExpr) {
                YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year3;
                if (month3 instanceof MonthPartitionExpr) {
                    MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month3;
                    if (day3 instanceof DayPartitionExpr) {
                        DayPartitionExpr dayPartitionExpr = (DayPartitionExpr)day3;
                        return (Seq)((SeqLike)exprs.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthDayPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart(), dayPartitionExpr.dayPart()), Seq$.MODULE$.canBuildFrom());
                    }
                }
            }
        }
        if (!bl) return exprs;
        Some some3 = Seq$.MODULE$.unapplySeq(seq);
        if (some3.isEmpty()) return exprs;
        if (some3.get() == null) return exprs;
        if (((SeqLike)some3.get()).lengthCompare(2) != 0) return exprs;
        Product year4 = (Product)((SeqLike)some3.get()).apply(0);
        Product month4 = (Product)((SeqLike)some3.get()).apply(1);
        if (!(year4 instanceof YearPartitionExpr)) return exprs;
        YearPartitionExpr yearPartitionExpr = (YearPartitionExpr)year4;
        if (!(month4 instanceof MonthPartitionExpr)) return exprs;
        MonthPartitionExpr monthPartitionExpr = (MonthPartitionExpr)month4;
        return (Seq)((SeqLike)exprs.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)GeneratedColumn$.isRedundantPartitionExpr$1(f)))).$colon$plus((Object)new YearMonthPartitionExpr(yearPartitionExpr.yearPart(), monthPartitionExpr.monthPart()), Seq$.MODULE$.canBuildFrom());
    }

    public boolean partitionFilterOptimizationEnabled(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.GENERATED_COLUMN_PARTITION_FILTER_OPTIMIZATION_ENABLED()));
    }

    public Seq<Expression> generatePartitionFilters(SparkSession spark, SnapshotDescriptor snapshot, Seq<Expression> dataFilters, LogicalPlan delta) {
        if (!this.satisfyGeneratedColumnProtocol(snapshot.protocol())) {
            return Nil$.MODULE$;
        }
        if (snapshot.metadata().optimizablePartitionExpressions().isEmpty()) {
            return Nil$.MODULE$;
        }
        CaseInsensitiveMap optimizablePartitionExpressions = spark.sessionState().conf().caseSensitiveAnalysis() ? snapshot.metadata().optimizablePartitionExpressions() : CaseInsensitiveMap$.MODULE$.apply(snapshot.metadata().optimizablePartitionExpressions());
        Seq partitionFilters = (Seq)dataFilters.flatMap(arg_0 -> GeneratedColumn$.$anonfun$generatePartitionFilters$3(this, (Map)optimizablePartitionExpressions, arg_0), Seq$.MODULE$.canBuildFrom());
        Seq<Expression> resolvedPartitionFilters = this.resolveReferencesForExpressions(spark, (Seq<Expression>)partitionFilters, delta);
        if (this.log().isDebugEnabled()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "User provided data filters:");
            dataFilters.foreach((Function1 & Serializable & scala.Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Auto generated partition filters:");
            partitionFilters.foreach((Function1 & Serializable & scala.Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resolved generated partition filters:");
            resolvedPartitionFilters.foreach((Function1 & Serializable & scala.Serializable)f -> {
                GeneratedColumn$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> f.sql());
                return BoxedUnit.UNIT;
            });
        }
        String executionId = (String)Option$.MODULE$.apply((Object)spark.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
        DeltaLog x$1 = snapshot.deltaLog();
        String x$2 = "delta.generatedColumns.optimize";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executionId"), (Object)executionId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"triggered"), (Object)BoxesRunTime.boxToBoolean((boolean)resolvedPartitionFilters.nonEmpty()))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, x$2, x$4, x$3, x$5);
        return resolvedPartitionFilters;
    }

    private String DATE_FORMAT_YEAR_MONTH() {
        return this.DATE_FORMAT_YEAR_MONTH;
    }

    private String DATE_FORMAT_YEAR_MONTH_DAY() {
        return this.DATE_FORMAT_YEAR_MONTH_DAY;
    }

    private String DATE_FORMAT_YEAR_MONTH_DAY_HOUR() {
        return this.DATE_FORMAT_YEAR_MONTH_DAY_HOUR;
    }

    public static final /* synthetic */ boolean $anonfun$validateGeneratedColumns$4(AnalysisException x5$1, Regex x$3) {
        return x$3.findFirstMatchIn((CharSequence)x5$1.getMessage()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$validateGeneratedColumns$6(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField column = (StructField)tuple2._1();
            StructField expr = (StructField)tuple2._2();
            DataType dataType = column.dataType();
            DataType dataType2 = expr.dataType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                throw DeltaErrors$.MODULE$.generatedColumnsTypeMismatch(column.name(), column.dataType(), expr.dataType());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final Option createExpr$1(Seq nameParts, Function0 func, Function2 resolver$1, StructType schema$1, Function1 nameNormalizer$1) {
        Origin x$4;
        Seq x$1 = nameParts;
        Function2 x$2 = resolver$1;
        boolean x$3 = schema$1.findNestedField$default$2();
        return schema$1.findNestedField(x$1, x$3, x$2, x$4 = schema$1.findNestedField$default$4()).isDefined() ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(nameNormalizer$1.apply((Object)this.createFieldPath((Seq<String>)nameParts))), func.apply())) : None$.MODULE$;
    }

    public static final /* synthetic */ DatePartitionExpr $anonfun$getOptimizablePartitionExpressions$6(String partColName$1) {
        return new DatePartitionExpr(partColName$1);
    }

    public static final /* synthetic */ DatePartitionExpr $anonfun$getOptimizablePartitionExpressions$7(String partColName$1) {
        return new DatePartitionExpr(partColName$1);
    }

    public static final /* synthetic */ YearPartitionExpr $anonfun$getOptimizablePartitionExpressions$8(String partColName$1) {
        return new YearPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ YearPartitionExpr $anonfun$getOptimizablePartitionExpressions$9(String partColName$1) {
        return new YearPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ YearPartitionExpr $anonfun$getOptimizablePartitionExpressions$10(String partColName$1) {
        return new YearPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ MonthPartitionExpr $anonfun$getOptimizablePartitionExpressions$11(String partColName$1) {
        return new MonthPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ DateFormatPartitionExpr $anonfun$getOptimizablePartitionExpressions$12(String partColName$1) {
        return new DateFormatPartitionExpr(partColName$1, MODULE$.DATE_FORMAT_YEAR_MONTH());
    }

    public static final /* synthetic */ DateFormatPartitionExpr $anonfun$getOptimizablePartitionExpressions$13(String partColName$1) {
        return new DateFormatPartitionExpr(partColName$1, MODULE$.DATE_FORMAT_YEAR_MONTH());
    }

    public static final /* synthetic */ DateFormatPartitionExpr $anonfun$getOptimizablePartitionExpressions$14(String partColName$1) {
        return new DateFormatPartitionExpr(partColName$1, MODULE$.DATE_FORMAT_YEAR_MONTH_DAY());
    }

    public static final /* synthetic */ DateFormatPartitionExpr $anonfun$getOptimizablePartitionExpressions$15(String partColName$1) {
        return new DateFormatPartitionExpr(partColName$1, MODULE$.DATE_FORMAT_YEAR_MONTH_DAY_HOUR());
    }

    public static final /* synthetic */ DayPartitionExpr $anonfun$getOptimizablePartitionExpressions$16(String partColName$1) {
        return new DayPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ HourPartitionExpr $anonfun$getOptimizablePartitionExpressions$17(String partColName$1) {
        return new HourPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ SubstringPartitionExpr $anonfun$getOptimizablePartitionExpressions$18(String partColName$1, int pos$1, int len$1) {
        return new SubstringPartitionExpr(partColName$1, pos$1, len$1);
    }

    public static final /* synthetic */ TimestampTruncPartitionExpr $anonfun$getOptimizablePartitionExpressions$19(String format$1, String partColName$1) {
        return new TimestampTruncPartitionExpr(format$1, partColName$1);
    }

    public static final /* synthetic */ TimestampTruncPartitionExpr $anonfun$getOptimizablePartitionExpressions$20(String format$2, String partColName$1) {
        return new TimestampTruncPartitionExpr(format$2, partColName$1);
    }

    public static final /* synthetic */ IdentityPartitionExpr $anonfun$getOptimizablePartitionExpressions$21(String partColName$1) {
        return new IdentityPartitionExpr(partColName$1);
    }

    public static final /* synthetic */ TruncDatePartitionExpr $anonfun$getOptimizablePartitionExpressions$22(String partColName$1, String format$3) {
        return new TruncDatePartitionExpr(partColName$1, format$3);
    }

    public static final /* synthetic */ TruncDatePartitionExpr $anonfun$getOptimizablePartitionExpressions$23(String partColName$1, String format$4) {
        return new TruncDatePartitionExpr(partColName$1, format$4);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterable $anonfun$getOptimizablePartitionExpressions$5(GeneratedColumn$ $this, Function2 resolver$1, StructType schema$1, Function1 nameNormalizer$1, NamedExpression x0$1) {
        block8: {
            block6: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block10: {
                                                                    block9: {
                                                                        block7: {
                                                                            var10_5 = x0$1;
                                                                            if (!(var10_5 instanceof Alias)) break block6;
                                                                            var11_6 = (Alias)var10_5;
                                                                            expr = var11_6.child();
                                                                            partColName = var11_6.name();
                                                                            var14_9 = false;
                                                                            var15_10 = null;
                                                                            var16_11 = false;
                                                                            var17_12 = null;
                                                                            var18_13 = false;
                                                                            var19_14 = null;
                                                                            var20_15 = false;
                                                                            var21_16 = null;
                                                                            var22_17 = false;
                                                                            var23_18 = null;
                                                                            var24_19 = expr;
                                                                            if (!(var24_19 instanceof Cast)) break block7;
                                                                            var14_9 = true;
                                                                            var15_10 = (Cast)var24_19;
                                                                            var25_20 = var15_10.child();
                                                                            var26_21 = var15_10.dataType();
                                                                            var27_22 = ExtractBaseColumn$.MODULE$.unapply(var25_20);
                                                                            if (var27_22.isEmpty()) break block7;
                                                                            name = (Seq)((Tuple2)var27_22.get())._1();
                                                                            var29_24 = (DataType)((Tuple2)var27_22.get())._2();
                                                                            if (!TimestampType$.MODULE$.equals(var29_24) || !DateType$.MODULE$.equals(var26_21)) break block7;
                                                                            var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$6(java.lang.String ), ()Lorg/apache/spark/sql/delta/DatePartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                                            break block8;
                                                                        }
                                                                        if (!var14_9) break block9;
                                                                        var30_26 = var15_10.child();
                                                                        var31_27 = var15_10.dataType();
                                                                        var32_28 = ExtractBaseColumn$.MODULE$.unapply(var30_26);
                                                                        if (var32_28.isEmpty()) break block9;
                                                                        name = (Seq)((Tuple2)var32_28.get())._1();
                                                                        var34_30 = (DataType)((Tuple2)var32_28.get())._2();
                                                                        if (!DateType$.MODULE$.equals(var34_30) || !DateType$.MODULE$.equals(var31_27)) break block9;
                                                                        var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$7(java.lang.String ), ()Lorg/apache/spark/sql/delta/DatePartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                                        break block8;
                                                                    }
                                                                    if (!(var24_19 instanceof Year)) break block10;
                                                                    var16_11 = true;
                                                                    var17_12 = (Year)var24_19;
                                                                    var35_31 = var17_12.child();
                                                                    var36_32 = ExtractBaseColumn$.MODULE$.unapply(var35_31);
                                                                    if (var36_32.isEmpty()) break block10;
                                                                    name = (Seq)((Tuple2)var36_32.get())._1();
                                                                    var38_34 = (DataType)((Tuple2)var36_32.get())._2();
                                                                    if (!DateType$.MODULE$.equals(var38_34)) break block10;
                                                                    var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$8(java.lang.String ), ()Lorg/apache/spark/sql/delta/YearPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                                    break block8;
                                                                }
                                                                if (!var16_11 || !((var39_35 = var17_12.child()) instanceof Cast)) break block11;
                                                                var40_36 = (Cast)var39_35;
                                                                var41_37 = var40_36.child();
                                                                var42_38 = var40_36.dataType();
                                                                var43_39 = ExtractBaseColumn$.MODULE$.unapply(var41_37);
                                                                if (var43_39.isEmpty()) break block11;
                                                                name = (Seq)((Tuple2)var43_39.get())._1();
                                                                var45_41 = (DataType)((Tuple2)var43_39.get())._2();
                                                                if (!TimestampType$.MODULE$.equals(var45_41) || !DateType$.MODULE$.equals(var42_38)) break block11;
                                                                var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$9(java.lang.String ), ()Lorg/apache/spark/sql/delta/YearPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                                break block8;
                                                            }
                                                            if (!var16_11 || !((var46_42 = var17_12.child()) instanceof Cast)) break block12;
                                                            var47_43 = (Cast)var46_42;
                                                            var48_44 = var47_43.child();
                                                            var49_45 = var47_43.dataType();
                                                            var50_46 = ExtractBaseColumn$.MODULE$.unapply(var48_44);
                                                            if (var50_46.isEmpty()) break block12;
                                                            name = (Seq)((Tuple2)var50_46.get())._1();
                                                            var52_48 = (DataType)((Tuple2)var50_46.get())._2();
                                                            if (!DateType$.MODULE$.equals(var52_48) || !DateType$.MODULE$.equals(var49_45)) break block12;
                                                            var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$10(java.lang.String ), ()Lorg/apache/spark/sql/delta/YearPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                            break block8;
                                                        }
                                                        if (!(var24_19 instanceof Month) || !((var54_50 = (var53_49 = (Month)var24_19).child()) instanceof Cast)) break block13;
                                                        var55_51 = (Cast)var54_50;
                                                        var56_52 = var55_51.child();
                                                        var57_53 = var55_51.dataType();
                                                        var58_54 = ExtractBaseColumn$.MODULE$.unapply(var56_52);
                                                        if (var58_54.isEmpty()) break block13;
                                                        name = (Seq)((Tuple2)var58_54.get())._1();
                                                        var60_56 = (DataType)((Tuple2)var58_54.get())._2();
                                                        if (!TimestampType$.MODULE$.equals(var60_56) || !DateType$.MODULE$.equals(var57_53)) break block13;
                                                        var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$11(java.lang.String ), ()Lorg/apache/spark/sql/delta/MonthPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                        break block8;
                                                    }
                                                    if (!(var24_19 instanceof DateFormatClass)) break block14;
                                                    var18_13 = true;
                                                    var19_14 = (DateFormatClass)var24_19;
                                                    var61_57 = var19_14.left();
                                                    var62_58 = var19_14.right();
                                                    if (!(var61_57 instanceof Cast)) break block14;
                                                    var63_59 = (Cast)var61_57;
                                                    var64_60 = var63_59.child();
                                                    var65_61 = var63_59.dataType();
                                                    var66_62 = ExtractBaseColumn$.MODULE$.unapply(var64_60);
                                                    if (var66_62.isEmpty()) break block14;
                                                    name = (Seq)((Tuple2)var66_62.get())._1();
                                                    var68_64 = (DataType)((Tuple2)var66_62.get())._2();
                                                    if (!DateType$.MODULE$.equals(var68_64) || !TimestampType$.MODULE$.equals(var65_61) || (var69_65 = StringLiteral$.MODULE$.unapply((Object)var62_58)).isEmpty()) break block14;
                                                    var71_67 = format = (String)var69_65.get();
                                                    v0 = GeneratedColumn$.MODULE$.DATE_FORMAT_YEAR_MONTH();
                                                    var72_68 = var71_67;
                                                    var9_69 = !(v0 != null ? v0.equals(var72_68) == false : var72_68 != null) ? Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$12(java.lang.String ), ()Lorg/apache/spark/sql/delta/DateFormatPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                                    var6_25 = var9_69;
                                                    break block8;
                                                }
                                                if (!var18_13) break block15;
                                                var73_70 = var19_14.left();
                                                var74_71 = var19_14.right();
                                                var75_72 = ExtractBaseColumn$.MODULE$.unapply(var73_70);
                                                if (var75_72.isEmpty()) break block15;
                                                name = (Seq)((Tuple2)var75_72.get())._1();
                                                var77_74 = (DataType)((Tuple2)var75_72.get())._2();
                                                if (!TimestampType$.MODULE$.equals(var77_74) || (var78_75 = StringLiteral$.MODULE$.unapply((Object)var74_71)).isEmpty()) break block15;
                                                var80_77 = format = (String)var78_75.get();
                                                v1 = GeneratedColumn$.MODULE$.DATE_FORMAT_YEAR_MONTH();
                                                var81_78 = var80_77;
                                                if (!(v1 != null ? v1.equals(var81_78) == false : var81_78 != null)) {
                                                    var8_79 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$13(java.lang.String ), ()Lorg/apache/spark/sql/delta/DateFormatPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                } else {
                                                    v2 = GeneratedColumn$.MODULE$.DATE_FORMAT_YEAR_MONTH_DAY();
                                                    var82_80 = var80_77;
                                                    if (!(v2 != null ? v2.equals(var82_80) == false : var82_80 != null)) {
                                                        var8_79 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$14(java.lang.String ), ()Lorg/apache/spark/sql/delta/DateFormatPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                                    } else {
                                                        v3 = GeneratedColumn$.MODULE$.DATE_FORMAT_YEAR_MONTH_DAY_HOUR();
                                                        var83_81 = var80_77;
                                                        var8_79 = !(v3 != null ? v3.equals(var83_81) == false : var83_81 != null) ? Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$15(java.lang.String ), ()Lorg/apache/spark/sql/delta/DateFormatPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                                    }
                                                }
                                                var6_25 = var8_79;
                                                break block8;
                                            }
                                            if (!(var24_19 instanceof DayOfMonth) || !((var85_83 = (var84_82 = (DayOfMonth)var24_19).child()) instanceof Cast)) break block16;
                                            var86_84 = (Cast)var85_83;
                                            var87_85 = var86_84.child();
                                            var88_86 = var86_84.dataType();
                                            var89_87 = ExtractBaseColumn$.MODULE$.unapply(var87_85);
                                            if (var89_87.isEmpty()) break block16;
                                            name = (Seq)((Tuple2)var89_87.get())._1();
                                            var91_89 = (DataType)((Tuple2)var89_87.get())._2();
                                            if (!TimestampType$.MODULE$.equals(var91_89) || !DateType$.MODULE$.equals(var88_86)) break block16;
                                            var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$16(java.lang.String ), ()Lorg/apache/spark/sql/delta/DayPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                            break block8;
                                        }
                                        if (!(var24_19 instanceof Hour) || (var94_92 = ExtractBaseColumn$.MODULE$.unapply(var93_91 = (var92_90 = (Hour)var24_19).child())).isEmpty()) break block17;
                                        name = (Seq)((Tuple2)var94_92.get())._1();
                                        var96_94 = (DataType)((Tuple2)var94_92.get())._2();
                                        if (!TimestampType$.MODULE$.equals(var96_94)) break block17;
                                        var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$17(java.lang.String ), ()Lorg/apache/spark/sql/delta/HourPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                        break block8;
                                    }
                                    if (!(var24_19 instanceof Substring)) break block18;
                                    var97_95 = (Substring)var24_19;
                                    var98_96 = var97_95.str();
                                    var99_97 = var97_95.pos();
                                    var100_98 = var97_95.len();
                                    var101_99 = ExtractBaseColumn$.MODULE$.unapply(var98_96);
                                    if (var101_99.isEmpty()) break block18;
                                    name = (Seq)((Tuple2)var101_99.get())._1();
                                    var103_101 = (DataType)((Tuple2)var101_99.get())._2();
                                    if (!StringType$.MODULE$.equals(var103_101) || (var104_102 = IntegerLiteral$.MODULE$.unapply((Object)var99_97)).isEmpty()) break block18;
                                    pos = BoxesRunTime.unboxToInt((Object)var104_102.get());
                                    var106_104 = IntegerLiteral$.MODULE$.unapply((Object)var100_98);
                                    if (var106_104.isEmpty()) break block18;
                                    len = BoxesRunTime.unboxToInt((Object)var106_104.get());
                                    var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$18(java.lang.String int int ), ()Lorg/apache/spark/sql/delta/SubstringPartitionExpr;)((String)partColName, (int)pos, (int)len), resolver$1, schema$1, nameNormalizer$1));
                                    break block8;
                                }
                                if (!(var24_19 instanceof TruncTimestamp)) break block19;
                                var20_15 = true;
                                var21_16 = (TruncTimestamp)var24_19;
                                var108_106 = var21_16.format();
                                var109_107 = var21_16.timestamp();
                                var110_108 = StringLiteral$.MODULE$.unapply((Object)var108_106);
                                if (var110_108.isEmpty()) break block19;
                                format = (String)var110_108.get();
                                var112_110 = ExtractBaseColumn$.MODULE$.unapply(var109_107);
                                if (var112_110.isEmpty()) break block19;
                                name = (Seq)((Tuple2)var112_110.get())._1();
                                var114_112 = (DataType)((Tuple2)var112_110.get())._2();
                                if (!TimestampType$.MODULE$.equals(var114_112)) break block19;
                                var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$19(java.lang.String java.lang.String ), ()Lorg/apache/spark/sql/delta/TimestampTruncPartitionExpr;)((String)format, (String)partColName), resolver$1, schema$1, nameNormalizer$1));
                                break block8;
                            }
                            if (!var20_15) break block20;
                            var115_113 = var21_16.format();
                            var116_114 = var21_16.timestamp();
                            var117_115 = StringLiteral$.MODULE$.unapply((Object)var115_113);
                            if (var117_115.isEmpty()) break block20;
                            format = (String)var117_115.get();
                            if (!(var116_114 instanceof Cast)) break block20;
                            var119_117 = (Cast)var116_114;
                            var120_118 = var119_117.child();
                            var121_119 = var119_117.dataType();
                            var122_120 = ExtractBaseColumn$.MODULE$.unapply(var120_118);
                            if (var122_120.isEmpty()) break block20;
                            name = (Seq)((Tuple2)var122_120.get())._1();
                            var124_122 = (DataType)((Tuple2)var122_120.get())._2();
                            if (!DateType$.MODULE$.equals(var124_122) || !TimestampType$.MODULE$.equals(var121_119)) break block20;
                            var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$20(java.lang.String java.lang.String ), ()Lorg/apache/spark/sql/delta/TimestampTruncPartitionExpr;)((String)format, (String)partColName), resolver$1, schema$1, nameNormalizer$1));
                            break block8;
                        }
                        if ((var125_123 = ExtractBaseColumn$.MODULE$.unapply(var24_19)).isEmpty()) break block21;
                        name = (Seq)((Tuple2)var125_123.get())._1();
                        var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$21(java.lang.String ), ()Lorg/apache/spark/sql/delta/IdentityPartitionExpr;)((String)partColName), resolver$1, schema$1, nameNormalizer$1));
                        break block8;
                    }
                    if (!(var24_19 instanceof TruncDate)) break block22;
                    var22_17 = true;
                    var23_18 = (TruncDate)var24_19;
                    var127_125 = var23_18.date();
                    var128_126 = var23_18.format();
                    var129_127 = ExtractBaseColumn$.MODULE$.unapply(var127_125);
                    if (var129_127.isEmpty()) break block22;
                    name = (Seq)((Tuple2)var129_127.get())._1();
                    var131_129 = (DataType)((Tuple2)var129_127.get())._2();
                    if (!DateType$.MODULE$.equals(var131_129) || (var132_130 = StringLiteral$.MODULE$.unapply((Object)var128_126)).isEmpty()) break block22;
                    format = (String)var132_130.get();
                    var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$22(java.lang.String java.lang.String ), ()Lorg/apache/spark/sql/delta/TruncDatePartitionExpr;)((String)partColName, (String)format), resolver$1, schema$1, nameNormalizer$1));
                    break block8;
                }
                if (!var22_17) ** GOTO lbl-1000
                var134_132 = var23_18.date();
                var135_133 = var23_18.format();
                if (!(var134_132 instanceof Cast)) ** GOTO lbl-1000
                var136_134 = (Cast)var134_132;
                var137_135 = var136_134.child();
                var138_136 = var136_134.dataType();
                var139_137 = ExtractBaseColumn$.MODULE$.unapply(var137_135);
                if (var139_137.isEmpty()) ** GOTO lbl-1000
                name = (Seq)((Tuple2)var139_137.get())._1();
                var141_139 = (DataType)((Tuple2)var139_137.get())._2();
                var7_140 = TimestampType$.MODULE$.equals(var141_139) != false ? true : StringType$.MODULE$.equals(var141_139) != false;
                if (var7_140 && DateType$.MODULE$.equals(var138_136) && !(var142_141 = StringLiteral$.MODULE$.unapply((Object)var135_133)).isEmpty()) {
                    format = (String)var142_141.get();
                    var6_25 = Option$.MODULE$.option2Iterable($this.createExpr$1(name, (Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getOptimizablePartitionExpressions$23(java.lang.String java.lang.String ), ()Lorg/apache/spark/sql/delta/TruncDatePartitionExpr;)((String)partColName, (String)format), resolver$1, schema$1, nameNormalizer$1));
                } else lbl-1000:
                // 4 sources

                {
                    var6_25 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                break block8;
            }
            throw DeltaErrors$.MODULE$.unexpectedAlias(String.valueOf(var10_5));
        }
        var5_143 = var6_25;
        return var5_143;
    }

    private static final boolean isRedundantPartitionExpr$1(OptimizablePartitionExpression f) {
        return f instanceof YearPartitionExpr || f instanceof MonthPartitionExpr || f instanceof DayPartitionExpr || f instanceof HourPartitionExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Expression preprocess$1(Expression filter) {
        Expression expression = filter;
        if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression lit = lessThan.left();
            Expression e = lessThan.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression2 = e;
                    return new GreaterThan(expression2, (Expression)literal);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression lit = lessThanOrEqual.left();
            Expression e = lessThanOrEqual.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression3 = e;
                    return new GreaterThanOrEqual(expression3, (Expression)literal);
                }
            }
        }
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression lit = equalTo.left();
            Expression e = equalTo.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression4 = e;
                    return new EqualTo(expression4, (Expression)literal);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression lit = greaterThan.left();
            Expression e = greaterThan.right();
            if (lit instanceof Literal) {
                Literal literal = (Literal)lit;
                if (e != null) {
                    Expression expression5 = e;
                    return new LessThan(expression5, (Expression)literal);
                }
            }
        }
        if (!(expression instanceof GreaterThanOrEqual)) return expression;
        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
        Expression lit = greaterThanOrEqual.left();
        Expression e = greaterThanOrEqual.right();
        if (!(lit instanceof Literal)) return expression;
        Literal literal = (Literal)lit;
        if (e == null) return expression;
        Expression expression6 = e;
        return new LessThanOrEqual(expression6, (Expression)literal);
    }

    private final Seq toPartitionFilter$1(Seq nameParts, Function1 func, Map optimizablePartitionExpressions$1) {
        return (Seq)Option$.MODULE$.option2Iterable(optimizablePartitionExpressions$1.get((Object)this.createFieldPath((Seq<String>)nameParts))).toSeq().flatMap((Function1 & Serializable & scala.Serializable)exprs -> (Seq)exprs.flatMap((Function1 & Serializable & scala.Serializable)expr -> Option$.MODULE$.option2Iterable((Option)func.apply(expr)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Seq $anonfun$generatePartitionFilters$3(GeneratedColumn$ $this, Map optimizablePartitionExpressions$1, Expression filter) {
        Expression expression = GeneratedColumn$.preprocess$1(filter);
        if (expression instanceof LessThan) {
            LessThan lessThan = (LessThan)expression;
            Expression expression2 = lessThan.left();
            Expression lit = lessThan.right();
            Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression2);
            if (!option.isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$8 -> x$8.lessThan(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)expression;
            Expression expression3 = lessThanOrEqual.left();
            Expression lit = lessThanOrEqual.right();
            Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression3);
            if (!option.isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$9 -> x$9.lessThanOrEqual(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)expression;
            Expression expression4 = equalTo.left();
            Expression lit = equalTo.right();
            Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression4);
            if (!option.isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$10 -> x$10.equalTo(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)expression;
            Expression expression5 = greaterThan.left();
            Expression lit = greaterThan.right();
            Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression5);
            if (!option.isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$11 -> x$11.greaterThan(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression expression6 = greaterThanOrEqual.left();
            Expression lit = greaterThanOrEqual.right();
            Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression6);
            if (!option.isEmpty()) {
                Seq nameParts = (Seq)((Tuple2)option.get())._1();
                if (lit instanceof Literal) {
                    Literal literal = (Literal)lit;
                    return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$12 -> x$12.greaterThanOrEqual(literal), optimizablePartitionExpressions$1);
                }
            }
        }
        if (!(expression instanceof IsNull)) return Nil$.MODULE$;
        IsNull isNull = (IsNull)expression;
        Expression expression7 = isNull.child();
        Option<Tuple2<Seq<String>, DataType>> option = ExtractBaseColumn$.MODULE$.unapply(expression7);
        if (option.isEmpty()) return Nil$.MODULE$;
        Seq nameParts = (Seq)((Tuple2)option.get())._1();
        return $this.toPartitionFilter$1(nameParts, (Function1 & Serializable & scala.Serializable)x$13 -> x$13.isNull(), optimizablePartitionExpressions$1);
    }

    private GeneratedColumn$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        AnalysisHelper.$init$(this);
        this.DATE_FORMAT_YEAR_MONTH = "yyyy-MM";
        this.DATE_FORMAT_YEAR_MONTH_DAY = "yyyy-MM-dd";
        this.DATE_FORMAT_YEAR_MONTH_DAY_HOUR = "yyyy-MM-dd-HH";
    }
}

