/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005MgaB\b\u0011!\u0003\r\t!\b\u0005\u0006Q\u0001!\t!\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u0015i\u0004\u0001\"\u0003?\u0011\u0015y\u0006\u0001\"\u0005a\u0011\u0019y\b\u0001\"\u0005\u0002\u0002!I\u0011\u0011\u0003\u0001\u0012\u0002\u0013E\u00111\u0003\u0005\n\u0003S\u0001\u0011\u0013!C\t\u0003'Aq!a\u000b\u0001\t#\ti\u0003C\u0004\u0002B\u0001!\t\"a\u0011\t\u000f\u0005\u0005\u0004\u0001\"\u0005\u0002d!9\u0011Q\u0013\u0001\u0005\u0012\u0005]\u0005bBAN\u0001\u0011E\u0011Q\u0014\u0005\b\u0003C\u0003A\u0011CAR\u0011\u001d\ty\f\u0001C\t\u0003\u0003\u0014\u0011CV1dkVl7i\\7nC:$\u0017*\u001c9m\u0015\t\t\"#\u0001\u0005d_6l\u0017M\u001c3t\u0015\t\u0019B#A\u0003eK2$\u0018M\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005\u0001\u0012BA\u0014\u0011\u00051!U\r\u001c;b\u0007>lW.\u00198e\u0003\u0019!\u0013N\\5uIQ\t!\u0006\u0005\u0002 W%\u0011A\u0006\t\u0002\u0005+:LG/A\u000btkB\u0004xN\u001d;fI\u001a\u001bhi\u001c:M_\u001e<\u0017N\\4\u0016\u0003=\u00022\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003iE\u00121aU3r!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u0012aa\u0015;sS:<\u0017aD:i_VdG\rT8h-\u0006\u001cW/^7\u0015\u000b}\u0012u)T,\u0011\u0005}\u0001\u0015BA!!\u0005\u001d\u0011un\u001c7fC:DQaF\u0002A\u0002\r\u0003\"\u0001R#\u000e\u0003QI!A\u0012\u000b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b!\u001b\u0001\u0019A%\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004\"AS&\u000e\u0003II!\u0001\u0014\n\u0003\u0011\u0011+G\u000e^1M_\u001eDQAT\u0002A\u0002=\u000b!\u0002[1e_>\u00048i\u001c8g!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0003d_:4'B\u0001+\u0019\u0003\u0019A\u0017\rZ8pa&\u0011a+\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000ba\u001b\u0001\u0019A-\u0002\tA\fG\u000f\u001b\t\u00035vk\u0011a\u0017\u0006\u00039N\u000b!AZ:\n\u0005y[&\u0001\u0002)bi\"\fa\u0002\\8h-\u0006\u001cW/^7Ti\u0006\u0014H\u000f\u0006\u0005+C\n\u001cGm\u001d=~\u0011\u00159B\u00011\u0001D\u0011\u0015AE\u00011\u0001J\u0011\u0015AF\u00011\u0001Z\u0011\u0015)G\u00011\u0001g\u0003\u0011!\u0017N\u001a4\u0011\u0007\u0011;\u0017.\u0003\u0002i)\t9A)\u0019;bg\u0016$\bC\u00016r\u001d\tYw\u000e\u0005\u0002mA5\tQN\u0003\u0002o9\u00051AH]8pizJ!\u0001\u001d\u0011\u0002\rA\u0013X\rZ3g\u0013\ta$O\u0003\u0002qA!)A\u000f\u0002a\u0001k\u0006\u00112/\u001b>f\u001f\u001a$\u0015\r^1U_\u0012+G.\u001a;f!\tyb/\u0003\u0002xA\t!Aj\u001c8h\u0011\u0015IH\u00011\u0001{\u0003a\u0019\b/Z2jM&,GMU3uK:$\u0018n\u001c8NS2d\u0017n\u001d\t\u0004?m,\u0018B\u0001?!\u0005\u0019y\u0005\u000f^5p]\")a\u0010\u0002a\u0001k\u00061B-\u001a4bk2$(+\u001a;f]RLwN\\'jY2L7/\u0001\u0007m_\u001e4\u0016mY;v[\u0016sG\rF\u0006+\u0003\u0007\t)!a\u0002\u0002\n\u00055\u0001\"\u0002%\u0006\u0001\u0004I\u0005\"B\f\u0006\u0001\u0004\u0019\u0005\"\u0002-\u0006\u0001\u0004I\u0006\u0002CA\u0006\u000bA\u0005\t\u0019\u0001>\u0002\u0019\u0019LG.Z:EK2,G/\u001a3\t\u0011\u0005=Q\u0001%AA\u0002i\f\u0011\u0002Z5s\u0007>,h\u000e^:\u0002-1|wMV1dkVlWI\u001c3%I\u00164\u0017-\u001e7uIQ*\"!!\u0006+\u0007i\f9b\u000b\u0002\u0002\u001aA!\u00111DA\u0013\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012!C;oG\",7m[3e\u0015\r\t\u0019\u0003I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0014\u0003;\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Yawn\u001a,bGV,X.\u00128eI\u0011,g-Y;mi\u0012*\u0014A\u0003:fY\u0006$\u0018N^5{KRI\u0011.a\f\u00022\u0005e\u0012Q\b\u0005\u00061\"\u0001\r!\u0017\u0005\u00079\"\u0001\r!a\r\u0011\u0007i\u000b)$C\u0002\u00028m\u0013!BR5mKNK8\u000f^3n\u0011\u0019\tY\u0004\u0003a\u00013\u0006i!/Z:feZ|\u0017N\u001d\"bg\u0016Da!a\u0010\t\u0001\u0004y\u0014!B5t\t&\u0014\u0018!D4fi\u0006cGnU;cI&\u00148\u000f\u0006\u0005\u0002F\u0005]\u00131LA0!\u0015\t9%!\u0015j\u001d\u0011\tI%!\u0014\u000f\u00071\fY%C\u0001\"\u0013\r\ty\u0005I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u0003\u0011%#XM]1u_JT1!a\u0014!\u0011\u0019\tI&\u0003a\u0001S\u0006!!-Y:f\u0011\u0019\ti&\u0003a\u0001S\u0006!a-\u001b7f\u0011\u0019a\u0016\u00021\u0001\u00024\u00051A-\u001a7fi\u0016$R\"^A3\u0003O\nI'!\u001c\u0002\b\u0006-\u0005\"B3\u000b\u0001\u00041\u0007\"B\f\u000b\u0001\u0004\u0019\u0005BBA6\u0015\u0001\u0007\u0011.\u0001\u0005cCN,\u0007+\u0019;i\u0011\u0019q%\u00021\u0001\u0002pA1\u0011\u0011OA<\u0003wj!!a\u001d\u000b\u0007\u0005Ud#A\u0005ce>\fGmY1ti&!\u0011\u0011PA:\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tIF\u0001\u0005kRLG.\u0003\u0003\u0002\u0006\u0006}$!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:Da!!#\u000b\u0001\u0004y\u0014\u0001\u00039be\u0006dG.\u001a7\t\u000f\u00055%\u00021\u0001\u0002\u0010\u0006\u0011\u0002/\u0019:bY2,G\u000eU1si&$\u0018n\u001c8t!\ry\u0012\u0011S\u0005\u0004\u0003'\u0003#aA%oi\u0006a1\u000f\u001e:j]\u001e$v\u000eU1uQR\u0019\u0011,!'\t\u000ba[\u0001\u0019A5\u0002\u0019A\fG\u000f\u001b+p'R\u0014\u0018N\\4\u0015\u0007%\fy\nC\u0003Y\u0019\u0001\u0007\u0011,A\u000bhKR\f5\r^5p]J+G.\u0019;jm\u0016\u0004\u0016\r\u001e5\u0015\u0015\u0005\u0015\u0016qUA\\\u0003s\u000bY\fE\u0002 w&Dq!!+\u000e\u0001\u0004\tY+\u0001\u0004bGRLwN\u001c\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u0017\n\u0002\u000f\u0005\u001cG/[8og&!\u0011QWAX\u0005)1\u0015\u000e\\3BGRLwN\u001c\u0005\u000796\u0001\r!a\r\t\r\u0005-T\u00021\u0001Z\u0011\u0019\ti,\u0004a\u0001\u007f\u0005)\"/\u001a7bi&4\u0018N_3JO:|'/Z#se>\u0014\u0018aH4fiZ\u000bG.\u001b3SK2\fG/\u001b<f!\u0006$\bn]!oIN+(\rZ5sgRa\u00111YAd\u0003\u0013\fY-!4\u0002PB)\u0011qIAcS&\u0019A'!\u0016\t\u000f\u0005%f\u00021\u0001\u0002,\"1AL\u0004a\u0001\u0003gAa!a\u001b\u000f\u0001\u0004I\u0006BBA_\u001d\u0001\u0007q\b\u0003\u0004\u0002R:\u0001\raP\u0001\u0010SN\u0014En\\8n\r&dG/\u001a:fI\u0002")
public interface VacuumCommandImpl
extends DeltaCommand {
    public void org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq(Seq<String> var1);

    public Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging();

    private boolean shouldLogVacuum(SparkSession spark, DeltaLog deltaLog, Configuration hadoopConf, Path path) {
        boolean bl;
        Option logVacuumConf = spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_LOGGING_ENABLED());
        if (logVacuumConf.nonEmpty()) {
            return BoxesRunTime.unboxToBoolean((Object)logVacuumConf.get());
        }
        LogStore logStore = deltaLog.store();
        try {
            URI rawResolvedUri = logStore.resolvePathOnPhysicalStorage(path, hadoopConf).toUri();
            String scheme = rawResolvedUri.getScheme();
            bl = this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging().contains((Object)scheme);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Vacuum event logging not enabled on this file system because we cannot detect your cloud storage type.");
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void logVacuumStart$(VacuumCommandImpl $this, SparkSession spark, DeltaLog deltaLog, Path path, Dataset diff, long sizeOfDataToDelete, Option specifiedRetentionMillis, long defaultRetentionMillis) {
        $this.logVacuumStart(spark, deltaLog, path, (Dataset<String>)diff, sizeOfDataToDelete, (Option<Object>)specifiedRetentionMillis, defaultRetentionMillis);
    }

    default public void logVacuumStart(SparkSession spark, DeltaLog deltaLog, Path path, Dataset<String> diff, long sizeOfDataToDelete, Option<Object> specifiedRetentionMillis, long defaultRetentionMillis) {
        block0: {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Deleting untracked files and empty directories in ").append(path).append(". The amount of data to be ").append("deleted is ").append(sizeOfDataToDelete).append(" (in bytes)").toString());
            if (!this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) break block0;
            boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
            OptimisticTransaction txn = deltaLog.startTransaction();
            Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFilesToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files to deleted")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeOfDataToDelete"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "The total amount of data to be deleted in bytes"))}));
            ((SQLMetric)metrics.apply((Object)"numFilesToDelete")).set(diff.count());
            ((SQLMetric)metrics.apply((Object)"sizeOfDataToDelete")).set(sizeOfDataToDelete);
            txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
            txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumStart(checkEnabled, specifiedRetentionMillis, defaultRetentionMillis));
        }
    }

    public static /* synthetic */ void logVacuumEnd$(VacuumCommandImpl $this, DeltaLog deltaLog, SparkSession spark, Path path, Option filesDeleted, Option dirCounts) {
        $this.logVacuumEnd(deltaLog, spark, path, (Option<Object>)filesDeleted, (Option<Object>)dirCounts);
    }

    default public void logVacuumEnd(DeltaLog deltaLog, SparkSession spark, Path path, Option<Object> filesDeleted, Option<Object> dirCounts) {
        block3: {
            Object object;
            if (this.shouldLogVacuum(spark, deltaLog, deltaLog.newDeltaHadoopConf(), path)) {
                String status;
                OptimisticTransaction txn = deltaLog.startTransaction();
                String string = status = filesDeleted.isEmpty() && dirCounts.isEmpty() ? "FAILED" : "COMPLETED";
                if (filesDeleted.nonEmpty() && dirCounts.nonEmpty()) {
                    Map metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "number of files deleted.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numVacuumedDirectories"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "num of directories vacuumed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)SQLMetrics$.MODULE$.createMetric(spark.sparkContext(), "status of vacuum"))}));
                    ((SQLMetric)metrics.apply((Object)"numDeletedFiles")).set(BoxesRunTime.unboxToLong((Object)filesDeleted.get()));
                    ((SQLMetric)metrics.apply((Object)"numVacuumedDirectories")).set(BoxesRunTime.unboxToLong((Object)dirCounts.get()));
                    txn.registerSQLMetrics(spark, (Map<String, SQLMetric>)metrics);
                }
                object = BoxesRunTime.boxToLong((long)txn.commit((Seq<Action>)((Seq)Nil$.MODULE$), new DeltaOperations.VacuumEnd(status)));
            } else {
                object = BoxedUnit.UNIT;
            }
            if (!filesDeleted.nonEmpty()) break block3;
            this.logConsole(new StringBuilder(58).append("Deleted ").append(filesDeleted.get()).append(" files and directories in a total ").append("of ").append(dirCounts.get()).append(" directories.").toString());
        }
    }

    public static /* synthetic */ Option logVacuumEnd$default$4$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$4();
    }

    default public Option<Object> logVacuumEnd$default$4() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option logVacuumEnd$default$5$(VacuumCommandImpl $this) {
        return $this.logVacuumEnd$default$5();
    }

    default public Option<Object> logVacuumEnd$default$5() {
        return None$.MODULE$;
    }

    public static /* synthetic */ String relativize$(VacuumCommandImpl $this, Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return $this.relativize(path, fs, reservoirBase, isDir);
    }

    default public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return this.pathToString(DeltaFileOperations$.MODULE$.tryRelativizePath(fs, reservoirBase, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4()));
    }

    public static /* synthetic */ Iterator getAllSubdirs$(VacuumCommandImpl $this, String base, String file, FileSystem fs) {
        return $this.getAllSubdirs(base, file, fs);
    }

    default public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return (Iterator)DeltaFileOperations$.MODULE$.getAllSubDirectories(base, file)._1();
    }

    public static /* synthetic */ long delete$(VacuumCommandImpl $this, Dataset diff, SparkSession spark, String basePath, Broadcast hadoopConf, boolean parallel, int parallelPartitions) {
        return $this.delete((Dataset<String>)diff, spark, basePath, (Broadcast<SerializableConfiguration>)hadoopConf, parallel, parallelPartitions);
    }

    default public long delete(Dataset<String> diff, SparkSession spark, String basePath, Broadcast<SerializableConfiguration> hadoopConf, boolean parallel, int parallelPartitions) {
        long l;
        if (parallel) {
            l = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])diff.repartition(parallelPartitions).mapPartitions((Function1 & Serializable & scala.Serializable)files -> {
                FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                int filesDeletedPerPartition = files.map((Function1 & Serializable & scala.Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{filesDeletedPerPartition}));
            }, org.apache.spark.sql.delta.implicits.package$.MODULE$.intEncoder()).collect())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        } else {
            FileSystem fs = new Path(basePath).getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
            Iterator fileResultSet = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(diff.toLocalIterator()).asScala();
            l = fileResultSet.map((Function1 & Serializable & scala.Serializable)p -> this.stringToPath((String)p)).count((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.tryDeleteNonRecursive(fs, f, DeltaFileOperations$.MODULE$.tryDeleteNonRecursive$default$3())));
        }
        return l;
    }

    public static /* synthetic */ Path stringToPath$(VacuumCommandImpl $this, String path) {
        return $this.stringToPath(path);
    }

    default public Path stringToPath(String path) {
        return new Path(new URI(path));
    }

    public static /* synthetic */ String pathToString$(VacuumCommandImpl $this, Path path) {
        return $this.pathToString(path);
    }

    default public String pathToString(Path path) {
        return path.toUri().toString();
    }

    public static /* synthetic */ Option getActionRelativePath$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return $this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError);
    }

    default public Option<String> getActionRelativePath(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        Path maybeRelative;
        Path filePath = this.stringToPath(action.path());
        return filePath.isAbsolute() ? ((maybeRelative = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, filePath, relativizeIgnoreError)).isAbsolute() ? None$.MODULE$ : new Some((Object)this.pathToString(maybeRelative))) : new Some((Object)this.pathToString(filePath));
    }

    public static /* synthetic */ Seq getValidRelativePathsAndSubdirs$(VacuumCommandImpl $this, FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError, boolean isBloomFiltered) {
        return $this.getValidRelativePathsAndSubdirs(action, fs, basePath, relativizeIgnoreError, isBloomFiltered);
    }

    default public Seq<String> getValidRelativePathsAndSubdirs(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError, boolean isBloomFiltered) {
        return (Seq)this.getActionRelativePath(action, fs, basePath, relativizeIgnoreError).map((Function1 & Serializable & scala.Serializable)relativePath -> (Seq)((TraversableLike)new .colon.colon(relativePath, (List)Nil$.MODULE$)).$plus$plus(this.getAllSubdirs("/", (String)relativePath, fs), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public static void $init$(VacuumCommandImpl $this) {
        $this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wasbs", "wasbss", "abfs", "abfss", "adl", "gs", "file", "hdfs"}))));
    }
}

