/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.dropwizard.jersey.caching.CacheControlledResponseFeature;
import io.dropwizard.jersey.guava.OptionalMessageBodyWriter;
import io.dropwizard.jersey.guava.OptionalParamFeature;
import io.dropwizard.jersey.params.NonEmptyStringParamFeature;
import io.dropwizard.jersey.sessions.SessionFactoryProvider;
import io.dropwizard.jersey.validation.HibernateValidationFeature;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.server.validation.ValidationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardResourceConfig
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardResourceConfig.class);
    private static final String NEWLINE = String.format("%n", new Object[0]);
    private String urlPattern = "/*";

    public DropwizardResourceConfig(MetricRegistry metricRegistry) {
        this(false, metricRegistry);
    }

    public DropwizardResourceConfig() {
        this(true, null);
    }

    public DropwizardResourceConfig(boolean testOnly, MetricRegistry metricRegistry) {
        if (metricRegistry == null) {
            metricRegistry = new MetricRegistry();
        }
        this.property("jersey.config.server.wadl.disableWadl", Boolean.TRUE);
        if (!testOnly) {
            this.register(new ComponentLoggingListener(this));
        }
        this.register(new InstrumentedResourceMethodApplicationListener(metricRegistry));
        this.register(CacheControlledResponseFeature.class);
        this.register(OptionalMessageBodyWriter.class);
        this.register(OptionalParamFeature.class);
        this.register(NonEmptyStringParamFeature.class);
        this.register((Object)new SessionFactoryProvider.Binder());
        this.register(HibernateValidationFeature.class);
        this.register(ValidationFeature.class);
    }

    public static DropwizardResourceConfig forTesting(MetricRegistry metricRegistry) {
        return new DropwizardResourceConfig(true, metricRegistry);
    }

    public void logComponents() {
        LOGGER.debug("resources = {}", this.canonicalNamesByAnnotation(Path.class));
        LOGGER.debug("providers = {}", this.canonicalNamesByAnnotation(Provider.class));
        LOGGER.info(this.getEndpointsInfo());
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    @VisibleForTesting
    Set<Class<?>> allClasses() {
        HashSet allClasses = Sets.newHashSet((Iterable)this.getClasses());
        for (Object singleton : this.getSingletons()) {
            allClasses.add(singleton.getClass());
        }
        return allClasses;
    }

    private Set<String> canonicalNamesByAnnotation(Class<? extends Annotation> annotation) {
        HashSet result = Sets.newHashSet();
        for (Class clazz : this.getClasses()) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            result.add(clazz.getCanonicalName());
        }
        return result;
    }

    public String getEndpointsInfo() {
        StringBuilder msg = new StringBuilder(1024);
        ArrayList endpointLogLines = Lists.newArrayList();
        msg.append("The following paths were found for the configured resources:");
        msg.append(NEWLINE).append(NEWLINE);
        HashSet allResources = Sets.newHashSet();
        for (Class<?> clazz : this.allClasses()) {
            if (clazz.isInterface() || Resource.from(clazz) == null) continue;
            allResources.add(clazz);
        }
        for (Class<Object> klass : allResources) {
            new EndpointLogger(this.urlPattern, klass).populate(endpointLogLines);
        }
        if (!endpointLogLines.isEmpty()) {
            Collections.sort(endpointLogLines, new EndpointComparator());
            for (EndpointLogLine line : endpointLogLines) {
                msg.append(line).append(NEWLINE);
            }
        } else {
            msg.append("    NONE").append(NEWLINE);
        }
        return msg.toString();
    }

    private static class ComponentLoggingListener
    implements ApplicationEventListener {
        private final DropwizardResourceConfig config;

        public ComponentLoggingListener(DropwizardResourceConfig config) {
            this.config = config;
        }

        public void onEvent(ApplicationEvent event) {
            if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                this.config.logComponents();
            }
        }

        public RequestEventListener onRequest(RequestEvent requestEvent) {
            return null;
        }
    }

    private static class EndpointComparator
    implements Comparator<EndpointLogLine>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EndpointComparator() {
        }

        @Override
        public int compare(EndpointLogLine endpointA, EndpointLogLine endpointB) {
            return ComparisonChain.start().compare((Comparable)((Object)endpointA.basePath), (Comparable)((Object)endpointB.basePath)).compare((Comparable)((Object)endpointA.httpMethod), (Comparable)((Object)endpointB.httpMethod)).result();
        }
    }

    private static class EndpointLogLine {
        private final String httpMethod;
        private final String basePath;
        private final Class<?> klass;

        public EndpointLogLine(String httpMethod, String basePath, Class<?> klass) {
            this.basePath = basePath;
            this.klass = klass;
            this.httpMethod = httpMethod;
        }

        public String toString() {
            return String.format("    %-7s %s (%s)", this.httpMethod, this.basePath, this.klass.getCanonicalName());
        }
    }

    private static class EndpointLogger {
        private final String rootPath;
        private final Class<?> klass;

        public EndpointLogger(String urlPattern, Class<?> klass) {
            this.rootPath = urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 1) : urlPattern;
            this.klass = klass;
        }

        public void populate(List<EndpointLogLine> endpointLogLines) {
            this.populate(this.rootPath, this.klass, false, endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, List<EndpointLogLine> endpointLogLines) {
            this.populate(basePath, klass, isLocator, Resource.from(klass), endpointLogLines);
        }

        private void populate(String basePath, Class<?> klass, boolean isLocator, Resource resource, List<EndpointLogLine> endpointLogLines) {
            if (!isLocator) {
                basePath = this.normalizePath(basePath, resource.getPath());
            }
            for (ResourceMethod method : resource.getResourceMethods()) {
                endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), basePath, klass));
            }
            for (Resource childResource : resource.getChildResources()) {
                for (ResourceMethod method : childResource.getAllMethods()) {
                    String path;
                    if (method.getType() == ResourceMethod.JaxrsType.RESOURCE_METHOD) {
                        path = this.normalizePath(basePath, childResource.getPath());
                        endpointLogLines.add(new EndpointLogLine(method.getHttpMethod(), path, klass));
                        continue;
                    }
                    if (method.getType() != ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR) continue;
                    path = this.normalizePath(basePath, childResource.getPath());
                    this.populate(path, method.getInvocable().getRawResponseType(), true, endpointLogLines);
                }
            }
        }

        private String normalizePath(String basePath, String path) {
            if (path == null) {
                return basePath;
            }
            if (basePath.endsWith("/")) {
                return path.startsWith("/") ? basePath + path.substring(1) : basePath + path;
            }
            return path.startsWith("/") ? basePath + path : basePath + "/" + path;
        }
    }
}

