/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jersey.validation.ConstraintMessage;
import io.dropwizard.jersey.validation.ValidationErrorMessage;
import io.dropwizard.validation.ConstraintViolations;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    public Response toResponse(ConstraintViolationException exception) {
        ImmutableList errors = FluentIterable.from((Iterable)exception.getConstraintViolations()).transform(new Function<ConstraintViolation<?>, String>(){

            public String apply(ConstraintViolation<?> v) {
                return ConstraintMessage.getMessage(v);
            }
        }).toList();
        if (errors.size() == 0) {
            errors = ImmutableList.of((Object)Strings.nullToEmpty((String)exception.getMessage()));
        }
        return Response.status((int)ConstraintViolations.determineStatus((Set)exception.getConstraintViolations())).entity((Object)new ValidationErrorMessage((ImmutableList<String>)errors)).build();
    }
}

