/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import com.google.common.base.Throwables;
import io.dropwizard.jersey.errors.ErrorMessage;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JsonProcessingExceptionMapper
extends LoggingExceptionMapper<JsonProcessingException> {
    private static final Pattern WRONG_TYPE_REGEX = Pattern.compile("factory method to deserialize from \\w+ value");
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessingExceptionMapper.class);
    private final boolean showDetails;

    public JsonProcessingExceptionMapper() {
        this(false);
    }

    public JsonProcessingExceptionMapper(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    @Override
    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            return super.toResponse(exception);
        }
        String message = exception.getOriginalMessage();
        if (exception instanceof JsonMappingException) {
            boolean beanError;
            JsonMappingException ex = (JsonMappingException)exception;
            Throwable cause = Throwables.getRootCause((Throwable)ex);
            boolean clientCause = cause instanceof InvalidFormatException || cause instanceof PropertyBindingException;
            boolean bl = beanError = cause.getMessage() == null || cause.getMessage().startsWith("No suitable constructor found") || cause.getMessage().startsWith("No serializer found for class") || cause.getMessage().startsWith("Can not construct instance") && !WRONG_TYPE_REGEX.matcher(cause.getMessage()).find();
            if (beanError && !clientCause) {
                return super.toResponse(exception);
            }
        }
        LOGGER.debug("Unable to process JSON", (Throwable)exception);
        ErrorMessage errorMessage = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process JSON", this.showDetails ? message : null);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorMessage).build();
    }
}

