/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.MessageBodyWorkers;

public abstract class ErrorEntityWriter<T, U>
implements MessageBodyWriter<T> {
    private MediaType contentType;
    private Class<U> representation;
    @Context
    private HttpHeaders headers;
    @Context
    private Provider<MessageBodyWorkers> mbw;

    public ErrorEntityWriter(MediaType contentType, Class<U> representation) {
        this.contentType = contentType;
        this.representation = representation;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.headers.getAcceptableMediaTypes().contains(this.contentType);
    }

    public long getSize(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(T entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> responseHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        MessageBodyWriter writer = ((MessageBodyWorkers)this.mbw.get()).getMessageBodyWriter(this.representation, this.representation, annotations, this.contentType);
        responseHeaders.putSingle((Object)"Content-Type", (Object)this.contentType);
        writer.writeTo(this.getRepresentation(entity), this.representation, this.representation, annotations, this.contentType, responseHeaders, entityStream);
    }

    protected abstract U getRepresentation(T var1);
}

