/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.CacheMode;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.LoadBeanBuffer;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LoadBeanRequest
extends LoadRequest {
    private final Set<EntityBeanIntercept> batch;
    private final LoadBeanBuffer loadBuffer;
    private final String lazyLoadProperty;
    private final boolean loadCache;
    private final boolean alreadyLoaded;

    public LoadBeanRequest(LoadBeanBuffer loadBuffer, EntityBeanIntercept ebi, boolean loadCache) {
        this(loadBuffer, null, true, ebi.getLazyLoadProperty(), ebi.isLoaded(), loadCache || ebi.isLoadedFromCache());
    }

    public LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest) {
        this(loadBuffer, parentRequest, false, null, false, false);
    }

    private LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest, boolean lazy, String lazyLoadProperty, boolean alreadyLoaded, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadBuffer = loadBuffer;
        this.batch = loadBuffer.batch();
        this.lazyLoadProperty = lazyLoadProperty;
        this.alreadyLoaded = alreadyLoaded;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> beanType() {
        return this.loadBuffer.descriptor().type();
    }

    public String description() {
        return this.loadBuffer.fullPath();
    }

    public Set<EntityBeanIntercept> batch() {
        return this.batch;
    }

    public List<Object> getIdList() {
        ArrayList<Object> idList = new ArrayList<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.descriptor();
        for (EntityBeanIntercept ebi : this.batch) {
            idList.add(desc.getId(ebi.getOwner()));
        }
        return idList;
    }

    public void configureQuery(SpiQuery<?> query, List<Object> idList) {
        query.setMode(SpiQuery.Mode.LAZYLOAD_BEAN);
        query.setPersistenceContext(this.loadBuffer.persistenceContext());
        query.setLoadDescription(this.lazy ? "+lazy" : "+query", this.description());
        if (this.lazy) {
            query.setLazyLoadBatchSize(this.loadBuffer.batchSize());
            if (this.alreadyLoaded) {
                query.setBeanCacheMode(CacheMode.OFF);
            }
        } else {
            query.setBeanCacheMode(CacheMode.OFF);
        }
        this.loadBuffer.configureQuery(query, this.lazyLoadProperty);
        if (this.loadCache) {
            query.setBeanCacheMode(CacheMode.PUT);
        }
        if (idList.size() == 1) {
            query.where().idEq(idList.get(0));
        } else {
            query.where().idIn(idList);
        }
    }

    public void postLoad(List<?> list) {
        HashSet<Object> loadedIds = new HashSet<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.descriptor();
        for (Object bean : list) {
            loadedIds.add(desc.id(bean));
        }
        if (this.loadCache) {
            desc.cacheBeanPutAll(list);
        }
        if (this.lazyLoadProperty != null) {
            for (EntityBeanIntercept ebi : this.batch) {
                Object id = desc.getId(ebi.getOwner());
                if (loadedIds.contains(id)) continue;
                desc.markAsDeleted(ebi.getOwner());
            }
        }
    }
}

