/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.Query;
import io.ebean.SqlUpdate;
import io.ebean.Transaction;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanCollectionAdd;
import io.ebean.bean.EntityBean;
import io.ebean.bean.PersistenceContext;
import io.ebean.plugin.PropertyAssocMany;
import io.ebean.text.PathProperties;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.json.SpiJsonReader;
import io.ebeaninternal.api.json.SpiJsonWriter;
import io.ebeaninternal.server.deploy.BeanCollectionHelp;
import io.ebeaninternal.server.deploy.BeanCollectionHelpFactory;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanDescriptorInitContext;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocManyJsonHelp;
import io.ebeaninternal.server.deploy.BeanPropertyAssocManySqlHelp;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.ExportedProperty;
import io.ebeaninternal.server.deploy.IntersectionBuilder;
import io.ebeaninternal.server.deploy.IntersectionRow;
import io.ebeaninternal.server.deploy.IntersectionTable;
import io.ebeaninternal.server.deploy.ManyType;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.deploy.id.ImportedId;
import io.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import io.ebeaninternal.server.el.ElPropertyChainBuilder;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.SqlBeanLoad;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;

public class BeanPropertyAssocMany<T>
extends BeanPropertyAssoc<T>
implements STreePropertyAssocMany,
PropertyAssocMany {
    private final BeanPropertyAssocManyJsonHelp jsonHelp;
    private final TableJoin intersectionJoin;
    private final String intersectionPublishTable;
    private final String intersectionDraftTable;
    private final boolean orphanRemoval;
    private IntersectionTable intersectionTable;
    final TableJoin inverseJoin;
    private final boolean unidirectional;
    private final boolean o2mJoinTable;
    private final boolean hasOrderColumn;
    private final boolean manyToMany;
    private final boolean elementCollection;
    final BeanDescriptor<T> elementDescriptor;
    private final String fetchOrderBy;
    private String lazyFetchOrderBy;
    private final String mapKey;
    private final ManyType manyType;
    private final BeanCollection.ModifyListenMode modifyListenMode;
    private BeanProperty mapKeyProperty;
    private BeanPropertyAssocOne<?> childMasterProperty;
    private String childMasterIdProperty;
    private boolean embeddedExportedProperties;
    private BeanCollectionHelp<T> help;
    private ImportedId importedId;
    private BeanPropertyAssocManySqlHelp<T> sqlHelp;

    public BeanPropertyAssocMany(BeanDescriptor<?> descriptor, DeployBeanPropertyAssocMany<T> deploy) {
        super(descriptor, deploy);
        this.unidirectional = deploy.isUnidirectional();
        this.orphanRemoval = deploy.isOrphanRemoval();
        this.o2mJoinTable = deploy.isO2mJoinTable();
        this.hasOrderColumn = deploy.hasOrderColumn();
        this.manyToMany = deploy.isManyToMany();
        this.elementCollection = deploy.isElementCollection();
        this.elementDescriptor = deploy.getElementDescriptor();
        this.manyType = deploy.getManyType();
        this.mapKey = deploy.getMapKey();
        this.fetchOrderBy = deploy.getFetchOrderBy();
        this.intersectionJoin = deploy.createIntersectionTableJoin();
        if (this.intersectionJoin != null) {
            this.intersectionPublishTable = this.intersectionJoin.getTable();
            this.intersectionDraftTable = deploy.getIntersectionDraftTable();
        } else {
            this.intersectionPublishTable = null;
            this.intersectionDraftTable = null;
        }
        this.inverseJoin = deploy.createInverseTableJoin();
        this.modifyListenMode = deploy.getModifyListenMode();
        this.jsonHelp = descriptor.isJacksonCorePresent() ? new BeanPropertyAssocManyJsonHelp(this) : null;
    }

    @Override
    public void initialise(BeanDescriptorInitContext initContext) {
        super.initialise(initContext);
        this.initialiseAssocMany();
        if (this.elementCollection) {
            this.elementDescriptor.initialiseOther(initContext);
        }
    }

    @Override
    void initialiseTargetDescriptor(BeanDescriptorInitContext initContext) {
        if (this.elementCollection) {
            this.targetDescriptor = this.elementDescriptor;
        } else {
            super.initialiseTargetDescriptor(initContext);
        }
    }

    private void initialiseAssocMany() {
        if (!this.isTransient) {
            this.help = BeanCollectionHelpFactory.create(this);
            if (this.hasJoinTable() || this.elementCollection) {
                this.importedId = this.createImportedId(this, this.targetDescriptor, this.tableJoin);
            } else {
                this.childMasterProperty = this.initChildMasterProperty();
                if (this.childMasterProperty != null) {
                    this.childMasterProperty.setRelationshipProperty(this);
                }
            }
            if (this.mapKey != null) {
                this.mapKeyProperty = this.initMapKeyProperty();
            }
            this.exportedProperties = this.createExported();
            this.sqlHelp = new BeanPropertyAssocManySqlHelp(this, this.exportedProperties);
            if (this.exportedProperties.length > 0) {
                this.embeddedExportedProperties = this.exportedProperties[0].isEmbedded();
                if (this.fetchOrderBy != null) {
                    this.lazyFetchOrderBy = this.sqlHelp.lazyFetchOrderBy(this.fetchOrderBy);
                }
            }
        }
    }

    String targetTable() {
        return this.beanTable.getBaseTable();
    }

    void initialisePostTarget() {
        BeanProperty masterId;
        if (this.childMasterProperty != null && (masterId = this.childMasterProperty.targetDescriptor().idProperty()) != null) {
            this.childMasterIdProperty = this.childMasterProperty.name() + "." + masterId.name();
        }
    }

    @Override
    public BeanPropertyAssocMany<?> asMany() {
        return this;
    }

    @Override
    public boolean isManyToManyWithHistory() {
        return this.manyToMany && !this.excludedFromHistory && this.descriptor.isHistorySupport();
    }

    @Override
    protected void docStoreIncludeByDefault(PathProperties pathProps) {
    }

    @Override
    public void registerColumn(BeanDescriptor<?> desc, String prefix) {
        if (this.targetDescriptor != null) {
            desc.registerTable(this.targetDescriptor.baseTable(), this);
        }
    }

    public Collection rawCollection(EntityBean bean) {
        return this.help.underlying(this.value(bean));
    }

    @Override
    public void merge(EntityBean bean, EntityBean existing) {
        BeanCollection fromBC;
        Object fromCollection;
        BeanCollection toBC;
        Object existingCollection = this.value(existing);
        if (existingCollection instanceof BeanCollection && !(toBC = (BeanCollection)existingCollection).isPopulated() && (fromCollection = this.value(bean)) instanceof BeanCollection && (fromBC = (BeanCollection)fromCollection).isPopulated()) {
            toBC.loadFrom(fromBC);
        }
    }

    @Override
    public void addBeanToCollectionWithCreate(EntityBean parentBean, EntityBean detailBean, boolean withCheck) {
        Object bc = this.beanCollection(parentBean);
        if (bc == null) {
            bc = this.help.createEmpty(parentBean);
            this.setValue(parentBean, bc);
        }
        this.help.add((BeanCollection<?>)bc, detailBean, withCheck);
    }

    private BeanCollection<?> beanCollection(EntityBean parentBean) {
        try {
            return (BeanCollection)super.getValue(parentBean);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public boolean isSkipSaveBeanCollection(EntityBean bean, boolean insertedParent) {
        Object val = this.getValue(bean);
        if (val == null) {
            return true;
        }
        if (val instanceof BeanCollection) {
            return ((BeanCollection)val).isSkipSave();
        }
        if (insertedParent) {
            if (val instanceof Collection) {
                return ((Collection)val).isEmpty();
            }
            if (val instanceof Map) {
                return ((Map)val).isEmpty();
            }
        }
        return false;
    }

    public void resetMany(EntityBean bean) {
        Object value = this.getValue(bean);
        if (value instanceof BeanCollection) {
            ((BeanCollection)value).reset(bean, this.name);
        } else {
            this.createReference(bean);
        }
    }

    @Override
    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        return this.createElPropertyValue(propName, remainder, chain, propertyDeploy);
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
    }

    public SpiSqlUpdate deleteByParentId(Object parentId, List<Object> parentIdist) {
        if (parentId != null) {
            return this.sqlHelp.deleteByParentId(parentId);
        }
        return this.sqlHelp.deleteByParentIdList(parentIdist);
    }

    public List<Object> findIdsByParentId(Object parentId, List<Object> parentIdList, Transaction t, List<Object> excludeDetailIds, boolean hard) {
        if (parentId != null) {
            return this.sqlHelp.findIdsByParentId(parentId, t, excludeDetailIds, hard);
        }
        return this.sqlHelp.findIdsByParentIdList(parentIdList, t, excludeDetailIds, hard);
    }

    @Override
    public boolean isCacheDataInclude() {
        return false;
    }

    public void lazyLoadMany(EntityBean current) {
        EntityBean parentBean = this.childMasterProperty.getValueAsEntityBean(current);
        if (parentBean != null) {
            this.addBeanToCollectionWithCreate(parentBean, current, true);
        }
    }

    public void addWhereParentIdIn(SpiQuery<?> query, List<Object> parentIds, boolean useDocStore) {
        if (useDocStore) {
            query.where().in(this.childMasterIdProperty, parentIds);
        } else {
            this.sqlHelp.addWhereParentIdIn(query, parentIds);
        }
    }

    public void setEbeanServer(SpiEbeanServer server) {
        if (this.help != null) {
            this.help.setLoader(server);
        }
        if (this.manyToMany) {
            this.intersectionTable = this.initIntersectionTable();
        }
    }

    private IntersectionTable initIntersectionTable() {
        IntersectionBuilder row = new IntersectionBuilder(this.intersectionPublishTable, this.intersectionDraftTable);
        for (ExportedProperty exportedProperty : this.exportedProperties) {
            row.addColumn(exportedProperty.getForeignDbColumn());
        }
        this.importedId.buildImport(row);
        return row.build();
    }

    public IntersectionTable intersectionTable() {
        return this.intersectionTable;
    }

    public BeanCollection.ModifyListenMode modifyListenMode() {
        return this.modifyListenMode;
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
    }

    @Override
    public void load(SqlBeanLoad sqlBeanLoad) {
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) {
        return null;
    }

    @Override
    public Object read(DbReadContext ctx) {
        return null;
    }

    public void add(BeanCollection<?> collection, EntityBean bean) {
        this.help.add(collection, bean, false);
    }

    @Override
    public String assocIsEmpty(SpiExpressionRequest request, String path) {
        boolean softDelete = this.targetDescriptor.isSoftDelete();
        boolean needsX2Table = softDelete || this.extraWhere() != null;
        StringBuilder sb = new StringBuilder(50);
        Query query = request.getQueryRequest().query();
        if (this.hasJoinTable()) {
            sb.append(query.isAsDraft() ? this.intersectionDraftTable : this.intersectionPublishTable);
        } else {
            sb.append(this.targetDescriptor.baseTable(query.getTemporalMode()));
        }
        if (needsX2Table && this.hasJoinTable()) {
            sb.append(" x join ");
            sb.append(this.targetDescriptor.baseTable(query.getTemporalMode()));
            sb.append(" x2 on ");
            this.inverseJoin.addJoin("x2", "x", sb);
        } else {
            sb.append(" x");
        }
        sb.append(" where ");
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            this.exportedProperties[i].appendWhere(sb, "x.", path);
        }
        if (this.extraWhere() != null) {
            sb.append(" and ");
            if (this.hasJoinTable()) {
                sb.append(this.extraWhere().replace("${ta}", "x2").replace("${mta}", "x"));
            } else {
                sb.append(this.extraWhere().replace("${ta}", "x"));
            }
        }
        if (softDelete) {
            String alias = this.hasJoinTable() ? "x2" : "x";
            sb.append(" and ").append(this.targetDescriptor.softDeletePredicate(alias));
        }
        return sb.toString();
    }

    @Override
    public Object[] assocIdValues(EntityBean bean) {
        return this.targetDescriptor.idBinder().getIdValues(bean);
    }

    @Override
    public String assocIdExpression(String prefix, String operator) {
        return this.targetDescriptor.idBinder().getAssocOneIdExpr(prefix, operator);
    }

    @Override
    public String assocIdInValueExpr(boolean not, int size) {
        return this.targetDescriptor.idBinder().getIdInValueExpr(not, size);
    }

    @Override
    public String assocIdInExpr(String prefix) {
        return this.targetDescriptor.idBinder().getAssocIdInExpr(prefix);
    }

    @Override
    public boolean isMany() {
        return true;
    }

    public boolean hasOrderColumn() {
        return this.hasOrderColumn;
    }

    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public boolean isAssocMany() {
        return true;
    }

    @Override
    public boolean isAssocId() {
        return true;
    }

    @Override
    public boolean isAssocProperty() {
        return true;
    }

    @Override
    public boolean containsMany() {
        return true;
    }

    public ManyType manyType() {
        return this.manyType;
    }

    @Override
    public boolean hasJoinTable() {
        return this.manyToMany || this.o2mJoinTable;
    }

    public boolean isO2mJoinTable() {
        return this.o2mJoinTable;
    }

    public boolean isManyToMany() {
        return this.manyToMany;
    }

    public boolean isElementCollection() {
        return this.elementCollection;
    }

    public BeanDescriptor<T> elementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public TableJoin intersectionTableJoin() {
        return this.intersectionJoin;
    }

    public void setJoinValuesToChild(EntityBean parent, EntityBean child, Object mapKeyValue) {
        if (this.mapKeyProperty != null) {
            this.mapKeyProperty.setValue(child, mapKeyValue);
        }
        if (!this.manyToMany && this.childMasterProperty != null) {
            this.childMasterProperty.setValueIntercept(child, parent);
        }
    }

    public String fetchOrderBy() {
        return this.fetchOrderBy;
    }

    public String lazyFetchOrderBy() {
        return this.lazyFetchOrderBy;
    }

    public String mapKey() {
        return this.mapKey;
    }

    @Override
    public void createEmptyReference(EntityBean localBean) {
        this.setValue(localBean, this.help.createEmptyReference());
    }

    @Override
    public BeanCollection<?> createReference(EntityBean localBean, boolean forceNewReference) {
        return forceNewReference ? this.createReference(localBean) : this.createReferenceIfNull(localBean);
    }

    @Override
    public BeanCollection<?> createReferenceIfNull(EntityBean parentBean) {
        Object v = this.getValue(parentBean);
        if (v instanceof BeanCollection) {
            BeanCollection bc = (BeanCollection)v;
            return bc.isReference() ? bc : null;
        }
        if (v != null) {
            return null;
        }
        return this.createReference(parentBean);
    }

    public BeanCollection<?> createReference(EntityBean parentBean) {
        BeanCollection<T> ref = this.help.createReference(parentBean);
        this.setValue(parentBean, ref);
        return ref;
    }

    public BeanCollection<T> createEmpty(EntityBean parentBean) {
        return this.help.createEmpty(parentBean);
    }

    private BeanCollectionAdd beanCollectionAdd(Object bc) {
        return this.help.getBeanCollectionAdd(bc, null);
    }

    public Object parentId(EntityBean parentBean) {
        return this.descriptor.getId(parentBean);
    }

    @Override
    public void addSelectExported(DbSqlContext ctx, String tableAlias) {
        String alias;
        String string = alias = this.hasJoinTable() ? "int_" : tableAlias;
        if (alias == null) {
            alias = "t0";
        }
        for (ExportedProperty exportedProperty : this.exportedProperties) {
            ctx.appendColumn(alias, exportedProperty.getForeignDbColumn());
        }
    }

    private ExportedProperty[] createExported() {
        BeanProperty idProp = this.descriptor.idProperty();
        ArrayList<ExportedProperty> list = new ArrayList<ExportedProperty>();
        if (idProp != null && idProp.isEmbedded()) {
            BeanPropertyAssocOne one = (BeanPropertyAssocOne)idProp;
            try {
                for (BeanProperty emId : one.targetDescriptor().propertiesBaseScalar()) {
                    list.add(this.findMatch(true, emId));
                }
            }
            catch (PersistenceException e) {
                CoreLog.log.error("Could not find a exported property?", (Throwable)e);
            }
        } else if (idProp != null) {
            list.add(this.findMatch(false, idProp));
        }
        return list.toArray(new ExportedProperty[0]);
    }

    private ExportedProperty findMatch(boolean embedded, BeanProperty prop) {
        if (this.hasJoinTable()) {
            return this.findMatch(embedded, prop, prop.dbColumn(), this.intersectionJoin);
        }
        return this.findMatch(embedded, prop, prop.dbColumn(), this.tableJoin);
    }

    private BeanPropertyAssocOne<?> initChildMasterProperty() {
        if (this.unidirectional) {
            return null;
        }
        Class beanType = this.descriptor.type();
        BeanDescriptor targetDesc = this.targetDescriptor();
        for (BeanPropertyAssocOne<?> prop : targetDesc.propertiesOne()) {
            if (!(this.mappedBy != null ? this.mappedBy.equalsIgnoreCase(prop.name()) : prop.targetType().equals(beanType))) continue;
            return prop;
        }
        throw new RuntimeException("Can not find Master [" + beanType + "] in Child[" + targetDesc + "]");
    }

    private BeanProperty initMapKeyProperty() {
        BeanDescriptor targetDesc = this.targetDescriptor();
        for (BeanProperty prop : targetDesc.propertiesAll()) {
            if (!this.mapKey.equalsIgnoreCase(prop.name())) continue;
            return prop;
        }
        String from = this.descriptor.fullName();
        String to = targetDesc.fullName();
        throw new PersistenceException(from + ": Could not find mapKey property [" + this.mapKey + "] on [" + to + "]");
    }

    public IntersectionRow buildManyDeleteChildren(EntityBean parentBean, List<Object> excludeDetailIds) {
        IntersectionRow row = new IntersectionRow(this.tableJoin.getTable(), this.targetDescriptor);
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            row.setExcludeIds(excludeDetailIds, this.targetDescriptor());
        }
        this.buildExport(row, parentBean);
        return row;
    }

    public IntersectionRow buildManyToManyDeleteChildren(EntityBean parentBean, boolean publish) {
        String tableName = publish ? this.intersectionPublishTable : this.intersectionDraftTable;
        IntersectionRow row = new IntersectionRow(tableName);
        this.buildExport(row, parentBean);
        return row;
    }

    public IntersectionRow buildManyToManyMapBean(EntityBean parent, EntityBean other, boolean publish) {
        String tableName = publish ? this.intersectionPublishTable : this.intersectionDraftTable;
        IntersectionRow row = new IntersectionRow(tableName);
        this.buildExport(row, parent);
        this.buildImport(row, other);
        return row;
    }

    void registerDraftIntersectionTable(BeanDescriptorInitContext initContext) {
        if (this.hasDraftIntersection()) {
            initContext.addDraftIntersection(this.intersectionPublishTable, this.intersectionDraftTable);
        }
    }

    private boolean hasDraftIntersection() {
        return this.intersectionDraftTable != null && !this.intersectionDraftTable.equals(this.intersectionPublishTable);
    }

    public void intersectionBind(SqlUpdate sql, EntityBean parentBean, EntityBean other) {
        if (this.embeddedExportedProperties) {
            BeanProperty idProp = this.descriptor.idProperty();
            parentBean = (EntityBean)idProp.getValue(parentBean);
        }
        for (ExportedProperty exportedProperty : this.exportedProperties) {
            sql.setParameter(exportedProperty.getValue(parentBean));
        }
        this.importedId.bindImport(sql, other);
    }

    private void buildExport(IntersectionRow row, EntityBean parentBean) {
        if (this.embeddedExportedProperties) {
            BeanProperty idProp = this.descriptor.idProperty();
            parentBean = (EntityBean)idProp.getValue(parentBean);
        }
        for (ExportedProperty exportedProperty : this.exportedProperties) {
            Object val = exportedProperty.getValue(parentBean);
            String fkColumn = exportedProperty.getForeignDbColumn();
            row.put(fkColumn, val);
        }
    }

    private void buildImport(IntersectionRow row, EntityBean otherBean) {
        this.importedId.buildImport(row, otherBean);
    }

    public boolean hasImportedId(EntityBean otherBean) {
        return null != this.targetDescriptor.getId(otherBean);
    }

    @Override
    public void jsonWriteValue(SpiJsonWriter writeJson, Object value) {
    }

    @Override
    public void jsonWrite(SpiJsonWriter ctx, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Boolean include = ctx.includeMany(this.name);
        if (Boolean.FALSE.equals(include)) {
            return;
        }
        Object value = this.getValueIntercept(bean);
        if (value != null) {
            ctx.pushParentBeanMany(bean);
            if (this.help != null) {
                this.jsonWriteCollection(ctx, this.name, value, include != null);
            } else if (this.isTransient && this.targetDescriptor == null) {
                ctx.writeValueUsingObjectMapper(this.name, value);
            } else {
                Collection collection = (Collection)value;
                if (!collection.isEmpty() || ctx.isIncludeEmpty()) {
                    ctx.toJson(this.name, collection);
                }
            }
            ctx.popParentBeanMany();
        }
    }

    @Override
    public void jsonRead(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        this.jsonHelp.jsonRead(readJson, parentBean);
    }

    void publishMany(EntityBean draft, EntityBean live) {
        BeanCollection draftVal = (BeanCollection)this.getValueIntercept(draft);
        BeanCollection liveVal = (BeanCollection)this.getValueIntercept(live);
        Map<Object, T> liveBeansAsMap = this.liveBeansAsMap(liveVal);
        draftVal.size();
        Collection actualDetails = draftVal.getActualDetails();
        for (Object bean : actualDetails) {
            Object id = this.targetDescriptor.id(bean);
            T liveBean = liveBeansAsMap.remove(id);
            if (this.isManyToMany()) {
                if (liveBean != null) continue;
                liveVal.addBean(this.targetDescriptor.createReference(id, null));
                continue;
            }
            Object newLive = this.targetDescriptor.publish(bean, liveBean);
            if (liveBean != null) continue;
            liveVal.addBean(newLive);
        }
        Collection<T> values = liveBeansAsMap.values();
        for (T value : values) {
            liveVal.removeBean(value);
        }
    }

    private Map<Object, T> liveBeansAsMap(BeanCollection<?> liveVal) {
        liveVal.size();
        Collection liveBeans = liveVal.getActualDetails();
        LinkedHashMap liveMap = new LinkedHashMap();
        for (Object liveBean : liveBeans) {
            Object id = this.targetDescriptor.id(liveBean);
            liveMap.put(id, liveBean);
        }
        return liveMap;
    }

    public boolean isIncludeCascadeSave() {
        return this.cascadeInfo.isSave() || this.hasJoinTable() || BeanCollection.ModifyListenMode.REMOVALS == this.modifyListenMode;
    }

    public boolean isIncludeCascadeDelete() {
        return this.cascadeInfo.isDelete() || this.hasJoinTable() || BeanCollection.ModifyListenMode.REMOVALS == this.modifyListenMode;
    }

    boolean isCascadeDeleteEscalate() {
        return !this.elementCollection && this.cascadeInfo.isDelete();
    }

    public SpiSqlUpdate insertElementCollection() {
        return this.sqlHelp.insertElementCollection();
    }

    public boolean isTargetDocStoreMapped() {
        return this.targetDescriptor.isDocStoreMapped();
    }

    void jsonWriteMapEntry(SpiJsonWriter ctx, Map.Entry<?, ?> entry) throws IOException {
        if (this.elementDescriptor != null) {
            this.elementDescriptor.jsonWriteMapEntry(ctx, entry);
        } else {
            this.targetDescriptor.jsonWrite(ctx, (EntityBean)entry.getValue());
        }
    }

    void jsonWriteElementValue(SpiJsonWriter ctx, Object element) {
        this.elementDescriptor.jsonWriteElement(ctx, element);
    }

    public boolean isUseCache() {
        return this.targetDescriptor.isBeanCaching();
    }

    @Override
    public void setCacheDataValue(EntityBean bean, Object cacheData, PersistenceContext context) {
        try {
            String asJson = (String)cacheData;
            if (asJson != null && !asJson.isEmpty()) {
                Object collection = this.jsonReadCollection(asJson);
                this.setValue(bean, collection);
            }
        }
        catch (Exception e) {
            CoreLog.log.error("Error setting value from L2 cache", (Throwable)e);
        }
    }

    @Override
    public Object getCacheDataValue(EntityBean bean) {
        try {
            Object collection = this.getValue(bean);
            if (collection == null) {
                return null;
            }
            return this.jsonWriteCollection(collection);
        }
        catch (Exception e) {
            CoreLog.log.error("Error building value element collection json for L2 cache", (Throwable)e);
            return null;
        }
    }

    public String jsonWriteCollection(Object value) throws IOException {
        StringWriter writer = new StringWriter(300);
        SpiJsonWriter ctx = this.descriptor.createJsonWriter(writer);
        this.help.jsonWrite(ctx, null, value, true);
        ctx.flush();
        return writer.toString();
    }

    private Object jsonReadCollection(String json) throws IOException {
        SpiJsonReader ctx = this.descriptor.createJsonReader(json);
        JsonParser parser = ctx.getParser();
        JsonToken event = parser.nextToken();
        if (JsonToken.VALUE_NULL == event) {
            return null;
        }
        return this.jsonReadCollection(ctx, null);
    }

    private void jsonWriteCollection(SpiJsonWriter ctx, String name, Object value, boolean explicitInclude) throws IOException {
        this.help.jsonWrite(ctx, name, value, explicitInclude);
    }

    public Object jsonReadCollection(SpiJsonReader readJson, EntityBean parentBean) throws IOException {
        EntityBean detailBean;
        if (this.elementDescriptor != null && this.elementDescriptor.isJsonReadCollection()) {
            return this.elementDescriptor.jsonReadCollection(readJson, parentBean);
        }
        BeanCollection<T> collection = this.createEmpty(parentBean);
        BeanCollectionAdd add = this.beanCollectionAdd(collection);
        while ((detailBean = (EntityBean)this.targetDescriptor.jsonRead(readJson, this.name, null)) != null) {
            add.addEntityBean(detailBean);
            if (parentBean == null || this.childMasterProperty == null) continue;
            this.childMasterProperty.setValue(detailBean, parentBean);
        }
        return collection;
    }

    public void bindElementValue(SqlUpdate insert, Object value) {
        this.targetDescriptor.bindElementValue(insert, value);
    }

    public boolean createJoinTable() {
        if (this.hasJoinTable() && this.mappedBy() == null) {
            return !this.descriptor.isTableManaged(this.intersectionJoin.getTable());
        }
        return false;
    }
}

