/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanPostConstructListener;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;

final class PostConstructManager {
    private final List<BeanPostConstructListener> list;

    PostConstructManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanPostConstructoListeners();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addPostConstructListeners(DeployBeanDescriptor<?> deployDesc) {
        for (BeanPostConstructListener c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            CoreLog.log.debug("BeanPostLoad on[{}] {}", (Object)deployDesc.getFullName(), (Object)c.getClass().getName());
            deployDesc.addPostConstructListener(c);
        }
    }
}

