/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestUpdateSql;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.PstmtFactory;
import io.ebeaninternal.server.util.BindParamsParser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.PersistenceException;

final class ExeUpdateSql {
    private final Binder binder;
    private final PstmtFactory pstmtFactory;

    ExeUpdateSql(Binder binder) {
        this.binder = binder;
        this.pstmtFactory = new PstmtFactory();
    }

    public int execute(PersistRequestUpdateSql request) {
        boolean batchThisRequest = request.isBatchThisRequest();
        PreparedStatement pstmt = null;
        try {
            pstmt = this.bindStmt(request, batchThisRequest);
            if (batchThisRequest) {
                pstmt.addBatch();
                int n = -1;
                return n;
            }
            int rowCount = pstmt.executeUpdate();
            request.checkRowCount(rowCount);
            if (request.isGetGeneratedKeys()) {
                this.readGeneratedKeys(pstmt, request);
            }
            request.postExecute();
            int n = rowCount;
            return n;
        }
        catch (SQLException e) {
            throw request.translateSqlException(e);
        }
        finally {
            if (!batchThisRequest) {
                JdbcClose.close((Statement)pstmt);
            }
        }
    }

    private void readGeneratedKeys(PreparedStatement stmt, PersistRequestUpdateSql request) {
        ResultSet resultSet = null;
        try {
            resultSet = stmt.getGeneratedKeys();
            if (resultSet.next()) {
                request.setGeneratedKey(resultSet.getObject(1));
            }
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            JdbcClose.close((ResultSet)resultSet);
        }
    }

    private PreparedStatement bindStmt(PersistRequestUpdateSql request, boolean batchThisRequest) throws SQLException {
        request.startBind(batchThisRequest);
        SpiSqlUpdate updateSql = request.updateSql();
        SpiTransaction t = request.transaction();
        BindParams bindParams = updateSql.getBindParams();
        String sql = updateSql.getBaseSql();
        sql = BindParamsParser.parse(bindParams, sql);
        this.parseUpdate(sql, request);
        PreparedStatement pstmt = batchThisRequest ? this.pstmtFactory.pstmtBatch(t, sql, request) : this.pstmtFactory.pstmt(t, sql, request.isGetGeneratedKeys());
        if (updateSql.getTimeout() > 0) {
            pstmt.setQueryTimeout(updateSql.getTimeout());
        }
        String bindLog = null;
        if (!bindParams.isEmpty()) {
            bindLog = this.binder.bind(bindParams, pstmt, t.getInternalConnection());
        }
        request.setBindLog(bindLog);
        updateSql.setGeneratedSql(sql);
        if (batchThisRequest) {
            request.logSqlBatchBind();
        }
        return pstmt;
    }

    private void determineType(String word1, String word2, String word3, PersistRequestUpdateSql request) {
        if (word1.equalsIgnoreCase("UPDATE")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_UPDATE, word2);
        } else if (word1.equalsIgnoreCase("DELETE")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_DELETE, word3);
        } else if (word1.equalsIgnoreCase("INSERT")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_INSERT, word3);
        } else {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_UNKNOWN, null);
        }
    }

    private void parseUpdate(String sql, PersistRequestUpdateSql request) {
        int[] pos = new int[3];
        int spaceCount = 0;
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            pos[spaceCount] = i;
            if (++spaceCount > 2) break;
        }
        if (spaceCount < 2) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_UNKNOWN, null);
        } else {
            String firstWord = sql.substring(0, pos[0]);
            String secWord = sql.substring(pos[0] + 1, pos[1]);
            String thirdWord = pos[2] == 0 ? sql.substring(pos[1] + 1) : sql.substring(pos[1] + 1, pos[2]);
            this.determineType(firstWord, secWord, thirdWord, request);
        }
    }
}

