/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.api.SpiUpdatePlan;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.dml.BaseMeta;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dml.GenerateDmlRequest;
import io.ebeaninternal.server.persist.dml.UpdatePlan;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableList;
import java.sql.SQLException;
import java.util.ArrayList;

final class UpdateMeta
extends BaseMeta {
    private final BindableList set;

    UpdateMeta(BindableList set, BindableId id, Bindable version, Bindable tenantId) {
        super(id, version, tenantId);
        this.set = set;
    }

    public void bind(PersistRequestBean<?> persist, DmlHandler bind, SpiUpdatePlan updatePlan) throws SQLException {
        EntityBean bean = persist.entityBean();
        updatePlan.bindSet(bind, bean);
        this.id.dmlBind(bind, bean);
        if (this.tenantId != null) {
            this.tenantId.dmlBind(bind, bean);
        }
        if (persist.concurrencyMode() == ConcurrencyMode.VERSION) {
            this.version.dmlBind(bind, bean);
        }
    }

    SpiUpdatePlan getUpdatePlan(PersistRequestBean<?> request) {
        return this.getDynamicUpdatePlan(request);
    }

    private SpiUpdatePlan getDynamicUpdatePlan(PersistRequestBean<?> persistRequest) {
        String key = persistRequest.updatePlanHash();
        BeanDescriptor<?> beanDescriptor = persistRequest.descriptor();
        SpiUpdatePlan updatePlan = beanDescriptor.updatePlan(key);
        if (updatePlan != null) {
            return updatePlan;
        }
        ArrayList<Bindable> list = new ArrayList<Bindable>();
        this.set.addToUpdate(persistRequest, list);
        BindableList bindableList = new BindableList(list);
        ConcurrencyMode mode = persistRequest.concurrencyMode();
        String sql = this.genSql(mode, bindableList, persistRequest.updateTable());
        updatePlan = new UpdatePlan(key, mode, sql, bindableList);
        beanDescriptor.updatePlan(key, updatePlan);
        return updatePlan;
    }

    private String genSql(ConcurrencyMode conMode, BindableList bindableList, String tableName) {
        GenerateDmlRequest request = new GenerateDmlRequest();
        request.append("update ").append(tableName).append(" set ");
        request.setUpdateSetMode();
        bindableList.dmlAppend(request);
        if (request.getBindColumnCount() == 0) {
            return null;
        }
        request.append(" where ");
        return this.appendWhere(request, conMode);
    }
}

