/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CancelableQuery;
import io.ebean.CountedValue;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarDataReader;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.type.RsetDataReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

final class CQueryFetchSingleAttribute
implements SpiProfileTransactionEvent,
CancelableQuery {
    private final CQueryPlan queryPlan;
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private RsetDataReader dataReader;
    private PreparedStatement pstmt;
    private String bindLog;
    private long executionTimeMicros;
    private int rowCount;
    private final ScalarDataReader<?> reader;
    private final boolean containsCounts;
    private long profileOffset;
    private final ReentrantLock lock = new ReentrantLock();

    CQueryFetchSingleAttribute(OrmQueryRequest<?> request, CQueryPredicates predicates, CQueryPlan queryPlan, boolean containsCounts) {
        this.request = request;
        this.queryPlan = queryPlan;
        this.query = request.query();
        this.sql = queryPlan.getSql();
        this.desc = request.descriptor();
        this.predicates = predicates;
        this.containsCounts = containsCounts;
        this.reader = queryPlan.getSingleAttributeScalarType();
        this.query.setGeneratedSql(this.sql);
    }

    String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindAttr exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.name()).append("] predicates[").append(this.predicates.getLogWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    long micros() {
        return this.executionTimeMicros;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findCollection(Collection result) throws SQLException {
        long startNano = System.nanoTime();
        try {
            this.prepareExecute();
            while (this.dataReader.next()) {
                Object value = this.reader.read((DataReader)this.dataReader);
                if (this.containsCounts) {
                    value = new CountedValue(value, this.dataReader.getLong().longValue());
                }
                result.add(value);
                ++this.rowCount;
            }
            this.executionTimeMicros = (System.nanoTime() - startNano) / 1000L;
            this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            this.getTransaction().profileEvent(this);
        }
        finally {
            this.close();
        }
    }

    private SpiTransaction getTransaction() {
        return this.request.transaction();
    }

    String getBindLog() {
        return this.bindLog;
    }

    String getGeneratedSql() {
        return this.sql;
    }

    private void prepareExecute() throws SQLException {
        this.lock.lock();
        try {
            this.query.checkCancelled();
            SpiTransaction t = this.getTransaction();
            this.profileOffset = t.profileOffset();
            Connection conn = t.getInternalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.getBufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
            }
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            this.bindLog = this.predicates.bind(this.pstmt, conn);
        }
        finally {
            this.lock.unlock();
        }
        this.dataReader = new RsetDataReader(this.request.dataTimeZone(), this.pstmt.executeQuery());
        this.query.checkCancelled();
    }

    private void close() {
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            CoreLog.log.error("Error closing DataReader", (Throwable)e);
        }
        JdbcClose.close((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public void profile() {
        this.getTransaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.name(), this.rowCount, this.query.getProfileId());
    }

    Set<String> getDependentTables() {
        return this.queryPlan.getDependentTables();
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }
}

