/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.type.DataBind;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class OrmUpdateProperties {
    private static final NullValue NULL_VALUE = new NullValue();
    private static final NoneValue NONE_VALUE = new NoneValue();
    private final LinkedHashMap<String, Value> values = new LinkedHashMap();

    public void set(String propertyName, Object value, ScalarType<Object> scalarType) {
        this.values.put(propertyName, new SimpleValue(value, scalarType));
    }

    public void setNull(String propertyName) {
        this.values.put(propertyName, NULL_VALUE);
    }

    public void setRaw(String propertyName) {
        this.values.put(propertyName, NONE_VALUE);
    }

    void setRaw(String propertyExpression, Object ... vals) {
        if (vals.length == 0) {
            this.setRaw(propertyExpression);
        } else {
            this.values.put(propertyExpression, new RawArrayValue(vals));
        }
    }

    void buildQueryPlanHash(StringBuilder builder) {
        Set<Map.Entry<String, Value>> entries = this.values.entrySet();
        for (Map.Entry<String, Value> entry : entries) {
            builder.append("key:").append(entry.getKey());
            builder.append(" ?:").append(entry.getValue().getBindCount());
        }
    }

    public void bind(Binder binder, DataBind dataBind) throws SQLException {
        for (Value bindValue : this.values.values()) {
            bindValue.bind(binder, dataBind);
        }
    }

    public String buildSetClause(DeployParser deployParser) {
        int setCount = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.values.entrySet()) {
            String property = entry.getKey();
            if (setCount++ > 0) {
                sb.append(", ");
            }
            sb.append(OrmUpdateProperties.trim(deployParser.parse(property)));
            sb.append(entry.getValue().bindClause());
        }
        return sb.toString();
    }

    static String trim(String dbColumn) {
        return dbColumn.replace("${}", "");
    }

    private static final class SimpleValue
    extends Value {
        final Object value;
        final ScalarType<Object> scalarType;

        SimpleValue(Object value, ScalarType<Object> scalarType) {
            this.value = value;
            this.scalarType = scalarType;
        }

        @Override
        public int getBindCount() {
            return 1;
        }

        @Override
        public String bindClause() {
            return "=?";
        }

        @Override
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
            if (this.scalarType != null) {
                this.scalarType.bind((DataBinder)dataBind, this.value);
            } else {
                binder.bindObject(dataBind, this.value);
            }
            dataBind.append(this.value).append(",");
        }
    }

    private static final class NullValue
    extends Value {
        private NullValue() {
        }

        @Override
        public String bindClause() {
            return "=null";
        }
    }

    private static final class NoneValue
    extends Value {
        private NoneValue() {
        }

        @Override
        public String bindClause() {
            return "";
        }
    }

    private static final class RawArrayValue
    extends Value {
        final Object[] bindValues;

        RawArrayValue(Object[] bindValues) {
            this.bindValues = bindValues;
        }

        @Override
        public int getBindCount() {
            return this.bindValues.length;
        }

        @Override
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
            for (Object val : this.bindValues) {
                binder.bindObject(dataBind, val);
                dataBind.append(val).append(",");
            }
        }
    }

    public static abstract class Value {
        public void bind(Binder binder, DataBind dataBind) throws SQLException {
        }

        public String bindClause() {
            return "";
        }

        public int getBindCount() {
            return 0;
        }
    }
}

