/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.text.json;

import com.fasterxml.jackson.core.JsonGenerator;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.TypeManager;
import java.io.IOException;
import java.util.List;

public final class DJsonScalar {
    private final TypeManager typeManager;

    public DJsonScalar(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void write(JsonGenerator gen, Object value) throws IOException {
        if (value instanceof String) {
            gen.writeString((String)value);
        } else if (value instanceof List) {
            List list = (List)value;
            gen.writeRaw('[');
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    gen.writeRaw(',');
                }
                this.write(gen, list.get(i));
            }
            gen.writeRaw(']');
        } else {
            ScalarType<?> scalarType = this.typeManager.getScalarType(value.getClass());
            if (scalarType == null) {
                throw new IllegalArgumentException("unhandled type " + value.getClass());
            }
            scalarType.jsonWrite(gen, value);
        }
    }
}

