/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ParamTypeHelper {
    public static TypeInfo getTypeInfo(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            return ParamTypeHelper.getParamTypeInfo((ParameterizedType)genericType);
        }
        Class<?> entityType = ParamTypeHelper.getBeanType(genericType);
        if (entityType != null) {
            return new TypeInfo(ManyType.NONE, entityType);
        }
        return null;
    }

    private static TypeInfo getParamTypeInfo(ParameterizedType paramType) {
        Type argType;
        Class<?> beanType;
        Type rawType = paramType.getRawType();
        ManyType manyType = ParamTypeHelper.getManyType(rawType);
        if (ManyType.NONE == manyType) {
            return null;
        }
        Type[] typeArguments = paramType.getActualTypeArguments();
        if (typeArguments.length == 1 && (beanType = ParamTypeHelper.getBeanType(argType = typeArguments[0])) != null) {
            return new TypeInfo(manyType, beanType);
        }
        return null;
    }

    private static Class<?> getBeanType(Type argType) {
        if (argType instanceof Class) {
            return (Class)argType;
        }
        return null;
    }

    private static ManyType getManyType(Type rawType) {
        if (List.class.equals((Object)rawType)) {
            return ManyType.LIST;
        }
        if (Set.class.equals((Object)rawType)) {
            return ManyType.SET;
        }
        if (Map.class.equals((Object)rawType)) {
            return ManyType.MAP;
        }
        return ManyType.NONE;
    }

    public static final class TypeInfo {
        private final ManyType manyType;
        private final Class<?> beanType;

        private TypeInfo(ManyType manyType, Class<?> beanType) {
            this.manyType = manyType;
            this.beanType = beanType;
        }

        public boolean isManyType() {
            return ManyType.NONE != this.manyType;
        }

        public ManyType getManyType() {
            return this.manyType;
        }

        public Class<?> getBeanType() {
            return this.beanType;
        }

        public String toString() {
            if (this.isManyType()) {
                return this.manyType + " " + this.beanType;
            }
            return this.beanType.toString();
        }
    }

    public static enum ManyType {
        LIST,
        SET,
        MAP,
        NONE;

    }
}

