/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.ExtendedPreparedStatement;
import io.ebean.datasource.pool.Log;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

final class PstmtCache
extends LinkedHashMap<String, ExtendedPreparedStatement> {
    static final long serialVersionUID = -3096406924865550697L;
    private final int maxSize;
    private long removeCount;
    private long hitCount;
    private long missCount;
    private long putCount;

    PstmtCache(int maxCacheSize) {
        super(maxCacheSize * 3, 0.75f, true);
        this.maxSize = maxCacheSize;
    }

    String description() {
        return "size[" + this.size() + "] max[" + this.maxSize + "] hits[" + this.hitCount + "] miss[" + this.missCount + "] hitRatio[" + this.hitRatio() + "] removes[" + this.removeCount + "]";
    }

    public int maxSize() {
        return this.maxSize;
    }

    private long hitRatio() {
        if (this.hitCount == 0L) {
            return 0L;
        }
        return this.hitCount * 100L / (this.hitCount + this.missCount);
    }

    long hitCount() {
        return this.hitCount;
    }

    long missCount() {
        return this.missCount;
    }

    long removeCount() {
        return this.removeCount;
    }

    long putCount() {
        return this.putCount;
    }

    boolean returnStatement(ExtendedPreparedStatement stmt) {
        ExtendedPreparedStatement alreadyInCache = (ExtendedPreparedStatement)super.get(stmt.getCacheKey());
        if (alreadyInCache != null) {
            return false;
        }
        this.put(stmt.getCacheKey(), stmt);
        return true;
    }

    @Override
    public ExtendedPreparedStatement get(Object key) {
        ExtendedPreparedStatement o = (ExtendedPreparedStatement)super.get(key);
        if (o == null) {
            ++this.missCount;
        } else {
            ++this.hitCount;
        }
        return o;
    }

    @Override
    public ExtendedPreparedStatement remove(Object key) {
        ExtendedPreparedStatement o = (ExtendedPreparedStatement)super.remove(key);
        if (o == null) {
            ++this.missCount;
        } else {
            ++this.hitCount;
        }
        return o;
    }

    @Override
    public ExtendedPreparedStatement put(String key, ExtendedPreparedStatement value) {
        ++this.putCount;
        return super.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, ExtendedPreparedStatement> eldest) {
        if (this.size() < this.maxSize) {
            return false;
        }
        ++this.removeCount;
        try {
            ExtendedPreparedStatement stmt = eldest.getValue();
            stmt.closeDestroy();
        }
        catch (SQLException e) {
            Log.error("Error closing ExtendedPreparedStatement", e);
        }
        return true;
    }
}

