/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BaseJdbcContainer;
import io.ebean.test.containers.CommandException;
import io.ebean.test.containers.process.ProcessHandler;
import io.ebean.test.containers.process.ProcessResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Db2Container
extends BaseJdbcContainer<Db2Container> {
    private final String createOptions;
    private final String configOptions;

    @Override
    public Db2Container start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return Db2Container.builder(version);
    }

    private Db2Container(Builder builder) {
        super(builder);
        this.createOptions = builder.createOptions;
        this.configOptions = builder.configOptions;
        this.waitForConnectivityAttempts = 2000;
    }

    @Override
    void createDatabase() {
        if (this.checkConnectivity(false)) {
            return;
        }
        try {
            this.dockerSu("root", "useradd -g db2iadm1 " + this.dbConfig.getUsername());
        }
        catch (CommandException e) {
            log.log(System.Logger.Level.WARNING, "Failed to useradd" + String.valueOf(e));
        }
        this.dockerSu("root", "echo \"" + this.dbConfig.getUsername() + ":" + this.dbConfig.getPassword() + "\" | chpasswd");
        String cmd = "db2 create database " + this.dbConfig.getDbName();
        if (this.defined(this.createOptions)) {
            cmd = cmd + " " + this.createOptions;
        }
        this.dockerSu(cmd);
        if (this.defined(this.configOptions)) {
            cmd = "db2 update database config for " + this.dbConfig.getDbName() + " " + this.configOptions;
            this.dockerSu(this.dbConfig.getAdminUsername(), cmd);
        }
        cmd = "db2 activate database " + this.dbConfig.getDbName();
        this.dockerSu(cmd);
        cmd = "/var/db2_setup/lib/set_rec_values.sh " + this.dbConfig.getDbName();
        this.dockerSu(cmd);
    }

    @Override
    void dropCreateDatabase() {
        try {
            this.dockerSu("db2 drop database " + this.dbConfig.getDbName());
        }
        catch (CommandException e) {
            log.log(System.Logger.Level.WARNING, "Failed to drop database {0}", (Throwable)e);
        }
        this.createDatabase();
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("--privileged");
        args.add("-e");
        args.add("LICENSE=accept");
        args.add("-e");
        args.add("SAMPLEDB=false");
        args.add("-e");
        args.add("ARCHIVE_LOGS=false");
        args.add("-e");
        args.add("AUTOCONFIG=false");
        args.add("-e");
        args.add("DB2INSTANCE=" + this.dbConfig.getAdminUsername());
        if (this.defined(this.dbConfig.getAdminPassword())) {
            args.add("-e");
            args.add("DB2INST1_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add("-e");
        args.add("DBNAME=");
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    protected List<String> dockerSu(String user, String cmd) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("su");
        args.add("-");
        args.add(user);
        args.add("-c");
        args.add(cmd);
        ProcessBuilder pb = this.createProcessBuilder(args);
        ProcessResult pr = ProcessHandler.process(pb);
        return pr.getOutLines();
    }

    protected List<String> dockerSu(String cmd) {
        return this.dockerSu(this.dbConfig.getAdminUsername(), cmd);
    }

    @Override
    boolean checkConnectivity() {
        try {
            List<String> result = this.dockerSu("db2pd -");
            for (String outLine : result) {
                if (!outLine.contains("-- Active --")) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static class Builder
    extends BaseDbBuilder<Db2Container, Builder> {
        private String createOptions;
        private String configOptions;

        private Builder(String version) {
            super("db2", 50000, 50000, version);
            this.image = "ibmcom/db2:" + version;
            this.tmpfs = "/database:rw";
        }

        @Override
        protected void extraProperties(Properties properties) {
            this.createOptions = this.prop(properties, "createOptions", this.createOptions);
            this.configOptions = this.prop(properties, "configOptions", this.configOptions);
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:db2://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        public Builder createOptions(String createOptions) {
            this.createOptions = createOptions;
            return (Builder)this.self();
        }

        public Builder configOptions(String configOptions) {
            this.configOptions = configOptions;
            return (Builder)this.self();
        }

        @Override
        public Db2Container build() {
            return new Db2Container(this);
        }

        @Override
        public Db2Container start() {
            return this.build().start();
        }
    }
}

