/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers.process;

import io.ebean.test.containers.CommandException;
import io.ebean.test.containers.process.ProcessResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ProcessHandler {
    private final ProcessBuilder builder;
    private Process process;
    private List<String> out = new ArrayList<String>();
    private String match;
    private String clearMatch;

    private ProcessHandler(ProcessBuilder builder, String match, String clearMatch) {
        this.builder = builder;
        this.match = match;
        this.clearMatch = clearMatch;
    }

    public static ProcessResult matchCommand(String match, String clearMatch, String ... command) {
        return ProcessHandler.process(new ProcessBuilder(command), match, clearMatch);
    }

    public static ProcessResult command(String ... command) {
        return ProcessHandler.process(new ProcessBuilder(command));
    }

    public static ProcessResult command(List<String> commands) {
        return ProcessHandler.process(new ProcessBuilder(commands));
    }

    public static ProcessResult process(ProcessBuilder pb) {
        return ProcessHandler.process(pb, null, null);
    }

    private static ProcessResult process(ProcessBuilder pb, String match, String clearMatch) {
        try {
            ProcessHandler handler = new ProcessHandler(pb, match, clearMatch);
            handler.start();
            ProcessResult result = handler.read();
            if (!result.success()) {
                throw new CommandException("command failed: " + String.valueOf(result.getOutLines()), result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void start() throws IOException {
        this.builder.redirectErrorStream(true);
        this.process = this.builder.start();
    }

    private ProcessResult read() {
        try {
            String s;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((s = stdInput.readLine()) != null) {
                this.processLine(s, this.out);
            }
            int result = this.process.waitFor();
            return new ProcessResult(result, this.out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processLine(String lineContent, List<String> lines) {
        if (this.clearMatch != null && lineContent.contains(this.clearMatch)) {
            this.out.clear();
        } else if (this.match != null) {
            if (lineContent.contains(this.match)) {
                this.out.add(lineContent);
            }
        } else {
            lines.add(lineContent);
        }
    }
}

