/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config.provider;

import io.avaje.applog.AppLog;
import io.ebean.DatabaseBuilder;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.CurrentUserProvider;
import io.ebean.config.EncryptKeyManager;
import io.ebean.test.config.provider.FixedEncryptKeyManager;
import io.ebean.test.config.provider.WhoTenantProvider;
import io.ebean.test.config.provider.WhoUserProvider;
import java.util.Properties;

public class ProviderAutoConfig {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.test");
    private final DatabaseBuilder.Settings config;
    private final Properties properties;

    public ProviderAutoConfig(DatabaseBuilder.Settings config) {
        this.config = config;
        this.properties = config.getProperties();
    }

    public void run() {
        EncryptKeyManager keyManager;
        CurrentTenantProvider tenantProvider;
        int providerSetFlag = 0;
        CurrentUserProvider provider = this.config.getCurrentUserProvider();
        if (provider == null) {
            providerSetFlag = 1;
            this.config.setCurrentUserProvider((CurrentUserProvider)new WhoUserProvider());
        }
        if ((tenantProvider = this.config.getCurrentTenantProvider()) == null && Boolean.parseBoolean(this.properties.getProperty("ebean.test.registerTestTenantProvider", "false"))) {
            providerSetFlag += 2;
            this.config.setCurrentTenantProvider((CurrentTenantProvider)new WhoTenantProvider());
        }
        if ((keyManager = this.config.getEncryptKeyManager()) == null) {
            String keyVal = this.properties.getProperty("ebean.test.encryptKey", "simple0123456789");
            log.log(System.Logger.Level.DEBUG, "for testing purposes using FixedEncryptKeyManager() keyVal:{0}", keyVal);
            this.config.setEncryptKeyManager((EncryptKeyManager)new FixedEncryptKeyManager(keyVal));
        }
        if (providerSetFlag > 0) {
            log.log(System.Logger.Level.INFO, this.msg(providerSetFlag));
        }
    }

    String msg(int providerSetFlag) {
        String msg = this.msgProvider(providerSetFlag);
        String usage = this.msgUsage(providerSetFlag);
        return "for testing purposes " + msg + " has been configured. Use io.ebean.test.UserContext to " + usage + " in tests.";
    }

    private String msgProvider(int providerSetFlag) {
        switch (providerSetFlag) {
            case 1: {
                return "a current user provider";
            }
            case 2: {
                return "a current tenant provider";
            }
            case 3: {
                return "a current user and tenant provider";
            }
        }
        return "[unexpected??]";
    }

    private String msgUsage(int providerSetFlag) {
        switch (providerSetFlag) {
            case 1: {
                return "set current user";
            }
            case 2: {
                return "set current tenant";
            }
            case 3: {
                return "set current user and tenant";
            }
        }
        return "[unexpected??]";
    }
}

