/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.net.auth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class OAuthUtils {
    public static String decodeCharacters(byte[] from, String characterEncoding) throws UnsupportedEncodingException {
        return new String(from, characterEncoding);
    }

    public static byte[] encodeCharacters(String from, String characterEncoding) throws UnsupportedEncodingException {
        return from.getBytes(characterEncoding);
    }

    public static String formEncode(Iterable<? extends Map.Entry> parameters, String characterEncoding) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OAuthUtils.formEncode(parameters, b, characterEncoding);
        return OAuthUtils.decodeCharacters(b.toByteArray(), characterEncoding);
    }

    public static void formEncode(Iterable<? extends Map.Entry> parameters, OutputStream into, String characterEncoding) throws IOException {
        if (parameters == null) {
            return;
        }
        boolean first = true;
        for (Map.Entry entry : parameters) {
            if (first) {
                first = false;
            } else {
                into.write(38);
            }
            into.write(OAuthUtils.encodeCharacters(OAuthUtils.percentEncode(OAuthUtils.toString(entry.getKey()), characterEncoding), characterEncoding));
            into.write(61);
            into.write(OAuthUtils.encodeCharacters(OAuthUtils.percentEncode(OAuthUtils.toString(entry.getValue()), characterEncoding), characterEncoding));
        }
    }

    public static String percentEncode(String s, String characterEncoding) {
        try {
            return s == null ? "" : URLEncoder.encode(s, characterEncoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static String toString(Object from) {
        return from == null ? null : from.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

