/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.com.jcraft.jsch;

import com.crashlytics.dependency.reloc.com.jcraft.jsch.Buffer;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.DH;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.HASH;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.JSch;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.KeyExchange;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.Packet;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.Session;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.SignatureDSA;
import com.crashlytics.dependency.reloc.com.jcraft.jsch.SignatureRSA;

public class DHGEX
extends KeyExchange {
    private static final int SSH_MSG_KEX_DH_GEX_GROUP = 31;
    private static final int SSH_MSG_KEX_DH_GEX_INIT = 32;
    private static final int SSH_MSG_KEX_DH_GEX_REPLY = 33;
    private static final int SSH_MSG_KEX_DH_GEX_REQUEST = 34;
    static int min = 1024;
    static int preferred = 1024;
    static int max = 1024;
    static final int RSA = 0;
    static final int DSS = 1;
    private int type = 0;
    private int state;
    DH dh;
    byte[] V_S;
    byte[] V_C;
    byte[] I_S;
    byte[] I_C;
    private Buffer buf;
    private Packet packet;
    private byte[] p;
    private byte[] g;
    private byte[] e;

    public void init(Session session, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws Exception {
        Class<?> clazz;
        this.session = session;
        this.V_S = byArray;
        this.V_C = byArray2;
        this.I_S = byArray3;
        this.I_C = byArray4;
        try {
            clazz = Class.forName(session.getConfig("sha-1"));
            this.sha = (HASH)clazz.newInstance();
            this.sha.init();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        this.buf = new Buffer();
        this.packet = new Packet(this.buf);
        clazz = Class.forName(session.getConfig("dh"));
        this.dh = (DH)clazz.newInstance();
        this.dh.init();
        this.packet.reset();
        this.buf.putByte((byte)34);
        this.buf.putInt(min);
        this.buf.putInt(preferred);
        this.buf.putInt(max);
        session.write(this.packet);
        if (JSch.getLogger().isEnabled(1)) {
            JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_REQUEST(" + min + "<" + preferred + "<" + max + ") sent");
            JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_GROUP");
        }
        this.state = 31;
    }

    public boolean next(Buffer buffer) throws Exception {
        switch (this.state) {
            case 31: {
                buffer.getInt();
                buffer.getByte();
                int n = buffer.getByte();
                if (n != 31) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_GROUP " + n);
                    return false;
                }
                this.p = buffer.getMPInt();
                this.g = buffer.getMPInt();
                this.dh.setP(this.p);
                this.dh.setG(this.g);
                this.e = this.dh.getE();
                this.packet.reset();
                this.buf.putByte((byte)32);
                this.buf.putMPInt(this.e);
                this.session.write(this.packet);
                if (JSch.getLogger().isEnabled(1)) {
                    JSch.getLogger().log(1, "SSH_MSG_KEX_DH_GEX_INIT sent");
                    JSch.getLogger().log(1, "expecting SSH_MSG_KEX_DH_GEX_REPLY");
                }
                this.state = 33;
                return true;
            }
            case 33: {
                int n = buffer.getInt();
                n = buffer.getByte();
                n = buffer.getByte();
                if (n != 33) {
                    System.err.println("type: must be SSH_MSG_KEX_DH_GEX_REPLY " + n);
                    return false;
                }
                this.K_S = buffer.getString();
                byte[] byArray = buffer.getMPInt();
                byte[] byArray2 = buffer.getString();
                this.dh.setF(byArray);
                this.K = this.dh.getK();
                this.buf.reset();
                this.buf.putString(this.V_C);
                this.buf.putString(this.V_S);
                this.buf.putString(this.I_C);
                this.buf.putString(this.I_S);
                this.buf.putString(this.K_S);
                this.buf.putInt(min);
                this.buf.putInt(preferred);
                this.buf.putInt(max);
                this.buf.putMPInt(this.p);
                this.buf.putMPInt(this.g);
                this.buf.putMPInt(this.e);
                this.buf.putMPInt(byArray);
                this.buf.putMPInt(this.K);
                byte[] byArray3 = new byte[this.buf.getLength()];
                this.buf.getByte(byArray3);
                this.sha.update(byArray3, 0, byArray3.length);
                this.H = this.sha.digest();
                int n2 = 0;
                n = 0;
                n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                String string = new String(this.K_S, n2, n);
                n2 += n;
                boolean bl = false;
                if (string.equals("ssh-rsa")) {
                    this.type = 0;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byte[] byArray4 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray4, 0, n);
                    n2 += n;
                    byte[] byArray5 = byArray4;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray4 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray4, 0, n);
                    n2 += n;
                    byte[] byArray6 = byArray4;
                    SignatureRSA signatureRSA = null;
                    try {
                        Class<?> clazz = Class.forName(this.session.getConfig("signature.rsa"));
                        signatureRSA = (SignatureRSA)clazz.newInstance();
                        signatureRSA.init();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    signatureRSA.setPubKey(byArray5, byArray6);
                    signatureRSA.update(this.H);
                    bl = signatureRSA.verify(byArray2);
                    if (JSch.getLogger().isEnabled(1)) {
                        JSch.getLogger().log(1, "ssh_rsa_verify: signature " + bl);
                    }
                } else if (string.equals("ssh-dss")) {
                    byte[] byArray7 = null;
                    this.type = 1;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byte[] byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    this.p = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    byArray7 = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    this.g = byArray8;
                    n = this.K_S[n2++] << 24 & 0xFF000000 | this.K_S[n2++] << 16 & 0xFF0000 | this.K_S[n2++] << 8 & 0xFF00 | this.K_S[n2++] & 0xFF;
                    byArray8 = new byte[n];
                    System.arraycopy(this.K_S, n2, byArray8, 0, n);
                    n2 += n;
                    byArray = byArray8;
                    SignatureDSA signatureDSA = null;
                    try {
                        Class<?> clazz = Class.forName(this.session.getConfig("signature.dss"));
                        signatureDSA = (SignatureDSA)clazz.newInstance();
                        signatureDSA.init();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    signatureDSA.setPubKey(byArray, this.p, byArray7, this.g);
                    signatureDSA.update(this.H);
                    bl = signatureDSA.verify(byArray2);
                    if (JSch.getLogger().isEnabled(1)) {
                        JSch.getLogger().log(1, "ssh_dss_verify: signature " + bl);
                    }
                } else {
                    System.err.println("unknown alg");
                }
                this.state = 0;
                return bl;
            }
        }
        return false;
    }

    public String getKeyType() {
        if (this.type == 1) {
            return "DSA";
        }
        return "RSA";
    }

    public int getState() {
        return this.state;
    }
}

