/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public final class DefaultURLConnection
extends URLConnection {
    private final FileContent content;

    public DefaultURLConnection(URL url, FileContent content) {
        super(url);
        this.content = content;
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    public long getLastModified() {
        try {
            return this.content.getLastModifiedTime();
        }
        catch (FileSystemException fileSystemException) {
            return -1L;
        }
    }

    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException fileSystemException) {
            return -1;
        }
    }

    public String getContentType() {
        try {
            return this.content.getContentInfo().getContentType();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getContentEncoding() {
        try {
            return this.content.getContentInfo().getContentEncoding();
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

