/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.http.client.fluent;

import com.crashlytics.reloc.org.apache.http.HttpHost;
import com.crashlytics.reloc.org.apache.http.auth.AuthScope;
import com.crashlytics.reloc.org.apache.http.auth.Credentials;
import com.crashlytics.reloc.org.apache.http.auth.MalformedChallengeException;
import com.crashlytics.reloc.org.apache.http.auth.NTCredentials;
import com.crashlytics.reloc.org.apache.http.auth.UsernamePasswordCredentials;
import com.crashlytics.reloc.org.apache.http.client.AuthCache;
import com.crashlytics.reloc.org.apache.http.client.ClientProtocolException;
import com.crashlytics.reloc.org.apache.http.client.CookieStore;
import com.crashlytics.reloc.org.apache.http.client.CredentialsProvider;
import com.crashlytics.reloc.org.apache.http.client.HttpClient;
import com.crashlytics.reloc.org.apache.http.client.fluent.Request;
import com.crashlytics.reloc.org.apache.http.client.fluent.Response;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpRequestBase;
import com.crashlytics.reloc.org.apache.http.client.methods.HttpUriRequest;
import com.crashlytics.reloc.org.apache.http.config.Registry;
import com.crashlytics.reloc.org.apache.http.config.RegistryBuilder;
import com.crashlytics.reloc.org.apache.http.conn.scheme.Scheme;
import com.crashlytics.reloc.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.crashlytics.reloc.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.crashlytics.reloc.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.crashlytics.reloc.org.apache.http.conn.ssl.SSLInitializationException;
import com.crashlytics.reloc.org.apache.http.impl.auth.BasicScheme;
import com.crashlytics.reloc.org.apache.http.impl.client.BasicAuthCache;
import com.crashlytics.reloc.org.apache.http.impl.client.BasicCredentialsProvider;
import com.crashlytics.reloc.org.apache.http.impl.client.HttpClientBuilder;
import com.crashlytics.reloc.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.crashlytics.reloc.org.apache.http.message.BasicHeader;
import com.crashlytics.reloc.org.apache.http.protocol.BasicHttpContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private final BasicHttpContext localContext;
    private final AuthCache authCache;
    private CredentialsProvider credentialsProvider;
    private CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.localContext = new BasicHttpContext();
        this.authCache = new BasicAuthCache();
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        this.credentialsProvider.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host, Credentials creds) {
        AuthScope authScope = host != null ? new AuthScope(host) : AuthScope.ANY;
        return this.auth(authScope, creds);
    }

    public Executor authPreemptive(HttpHost host) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(HttpHost host) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host, basicScheme);
        return this;
    }

    public Executor auth(Credentials cred) {
        return this.auth(AuthScope.ANY, cred);
    }

    public Executor auth(String username, String password) {
        return this.auth(new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(String username, String password, String workstation, String domain) {
        return this.auth(new NTCredentials(username, password, workstation, domain));
    }

    public Executor auth(HttpHost host, String username, String password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, String password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
        }
        return this;
    }

    public Executor cookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) throws ClientProtocolException, IOException {
        this.localContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        this.localContext.setAttribute("http.auth.auth-cache", this.authCache);
        this.localContext.setAttribute("http.cookie-store", this.cookieStore);
        HttpRequestBase httprequest = request.getHttpRequest();
        httprequest.reset();
        return new Response(this.httpclient.execute((HttpUriRequest)httprequest, this.localContext));
    }

    @Deprecated
    public static void registerScheme(Scheme scheme) {
    }

    @Deprecated
    public static void unregisterScheme(String name) {
    }

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException ignore) {
            }
            catch (KeyManagementException ignore) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> sfr = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CONNMGR = new PoolingHttpClientConnectionManager(sfr);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

