/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.Repository;
import com.crashlytics.tools.utils.FileUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AndroidGradlePropertiesOnboarder
extends EmptyOnboarder {
    private final Code _propertiesFile;
    private final Repository _repository;
    private final String _lineSeparator;
    private final String _currentContents;

    public AndroidGradlePropertiesOnboarder(Repository repository, Code propertiesFile) throws IOException {
        this._repository = repository;
        this._propertiesFile = propertiesFile;
        this._currentContents = this._propertiesFile.getCode();
        this._lineSeparator = FileUtils.getLineSeparator(this._currentContents);
    }

    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        changes.addAll(this.setProperty("AUTHENTICATED_MAVEN_USERNAME", this._repository.getUsername()));
        changes.addAll(this.setProperty("AUTHENTICATED_MAVEN_PASSWORD", this._repository.getPassword()));
        changes.addAll(this.setProperty("AUTHENTICATED_MAVEN_URL", this._repository.getUrl()));
        return Collections.singletonList(new CodeChange("gradle.properties", this._propertiesFile, changes));
    }

    private List<CodeChange.BlockChange> setProperty(String property, String value) {
        int propertyPos = this._currentContents.indexOf(property);
        if (propertyPos != -1) {
            int replaceStart = property.length() + propertyPos;
            int replaceEnd = this._currentContents.indexOf(this._lineSeparator, replaceStart);
            int n = replaceEnd = replaceEnd == -1 ? this._currentContents.length() : replaceEnd;
            if (!this._currentContents.substring(replaceStart, replaceEnd).equals("=" + value)) {
                return this.replace(value, replaceStart, replaceEnd);
            }
            return Collections.emptyList();
        }
        return this.insert(property, value, this._currentContents.length());
    }

    private List<CodeChange.BlockChange> replace(String value, int propertyStart, int propertyEnd) {
        CodeChange.Deletion codeDeletion = new CodeChange.Deletion(propertyStart, propertyEnd);
        CodeChange.Insertion codeInsertion = new CodeChange.Insertion(propertyStart, "=" + value);
        return Arrays.asList(codeDeletion, codeInsertion);
    }

    private List<CodeChange.BlockChange> insert(String property, String value, int position) {
        String insertString = this._lineSeparator + property + "=" + value;
        CodeChange.Insertion codeInsertion = new CodeChange.Insertion(position, insertString);
        return Collections.singletonList(codeInsertion);
    }
}

