/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Strings;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.MoPubAdType;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MoPubCodeBlockFactory {
    public static CodeChange getManualCodeDirections(String javaFileContents, MoPubAdType adType) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        changes.add(MoPubCodeBlockFactory.injectAfter("import android.app.Activity;\n", javaFileContents, MoPubCodeBlockFactory.createImports(MoPubCodeBlockFactory.getImports(adType))));
        changes.add(MoPubCodeBlockFactory.injectAfter("public class MainActivity extends Activity {\n", javaFileContents, MoPubCodeBlockFactory.getVariableDeclarationCode("\t", adType)));
        changes.add(MoPubCodeBlockFactory.injectAfter("setContentView(R.layout.activity_main);\n", javaFileContents, MoPubCodeBlockFactory.getLayoutManipulationCode("\t", adType)));
        changes.add(MoPubCodeBlockFactory.injectAfter("void onDestroy() {\n", javaFileContents, MoPubCodeBlockFactory.getOnDestroyCode("\t", adType)));
        changes.add(MoPubCodeBlockFactory.injectAfter("void onResume() {\n", javaFileContents, MoPubCodeBlockFactory.getOnResumeCode("\t", adType)));
        switch (adType) {
            case Interstitial: {
                changes.add(MoPubCodeBlockFactory.injectAfter("public class MainActivity extends Activity ", javaFileContents, MoPubCodeBlockFactory.getImplementsCode(adType)));
                changes.add(MoPubCodeBlockFactory.injectAfterUsingRegex("super\\.onDestroy\\(\\);[\\s\\n]+\\}\\n", javaFileContents, MoPubCodeBlockFactory.getInterstitialListenerMethodsCode("\t")));
                break;
            }
        }
        return new CodeChange("View Class", new StubCode(javaFileContents), changes);
    }

    public static CodeChange getManualLayoutDirections(String layoutFileContents, MoPubAdType adType) {
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        switch (adType) {
            case Banner: {
                changes.add(MoPubCodeBlockFactory.injectAfter("android:layout_height=\"wrap_content\" />", layoutFileContents, MoPubCodeBlockFactory.getMoPubBannerAd("\n        ")));
                break;
            }
            case Native: {
                changes.add(MoPubCodeBlockFactory.injectAfter("android:layout_height=\"wrap_content\" />", layoutFileContents, MoPubCodeBlockFactory.getMoPubSampleListView("\n        ")));
                break;
            }
        }
        return new CodeChange("View XML", new StubCode(layoutFileContents), changes);
    }

    private static Collection<? extends String> getImports(MoPubAdType adType) {
        LinkedList<String> importStrings = new LinkedList<String>();
        switch (adType) {
            case Banner: {
                importStrings.add("com.mopub.mobileads.MoPubView");
                break;
            }
            case Interstitial: {
                importStrings.add("com.mopub.mobileads.MoPubErrorCode");
                importStrings.add("com.mopub.mobileads.MoPubInterstitial");
                break;
            }
            case Native: {
                importStrings.add("com.mopub.nativeads.MoPubAdAdapter");
                importStrings.add("com.mopub.nativeads.MoPubNativeAdRenderer");
                importStrings.add("com.mopub.nativeads.RequestParameters");
                importStrings.add("com.mopub.nativeads.ViewBinder");
                importStrings.add("android.widget.ArrayAdapter");
                importStrings.add("android.widget.ListView");
                importStrings.add("java.util.ArrayList");
                break;
            }
        }
        return importStrings;
    }

    private static String getImplementsCode(MoPubAdType adType) {
        String implementString = "";
        switch (adType) {
            case Interstitial: {
                implementString = "implements MoPubInterstitial.InterstitialAdListener ";
                break;
            }
        }
        return implementString;
    }

    private static String getVariableDeclarationCode(String tab, MoPubAdType adType) {
        StringBuilder builder = new StringBuilder();
        switch (adType) {
            case Banner: {
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "// TODO: Replace this test id with your personal ad unit id\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private static final String MOPUB_BANNER_AD_UNIT_ID = \"" + adType.getSampleId() + "\";\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private MoPubView moPubView;\n"));
                break;
            }
            case Interstitial: {
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "// TODO: Replace this test id with your personal ad unit id\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private static final String MOPUB_INTERSTITIAL_AD_UNIT_ID = \"" + adType.getSampleId() + "\";\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private MoPubInterstitial interstitial;\n"));
                break;
            }
            case Native: {
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "// TODO: Replace this test id with your personal ad unit id\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private static final String MOPUB_NATIVE_AD_UNIT_ID = \"" + adType.getSampleId() + "\";\n"));
                builder.append(MoPubCodeBlockFactory.indentString(1, tab, "private MoPubAdAdapter adAdapter;\n"));
                break;
            }
        }
        return builder.toString();
    }

    private static String getLayoutManipulationCode(String tab, MoPubAdType adType) {
        StringBuilder builder = new StringBuilder();
        switch (adType) {
            case Banner: {
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "moPubView = (MoPubView) findViewById(R.id.mopub_sample_ad);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "moPubView.setAdUnitId(MOPUB_BANNER_AD_UNIT_ID);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "moPubView.loadAd();\n"));
                break;
            }
            case Interstitial: {
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "interstitial = new MoPubInterstitial(this, MOPUB_INTERSTITIAL_AD_UNIT_ID);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "interstitial.setInterstitialAdListener(this);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "interstitial.load();\n"));
                break;
            }
            case Native: {
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "ListView sampleListView = (ListView) findViewById(R.id.mopub_sample_list_view);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "ArrayList<String> sampleItems = new ArrayList<String>();\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "for (int i = 1; i <= 20; i++) {\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, "sampleItems.add(\"Item \" + i);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "}\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "ArrayAdapter<String> sampleAdapter = new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, sampleItems);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "ViewBinder viewBinder = new ViewBinder.Builder(R.layout.example_native_ad)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".titleId(R.id.native_title)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".textId(R.id.native_text)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".mainImageId(R.id.native_main_image)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".iconImageId(R.id.native_icon_image)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".callToActionId(R.id.native_cta)\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".build();\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "MoPubNativeAdRenderer adRenderer = new MoPubNativeAdRenderer(viewBinder);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "adAdapter = new MoPubAdAdapter(this, sampleAdapter);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "adAdapter.registerAdRenderer(adRenderer);\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "sampleListView.setAdapter(adAdapter);\n"));
                break;
            }
        }
        return builder.toString();
    }

    private static String getMoPubBannerAd(String newlineIndented) {
        Joiner joiner = Joiner.on(newlineIndented);
        return joiner.join("    <com.mopub.mobileads.MoPubView", "android:id=\"@+id/mopub_sample_ad\"", "android:layout_alignParentBottom=\"true\"", "android:layout_width=\"fill_parent\"", "android:layout_height=\"50dp\"/>\n");
    }

    private static String getMoPubSampleListView(String newlineIndented) {
        Joiner joiner = Joiner.on(newlineIndented);
        return joiner.join("    <ListView", "android:id=\"@+id/mopub_sample_list_view\"", "android:layout_alignParentBottom=\"true\"", "android:layout_width=\"match_parent\"", "android:layout_height=\"match_parent\"/>\n");
    }

    private static String getOnDestroyCode(String tab, MoPubAdType adType) {
        String onDestroyString;
        switch (adType) {
            case Banner: {
                onDestroyString = "moPubView.destroy();\n";
                break;
            }
            case Interstitial: {
                onDestroyString = "interstitial.destroy();\n";
                break;
            }
            case Native: {
                onDestroyString = "adAdapter.destroy();\n";
                break;
            }
            default: {
                onDestroyString = "";
            }
        }
        return MoPubCodeBlockFactory.indentString(2, tab, onDestroyString);
    }

    private static String getOnResumeCode(String tab, MoPubAdType adType) {
        StringBuilder builder = new StringBuilder();
        switch (adType) {
            case Native: {
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "// Optional targeting parameters\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "RequestParameters parameters = new RequestParameters.Builder()\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, "//.keywords(\"your target words here\")\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, ".build();\n"));
                builder.append(MoPubCodeBlockFactory.indentString(0, tab, "\n"));
                builder.append(MoPubCodeBlockFactory.indentString(2, tab, "// Request ads when the user returns to this activity\n"));
                builder.append(MoPubCodeBlockFactory.indentString(4, tab, "adAdapter.loadAds(MOPUB_NATIVE_AD_UNIT_ID, parameters);\n"));
                break;
            }
        }
        return builder.toString();
    }

    private static String getInterstitialListenerMethodsCode(String tab) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "// InterstitialAdListener methods\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "public void onInterstitialLoaded(MoPubInterstitial interstitial) {\n"));
        builder.append(MoPubCodeBlockFactory.indentString(2, tab, "if (interstitial.isReady()) {\n"));
        builder.append(MoPubCodeBlockFactory.indentString(3, tab, "interstitial.show();\n"));
        builder.append(MoPubCodeBlockFactory.indentString(2, tab, "} else {\n"));
        builder.append(MoPubCodeBlockFactory.indentString(3, tab, "// Other code\n"));
        builder.append(MoPubCodeBlockFactory.indentString(2, tab, "}\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "}\n"));
        builder.append("\n");
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "public void onInterstitialFailed(MoPubInterstitial interstitial, MoPubErrorCode errorCode) {}\n"));
        builder.append("\n");
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "public void onInterstitialShown(MoPubInterstitial interstitial) {}\n"));
        builder.append("\n");
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "public void onInterstitialClicked(MoPubInterstitial interstitial) {}\n"));
        builder.append("\n");
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "@Override\n"));
        builder.append(MoPubCodeBlockFactory.indentString(1, tab, "public void onInterstitialDismissed(MoPubInterstitial interstitial) {}\n"));
        return builder.toString();
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length(), toAdd);
    }

    private static CodeChange.BlockChange injectAfterUsingRegex(String regex, String contents, String toAdd) {
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(contents);
        if (!m.find()) {
            DeveloperTools.logW("Could not match regex string: " + regex + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        int offset = m.end();
        return new CodeChange.Insertion(offset, toAdd);
    }

    private static String createImports(Collection<? extends String> imports) {
        StringBuilder builder = new StringBuilder();
        for (String string : imports) {
            builder.append("import " + string + ";\n");
        }
        return builder.toString();
    }

    private static String indentString(int tabs, String tab, String string) {
        return Strings.repeat(tab, tabs) + string;
    }
}

