/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.dsl.transform;

import com.crashlytics.reloc.com.google.common.collect.ImmutableList;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.dsl.ModifiableClass;
import com.crashlytics.tools.android.onboard.dsl.transform.ClassTransform;
import com.crashlytics.tools.utils.StringUtils;

public class ChainedExpressions<T>
implements ClassTransform<T> {
    private ImmutableList<ClassTransform<?>> _transforms;
    private ClassTransform<T> _returnTransform;

    public ChainedExpressions(ImmutableList<ClassTransform<?>> transforms, ClassTransform<T> returnTransform) {
        this._transforms = transforms;
        this._returnTransform = returnTransform;
    }

    @Override
    public T apply(ModifiableClass modifiableClass) throws OnboardException {
        for (ClassTransform classTransform : this._transforms) {
            classTransform.apply(modifiableClass);
        }
        return this._returnTransform.apply(modifiableClass);
    }

    public String toString() {
        return "Chain: \n\t" + StringUtils.tabAppender(1).apply(this._transforms.toString() + "\n return: \n" + this._returnTransform);
    }
}

