/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.dsl.transform;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.com.google.common.collect.ImmutableList;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.dsl.ModifiableClass;
import com.crashlytics.tools.android.onboard.dsl.ModifiableMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.transform.AddFields;
import com.crashlytics.tools.android.onboard.dsl.transform.AddImports;
import com.crashlytics.tools.android.onboard.dsl.transform.AddParameterAt;
import com.crashlytics.tools.android.onboard.dsl.transform.AddStatementsBefore;
import com.crashlytics.tools.android.onboard.dsl.transform.ChainedExpressions;
import com.crashlytics.tools.android.onboard.dsl.transform.ClassTransform;
import com.crashlytics.tools.android.onboard.dsl.transform.Create;
import com.crashlytics.tools.android.onboard.dsl.transform.DeleteMethod;
import com.crashlytics.tools.android.onboard.dsl.transform.Elvis;
import com.crashlytics.tools.android.onboard.dsl.transform.FlagUpgrade;
import com.crashlytics.tools.android.onboard.dsl.transform.Get;
import com.crashlytics.tools.android.onboard.dsl.transform.GetParameterAt;
import com.crashlytics.tools.android.onboard.dsl.transform.TransformIf;
import com.crashlytics.tools.android.onboard.dsl.transform.Value;
import java.util.List;

public class CodeChangeBuilder
implements ClassTransform<Void> {
    private final ImmutableList<ClassTransform<?>> _transforms;

    public static CodeChangeBuilder create() {
        return new CodeChangeBuilder(ImmutableList.<ClassTransform<?>>of());
    }

    public CodeChangeBuilder(ImmutableList<ClassTransform<?>> transforms) {
        this._transforms = transforms;
    }

    public CodeChangeBuilder with(ClassTransform<?> transform) {
        return new CodeChangeBuilder((ImmutableList<ClassTransform<?>>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this._transforms)).add(transform)).build());
    }

    @Override
    public Void apply(ModifiableClass modifiableClass) throws OnboardException {
        for (ClassTransform classTransform : this._transforms) {
            classTransform.apply(modifiableClass);
        }
        return null;
    }

    public CodeChangeBuilder addImports(List<String> imports) {
        return this.with(new AddImports(Value.from(imports)));
    }

    public static ClassTransform<Boolean> delete(NestedMethodInvocation invocation) {
        return new DeleteMethod(invocation);
    }

    public CodeChangeBuilder transformIf(ClassTransform<Boolean> transformCondition, ClassTransform<Void> transform) {
        return this.with(new TransformIf<Void>(transformCondition, transform));
    }

    public static ClassTransform<Optional<ModifiableMethodInvocation>> getMethod(NestedMethodInvocation invocation) {
        return new Get(invocation);
    }

    public static ClassTransform<ModifiableMethodInvocation> createMethod(NestedMethodInvocation method, ClassTransform<String> parameterAt) {
        return new Create(method, parameterAt);
    }

    public static ClassTransform<Boolean> addParameterAt(ClassTransform<ModifiableMethodInvocation> method, String parameter) {
        return new AddParameterAt(method, Value.of(parameter));
    }

    public static ClassTransform<Void> insertStatementBefore(ClassTransform<ModifiableMethodInvocation> invocation, String statement) {
        return new AddStatementsBefore(invocation, Value.from(statement));
    }

    public static ClassTransform<Void> insertFields(String ... statements) {
        return new AddFields(Value.from(statements));
    }

    public String toString() {
        return Joiner.on('\n').join(this._transforms);
    }

    public static ClassTransform<Void> flagUpgrade() {
        return new FlagUpgrade();
    }

    public static ClassTransform<Void> doAll(ClassTransform<Void> ... expressions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < expressions.length - 1; ++i) {
            builder.add(expressions[i]);
        }
        return new ChainedExpressions<Void>((ImmutableList<ClassTransform<?>>)builder.build(), expressions[expressions.length - 1]);
    }

    public static ClassTransform<Optional<String>> getParameterAt(NestedMethodInvocation invocation, int parameterOrdinal) {
        return new GetParameterAt(CodeChangeBuilder.getMethod(invocation), Value.of(parameterOrdinal));
    }

    public static <T> ClassTransform<T> elvis(ClassTransform<Optional<T>> primary, ClassTransform<T> ifFalse) {
        return new Elvis<T>(primary, ifFalse);
    }
}

