/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.kits;

import com.crashlytics.api.TwitterToken;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.TwitterAuthCodeBlockFactory;
import com.crashlytics.tools.android.onboard.dsl.ModifiableMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import com.crashlytics.tools.android.onboard.dsl.transform.ClassTransform;
import com.crashlytics.tools.android.onboard.dsl.transform.CodeChangeBuilder;
import com.crashlytics.tools.android.onboard.dsl.transform.Value;
import com.crashlytics.tools.android.onboard.kits.KitUtils;
import java.util.List;

public class KitClassTransformFactory {
    public static CodeChangeBuilder create(boolean hasKitsEnabled, Kit kit, Optional<TwitterToken> token) {
        List<String> importsForKit = KitUtils.importsForKits(kit, hasKitsEnabled);
        if (kit.isSameArtifact(OnboardingConstants.TWITTER_KIT)) {
            return KitClassTransformFactory.createTwitterInjections(KitUtils.createConstructorArg(kit), OnboardingConstants.getStartMethod(hasKitsEnabled), importsForKit, token, OnboardingConstants.getLegacyStartMethod());
        }
        if (kit.isSameArtifact(OnboardingConstants.LEGACY_CRASHLYTICS_KIT)) {
            return KitClassTransformFactory.createLegacyInjections(OnboardingConstants.getLegacyStartMethod(), importsForKit);
        }
        return KitClassTransformFactory.createDefaultInjections(KitUtils.createConstructorArg(kit), OnboardingConstants.getStartMethod(hasKitsEnabled), importsForKit, OnboardingConstants.getLegacyStartMethod());
    }

    public static CodeChangeBuilder createTwitterInjections(String baseKit, NestedMethodInvocation method, List<String> imports, Optional<TwitterToken> twitterToken, NestedMethodInvocation legacyMethod) {
        String key = twitterToken.isPresent() ? twitterToken.get().consumerKey : "TWITTER_KEY";
        String secret = twitterToken.isPresent() ? twitterToken.get().secret : "TWITTER_SECRET";
        String obfuscationComment = TwitterAuthCodeBlockFactory.getObfuscationComment();
        String keyConstant = TwitterAuthCodeBlockFactory.getTwitterKeyConstant(key);
        String secretConstant = TwitterAuthCodeBlockFactory.getTwitterSecretConstant(secret);
        ClassTransform<ModifiableMethodInvocation> methodBuilder = KitClassTransformFactory.getInitializationMethod(method, legacyMethod);
        return CodeChangeBuilder.create().addImports(imports).transformIf(CodeChangeBuilder.addParameterAt(methodBuilder, baseKit), CodeChangeBuilder.doAll(CodeChangeBuilder.insertStatementBefore(methodBuilder, "final TwitterAuthConfig authConfig = new TwitterAuthConfig(TWITTER_KEY, TWITTER_SECRET);"), CodeChangeBuilder.insertFields(obfuscationComment, keyConstant, secretConstant)));
    }

    private static ClassTransform<ModifiableMethodInvocation> getInitializationMethod(NestedMethodInvocation method, NestedMethodInvocation legacyMethod) {
        return CodeChangeBuilder.elvis(CodeChangeBuilder.getMethod(method), CodeChangeBuilder.createMethod(method, CodeChangeBuilder.elvis(CodeChangeBuilder.getParameterAt(legacyMethod, 0), Value.of("this"))));
    }

    public static CodeChangeBuilder createLegacyInjections(NestedMethodInvocation invocation, List<String> imports) {
        return CodeChangeBuilder.create().addImports(imports).with(KitClassTransformFactory.legacyInitializationMethod(invocation));
    }

    private static ClassTransform<?> legacyInitializationMethod(NestedMethodInvocation invocation) {
        return CodeChangeBuilder.elvis(CodeChangeBuilder.getMethod(invocation), CodeChangeBuilder.createMethod(invocation, Value.of("this")));
    }

    public static CodeChangeBuilder createDefaultInjections(String baseName, NestedMethodInvocation method, List<String> imports, NestedMethodInvocation legacyMethod) {
        return CodeChangeBuilder.create().addImports(imports).with(CodeChangeBuilder.addParameterAt(KitClassTransformFactory.getInitializationMethod(method, legacyMethod), baseName));
    }
}

