/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping;

import com.crashlytics.reloc.org.json.simple.JSONArray;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.reloc.org.json.simple.parser.JSONParser;
import com.crashlytics.tools.android.DeveloperTools;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CodeMappingMetadata {
    protected static final String KEY_PROJECT = "project";
    protected static final String KEY_IDENTIFIER = "identifier";
    protected static final String KEY_BUILDVERSION = "build_version";
    protected static final String KEY_DISPLAYVERSION = "display_version";
    protected static final String KEY_CODEMAPPING = "code_mapping";
    protected static final String KEY_TYPE = "type";
    protected static final String KEY_BUILDCONFIG = "build_configuration";
    protected static final String KEY_EXECUTABLES = "executables";
    protected static final String KEY_ARCHITECTURE = "arch";
    private static final String MAP_FORMAT_PROPERTY = "%s[%s]";
    private static final String MAP_FORMAT_ARRAY = "[][%s]";
    private static final String MAP_FORMAT_EXECUTABLE = String.format("%s[%s]", "code_mapping", "executables") + "[][%s]";
    private String _projIdentifier;
    private String _projDisplayVersion;
    private int _projBuildVersion;
    private String _codeMappingType;
    private String _codeMappingBuildConfig;
    private List<Executable> _codeMappingExecutables = new LinkedList<Executable>();
    private Map<String, String> _parameterMap;

    public static CodeMappingMetadata parseFromJSON(Reader input) throws IOException {
        JSONObject json;
        JSONParser parser = new JSONParser();
        try {
            json = (JSONObject)parser.parse(input);
        }
        catch (Exception e) {
            throw new IOException("Exception while parsing input", e);
        }
        JSONObject project = (JSONObject)json.get(KEY_PROJECT);
        JSONObject codeMapping = (JSONObject)json.get(KEY_CODEMAPPING);
        if (project == null) {
            throw new IllegalArgumentException("No value for project");
        }
        if (codeMapping == null) {
            throw new IllegalArgumentException("No value for code_mapping");
        }
        String projId = (String)project.get(KEY_IDENTIFIER);
        String displayVersion = (String)project.get(KEY_DISPLAYVERSION);
        int buildVersion = 0;
        Long buildVersionLong = (Long)project.get(KEY_BUILDVERSION);
        if (buildVersionLong == null) {
            String log = "Crashlytics did not find a version code and is interpreting it to be 0 by default";
            DeveloperTools.logD(log);
        } else {
            buildVersion = buildVersionLong.intValue();
        }
        String codeMappingType = (String)codeMapping.get(KEY_TYPE);
        String buildConfig = (String)codeMapping.get(KEY_BUILDCONFIG);
        JSONArray executables = (JSONArray)codeMapping.get(KEY_EXECUTABLES);
        Builder builder = new Builder(projId, buildVersion, displayVersion, codeMappingType);
        if (buildConfig != null) {
            builder.setBuildConfig(buildConfig);
        }
        if (executables != null) {
            for (Object obj : executables) {
                JSONObject jsonObj = (JSONObject)obj;
                builder.addExecutable((String)jsonObj.get(KEY_IDENTIFIER), (String)jsonObj.get(KEY_ARCHITECTURE));
            }
        }
        return builder.build();
    }

    public static void serializeToJSON(CodeMappingMetadata md, Writer output) throws IOException {
        JSONObject json = new JSONObject();
        JSONObject project = new JSONObject();
        JSONObject codeMapping = new JSONObject();
        project.put(KEY_IDENTIFIER, md.getProjectIdentifier());
        project.put(KEY_DISPLAYVERSION, md.getProjectDisplayVersion());
        project.put(KEY_BUILDVERSION, md.getProjectBuildVersion());
        codeMapping.put(KEY_TYPE, md.getCodeMappingType());
        codeMapping.put(KEY_BUILDCONFIG, md.getCodeMappingBuildConfig());
        LinkedList<JSONObject> exeList = new LinkedList<JSONObject>();
        for (Executable e : md.getCodeMappingExecutables()) {
            exeList.add(new JSONObject(e.asMap()));
        }
        codeMapping.put(KEY_EXECUTABLES, exeList);
        json.put(KEY_PROJECT, project);
        json.put(KEY_CODEMAPPING, codeMapping);
        JSONObject.writeJSONString(json, output);
    }

    private CodeMappingMetadata(String projIdentifier, int projBuildVersion, String projDisplayVersion, String codeMappingType, String codeMappingBuildConfig, List<Executable> executables) {
        this._projIdentifier = projIdentifier;
        this._projBuildVersion = projBuildVersion;
        this._projDisplayVersion = projDisplayVersion;
        this._codeMappingType = codeMappingType;
        this._codeMappingBuildConfig = codeMappingBuildConfig;
        this._codeMappingExecutables = executables;
    }

    public Map<String, String> asParameterMap() {
        if (this._parameterMap == null) {
            this._parameterMap = this.generateParameterMap();
        }
        return this._parameterMap;
    }

    public String getProjectIdentifier() {
        return this._projIdentifier;
    }

    public String getProjectDisplayVersion() {
        return this._projDisplayVersion;
    }

    public int getProjectBuildVersion() {
        return this._projBuildVersion;
    }

    public String getCodeMappingType() {
        return this._codeMappingType;
    }

    public String getCodeMappingBuildConfig() {
        return this._codeMappingBuildConfig;
    }

    public List<Executable> getCodeMappingExecutables() {
        return this._codeMappingExecutables;
    }

    private Map<String, String> generateParameterMap() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        this.putIfNotNull(m, String.format(MAP_FORMAT_PROPERTY, KEY_PROJECT, KEY_IDENTIFIER), this._projIdentifier);
        this.putIfNotNull(m, String.format(MAP_FORMAT_PROPERTY, KEY_PROJECT, KEY_BUILDVERSION), Integer.toString(this._projBuildVersion));
        this.putIfNotNull(m, String.format(MAP_FORMAT_PROPERTY, KEY_PROJECT, KEY_DISPLAYVERSION), this._projDisplayVersion);
        this.putIfNotNull(m, String.format(MAP_FORMAT_PROPERTY, KEY_CODEMAPPING, KEY_TYPE), this._codeMappingType);
        this.putIfNotNull(m, String.format(MAP_FORMAT_PROPERTY, KEY_CODEMAPPING, KEY_BUILDCONFIG), this._codeMappingBuildConfig);
        for (Executable e : this._codeMappingExecutables) {
            m.put(String.format(MAP_FORMAT_EXECUTABLE, KEY_IDENTIFIER), e.identifier);
            m.put(String.format(MAP_FORMAT_EXECUTABLE, KEY_ARCHITECTURE), e.architecture);
        }
        return m;
    }

    private void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public static final class Builder {
        private String _projIdentifier;
        private String _projDisplayVersion;
        private int _projBuildVersion;
        private String _codeMappingType;
        private String _codeMappingBuildConfig;
        private List<Executable> _codeMappingExecutables = new LinkedList<Executable>();

        public Builder(String identifier, int buildVersion, String displayVersion, String codeMappingType) {
            this._projIdentifier = identifier;
            this._projBuildVersion = buildVersion;
            this._projDisplayVersion = displayVersion;
            this._codeMappingType = codeMappingType;
        }

        public void setBuildConfig(String buildConfig) {
            this._codeMappingBuildConfig = buildConfig;
        }

        public void addExecutable(String identifier, String architecture) {
            this._codeMappingExecutables.add(new Executable(identifier, architecture));
        }

        public CodeMappingMetadata build() {
            return new CodeMappingMetadata(this._projIdentifier, this._projBuildVersion, this._projDisplayVersion, this._codeMappingType, this._codeMappingBuildConfig, this._codeMappingExecutables);
        }
    }

    public static final class Executable {
        public String identifier;
        public String architecture;

        public Executable(String id, String arch) {
            this.identifier = id;
            this.architecture = arch;
        }

        public Map<String, String> asMap() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(CodeMappingMetadata.KEY_IDENTIFIER, this.identifier);
            map.put(CodeMappingMetadata.KEY_ARCHITECTURE, this.architecture);
            return map;
        }
    }
}

