/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.reloc.com.google.common.base.Charsets;
import com.crashlytics.tools.android.project.codemapping.csym.CSym;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class CSymWriter {
    private static final int CSYM_VERSION = 1;
    private static final String HEADER_FORMAT = "code_mapping\t%d\t%s\t%s\t%s\t%d\t%d\t%d\n";
    private static final String RANGE_FORMAT = "%d\t%d\t%d\t%d\t%d\n";

    public static void writeToOutputStream(CSym cSym, OutputStream os) {
        CSymWriter.write(cSym, new OutputStreamWriter(os, Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToTextFile(CSym cSym, File file) throws IOException {
        FileOutputStream fileOs = null;
        try {
            fileOs = new FileOutputStream(file);
            CSymWriter.writeToOutputStream(cSym, fileOs);
        }
        finally {
            if (fileOs != null) {
                fileOs.close();
            }
        }
    }

    private static void write(CSym cSym, Writer writer) {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        CSymWriter.writeHeader(cSym, out);
        CSymWriter.writeFiles(cSym, out);
        CSymWriter.writeSymbols(cSym, out);
        CSymWriter.writeRanges(cSym, out);
        out.flush();
    }

    private static void writeHeader(CSym cSym, PrintWriter out) {
        out.printf(HEADER_FORMAT, 1, cSym.getType(), cSym.getUUID(), cSym.getArchitecture(), cSym.getFiles().size(), cSym.getSymbols().size(), cSym.getRanges().size());
    }

    private static void writeFiles(CSym cSym, PrintWriter out) {
        List<String> files = cSym.getFiles();
        out.printf("files\t%d\n", files.size());
        for (String file : files) {
            out.printf("%s\n", file);
        }
    }

    private static void writeSymbols(CSym cSym, PrintWriter out) {
        List<String> symbols = cSym.getSymbols();
        out.printf("symbols\t%d\n", symbols.size());
        for (String symbol : symbols) {
            out.printf("%s\n", symbol);
        }
    }

    private static void writeRanges(CSym cSym, PrintWriter out) {
        List<String> files = cSym.getFiles();
        List<String> symbols = cSym.getSymbols();
        List<CSym.Range> ranges = cSym.getRanges();
        out.printf("ranges\t%d\n", ranges.size());
        for (CSym.Range range : ranges) {
            out.printf(RANGE_FORMAT, range.offset, range.size, symbols.indexOf(range.symbol), files.indexOf(range.file), range.lineNumber);
        }
    }
}

