/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.library;

import com.crashlytics.reloc.com.google.common.io.Files;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import java.io.File;

public class AndroidLibrary {
    public final long timestamp;
    public final String version;
    public final String name;
    public final File file;
    private final boolean _isAar;

    public AndroidLibrary(String name, File file, String version, long lastModified) {
        this.name = name;
        this.file = file;
        this.version = version;
        this.timestamp = lastModified;
        this._isAar = Files.getFileExtension(file.getName()).toLowerCase().trim().endsWith("aar");
    }

    public final boolean isAar() {
        return this._isAar;
    }

    public String toString() {
        return this.name + ":" + this.file.getName() + ":" + this.version + ":" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidLibrary that = (AndroidLibrary)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.file.equals(that.file)) {
            return false;
        }
        if (!this._isAar == that._isAar) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.file.hashCode();
        result = 31 * result + Boolean.valueOf(this._isAar).hashCode();
        return result;
    }

    public static String getModuleName(ModuleId moduleId) {
        return moduleId.toString().replace('.', '-').replace('#', '_');
    }
}

