/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp;

import com.crashlytics.dependency.reloc.org.apache.commons.logging.Log;
import com.crashlytics.dependency.reloc.org.apache.commons.logging.LogFactory;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.VfsLog;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.GenericFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpClient;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileProvider;
import java.io.IOException;
import java.util.Collection;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$vfs$provider$ftp$FtpFileSystem == null ? (class$org$apache$commons$vfs$provider$ftp$FtpFileSystem = FtpFileSystem.class$("com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ftp.FtpFileSystem")) : class$org$apache$commons$vfs$provider$ftp$FtpFileSystem);
    private FtpClient idleClient;
    private final Object idleClientSync = new Object();
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$ftp$FtpFileSystem;

    protected FtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClient = ftpClient;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleClient != null) {
            this.closeConnection(this.idleClient);
            this.idleClient = null;
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), log, "vfs.provider.ftp/close-connection.error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FtpClient getClient() throws FileSystemException {
        Object object = this.idleClientSync;
        synchronized (object) {
            if (this.idleClient == null || !this.idleClient.isConnected()) {
                FTPClientWrapper ftpClient = new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
                return ftpClient;
            }
            FtpClient client = this.idleClient;
            this.idleClient = null;
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(FtpClient client) {
        Object object = this.idleClientSync;
        synchronized (object) {
            if (this.idleClient == null) {
                this.idleClient = client;
            } else {
                this.closeConnection(client);
            }
        }
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

