/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

class RamFileData
implements Serializable {
    private FileName name;
    private FileType type;
    private byte[] buffer;
    private long lastModified;
    private Collection children;

    public RamFileData(FileName name) {
        this.clear();
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        this.name = name;
    }

    byte[] getBuffer() {
        return this.buffer;
    }

    void setBuffer(byte[] buffer) {
        this.updateLastModified();
        this.buffer = buffer;
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    FileType getType() {
        return this.type;
    }

    void setType(FileType type) {
        this.type = type;
    }

    void clear() {
        this.buffer = new byte[0];
        this.updateLastModified();
        this.type = FileType.IMAGINARY;
        this.children = Collections.synchronizedCollection(new ArrayList());
        this.name = null;
    }

    void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }

    FileName getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    void addChild(RamFileData data) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be added in a folder");
        }
        if (data == null) {
            throw new FileSystemException("No child can be null");
        }
        if (this.children.contains(data)) {
            throw new FileSystemException("Child already exists. " + data);
        }
        this.children.add(data);
        this.updateLastModified();
    }

    void removeChild(RamFileData data) throws FileSystemException {
        if (!this.getType().hasChildren()) {
            throw new FileSystemException("A child can only be removed from a folder");
        }
        if (!this.children.contains(data)) {
            throw new FileSystemException("Child not found. " + data);
        }
        this.children.remove(data);
        this.updateLastModified();
    }

    Collection getChildren() {
        if (this.name == null) {
            throw new IllegalStateException("Data is clear");
        }
        return this.children;
    }

    public boolean equals(Object o) {
        RamFileData data = (RamFileData)o;
        return this.getName().equals(data.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    boolean hasChildren(RamFileData data) {
        return this.children.contains(data);
    }

    int size() {
        return this.buffer.length;
    }

    void resize(int newSize) {
        int size = this.size();
        byte[] newBuf = new byte[newSize];
        System.arraycopy(this.buffer, 0, newBuf, 0, size);
        this.buffer = newBuf;
        this.updateLastModified();
    }
}

