/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.AndroidVersion;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Archive;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.BrokenPackage;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.IPackageVersion;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.Package;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.SdkSource;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.XmlParserUtils;
import com.crashlytics.reloc.com.android.sdklib.io.IFileOp;
import com.crashlytics.reloc.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePackage
extends Package
implements IPackageVersion {
    private final AndroidVersion mVersion;

    SourcePackage(SdkSource sdkSource, Node node, String string, Map<String, String> map) {
        super(sdkSource, node, string, map);
        int n = XmlParserUtils.getXmlInt(node, "api-level", 0);
        String string2 = XmlParserUtils.getXmlString(node, "codename");
        if (string2.length() == 0) {
            string2 = null;
        }
        this.mVersion = new AndroidVersion(n, string2);
    }

    protected SourcePackage(AndroidVersion androidVersion, int n, Properties properties, String string) {
        this(null, androidVersion, n, properties, string);
    }

    protected SourcePackage(SdkSource sdkSource, AndroidVersion androidVersion, int n, Properties properties, String string) {
        super(sdkSource, properties, n, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), string);
        this.mVersion = androidVersion;
    }

    public static Package create(File file, Properties properties) {
        CharSequence charSequence;
        AndroidVersion androidVersion = null;
        String string = null;
        if (properties == null) {
            string = String.format("Missing file %1$s", "source.properties");
        } else {
            try {
                androidVersion = new AndroidVersion(properties);
                return new SourcePackage(androidVersion, 0, properties, file.getAbsolutePath());
            }
            catch (AndroidVersion.AndroidVersionException androidVersionException) {
                string = String.format("Invalid file %1$s: %2$s", "source.properties", androidVersionException.getMessage());
            }
        }
        if (androidVersion == null) {
            try {
                charSequence = file.getParentFile().getName();
                charSequence = ((String)charSequence).replaceAll("[^0-9]+", " ").trim();
                int n = ((String)charSequence).indexOf(32);
                if (n >= 0) {
                    charSequence = ((String)charSequence).substring(0, n);
                }
                int n2 = Integer.parseInt((String)charSequence);
                androidVersion = new AndroidVersion(n2, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        charSequence = new StringBuilder("Broken Source Package");
        if (androidVersion != null) {
            ((StringBuilder)charSequence).append(String.format(", API %1$s", androidVersion.getApiString()));
        }
        String string2 = ((StringBuilder)charSequence).toString();
        if (string != null) {
            ((StringBuilder)charSequence).append('\n').append(string);
        }
        String string3 = ((StringBuilder)charSequence).toString();
        return new BrokenPackage(properties, string2, string3, 0, androidVersion == null ? 0 : androidVersion.getApiLevel(), file.getAbsolutePath());
    }

    @Override
    void saveProperties(Properties properties) {
        super.saveProperties(properties);
        this.mVersion.saveProperties(properties);
    }

    @Override
    public AndroidVersion getVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "source-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        if (this.mVersion.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK%2$s", this.mVersion.getCodename(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK%2$s", this.mVersion.getApiLevel(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        if (this.mVersion.isPreview()) {
            return String.format("Sources for Android '%1$s' Preview SDK, revision %2$s%3$s", this.mVersion.getCodename(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("Sources for Android SDK, API %1$d, revision %2$s%3$s", this.mVersion.getApiLevel(), this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String string = this.getDescription();
        if (string == null || string.length() == 0) {
            string = this.getShortDescription();
        }
        if (string.indexOf("revision") == -1) {
            string = string + String.format("\nRevision %1$d%2$s", this.getRevision(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return string;
    }

    @Override
    public File getInstallFolder(String string, SdkManager sdkManager) {
        File file = new File(string, "sources");
        file = new File(file, "android-" + this.mVersion.getApiString());
        return file;
    }

    @Override
    public void postUnzipFileHook(Archive archive, ITaskMonitor iTaskMonitor, IFileOp iFileOp, File file, ZipArchiveEntry zipArchiveEntry) {
        super.postUnzipFileHook(archive, iTaskMonitor, iFileOp, file, zipArchiveEntry);
        if (iFileOp.isFile(file) && !"source.properties".equals(file.getName())) {
            iFileOp.setReadOnly(file);
        }
    }

    @Override
    public boolean sameItemAs(Package package_) {
        if (package_ instanceof SourcePackage) {
            SourcePackage sourcePackage = (SourcePackage)package_;
            return this.getVersion().equals(sourcePackage.getVersion());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SourcePackage)) {
            return false;
        }
        SourcePackage sourcePackage = (SourcePackage)object;
        return !(this.mVersion == null ? sourcePackage.mVersion != null : !this.mVersion.equals(sourcePackage.mVersion));
    }
}

