/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.Code;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.EmptyOnboarder;
import com.crashlytics.tools.android.onboard.OnboardException;
import com.crashlytics.tools.android.onboard.StubCode;
import com.crashlytics.tools.android.onboard.TwitterAuthCodeBlockFactory;
import com.crashlytics.tools.android.project.ResourceProvider;
import com.crashlytics.tools.utils.FileUtils;
import com.crashlytics.tools.utils.xml.ElementOffsetFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ResourceOnboarder
extends EmptyOnboarder {
    private static final String LAYOUT_NODE = "RelativeLayout";
    private final ResourceProvider _resourceProvider;

    public ResourceOnboarder(ResourceProvider resourceProvider) {
        this._resourceProvider = resourceProvider;
    }

    private static String createLoginButton(String lineSep) {
        return TwitterAuthCodeBlockFactory.getLoginButton(lineSep + "        ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<CodeChange> getCodeChanges() throws OnboardException {
        List<CodeChange> list;
        LinkedList<CodeChange.BlockChange> changes = new LinkedList<CodeChange.BlockChange>();
        InputStream xmlStream = null;
        try {
            File resourceFile = this._resourceProvider.getResourceFile();
            Code resourceCode = this._resourceProvider.getResourceCode();
            xmlStream = this._resourceProvider.getResourceStream();
            String lineSep = this.getLineSeparator(this._resourceProvider.getResourceStream());
            ElementOffsetFinder layoutOffset = ElementOffsetFinder.getElementOffset(xmlStream, LAYOUT_NODE);
            InputStream loginButtonOffset = null;
            try {
                loginButtonOffset = this._resourceProvider.getResourceStream();
                String loginButton = lineSep + ResourceOnboarder.createLoginButton(lineSep);
                Locator metadataLocator = layoutOffset.getEndOffsetLocator();
                int loginOffset = FileUtils.locatorCharacterOffset(loginButtonOffset, metadataLocator);
                changes.add(new CodeChange.Insertion(loginOffset, loginButton));
            }
            finally {
                IOUtils.closeQuietly(loginButtonOffset);
            }
            DeveloperTools.logD("Proposed Changes:\n" + changes);
            list = Collections.singletonList(new CodeChange(resourceFile.getName(), resourceCode, changes));
        }
        catch (IOException e) {
            try {
                throw new OnboardException("Crashlytics could not read the main layout file. ", e);
                catch (SAXException e2) {
                    throw new OnboardException("Crashlytics could not parse the main layout file.", e2);
                }
                catch (ParserConfigurationException e3) {
                    throw new OnboardException("Crashlytics could not configure the parser.", e3);
                }
                catch (XMLStreamException e4) {
                    throw new OnboardException("Crashlytics could not parse the main layout xml.", e4);
                }
                catch (Exception e5) {
                    throw new OnboardException("Crashlytics could not get changes for main layout.", e5);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmlStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(xmlStream);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCodeChangeDirectionContents() {
        String mainLayoutContents = null;
        InputStream mainLayoutStream = null;
        try {
            mainLayoutStream = ResourceOnboarder.class.getClassLoader().getResourceAsStream("examples/activity_main.xml.txt");
            mainLayoutContents = FileUtils.streamToString(mainLayoutStream);
        }
        catch (Exception e) {
            try {
                DeveloperTools.logE("Could not load example manifest: examples/activity_main.xml.txt", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(mainLayoutStream);
                throw throwable;
            }
            IOUtils.closeQuietly(mainLayoutStream);
        }
        IOUtils.closeQuietly(mainLayoutStream);
        return mainLayoutContents;
    }

    @Override
    public List<CodeChange> getCodeChangeDirections() {
        String mainLayoutContents = this.getCodeChangeDirectionContents();
        if (mainLayoutContents == null) {
            return Collections.singletonList(CodeChange.createEmptyChange("activity_main.xml"));
        }
        String mainActivitySearchContent = "tools:context=\".MainActivity\">";
        int loginButtonOffset = mainLayoutContents.indexOf(mainActivitySearchContent) + mainActivitySearchContent.length() + 1;
        List<CodeChange.BlockChange> changes = Collections.singletonList(new CodeChange.Insertion(loginButtonOffset, ResourceOnboarder.createLoginButton("\n")));
        return Collections.singletonList(new CodeChange("activity_main.xml", new StubCode(mainLayoutContents), changes));
    }

    protected String getLineSeparator(InputStream contents) {
        return FileUtils.getLineSeparator(contents);
    }
}

