/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard.kits;

import com.crashlytics.reloc.com.google.common.collect.Lists;
import com.crashlytics.tools.android.onboard.Kit;
import com.crashlytics.tools.android.onboard.OnboardingConstants;
import com.crashlytics.tools.android.onboard.dsl.NestedMethodInvocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class KitUtils {
    public static List<String> importsForKits(Kit kit, boolean hasKitsEnabled) {
        ArrayList<String> imports = Lists.newArrayList();
        if (hasKitsEnabled) {
            imports.add("io.fabric.sdk.android.Fabric");
        }
        imports.add(kit.getKitClass().getFullyQualifiedClassName());
        if (kit.isSameArtifact(OnboardingConstants.TWITTER_KIT)) {
            imports.add("com.twitter.sdk.android.core.TwitterAuthConfig");
        }
        return imports;
    }

    public static String createConstructorArg(Kit kit) {
        return String.format("new %s(%s)", kit.getKitClass().getClassName(), kit.getArgs());
    }

    public static String createMethodInvocation(NestedMethodInvocation method, List<String> parameters) {
        StringBuilder methodInvocation = new StringBuilder(method.className);
        methodInvocation.append(".").append(method.methodName).append("();");
        Iterator<String> paramIterator = parameters.iterator();
        while (paramIterator.hasNext()) {
            String param = paramIterator.next() + (paramIterator.hasNext() ? ", " : "");
            methodInvocation.insert(methodInvocation.length() - 2, param);
        }
        return methodInvocation.toString();
    }
}

