/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.dwarf;

import com.crashlytics.tools.utils.dwarf.DebugLineContext;
import com.crashlytics.tools.utils.dwarf.DebugLineOpcode;
import com.crashlytics.tools.utils.io.ByteReader;
import java.io.IOException;

public class SpecialOpcode
implements DebugLineOpcode {
    private final int _opcode;

    public SpecialOpcode(int opcode) {
        this._opcode = opcode;
    }

    @Override
    public boolean process(DebugLineContext context, ByteReader dataReader) throws IOException {
        int adjustedOpcode = this._opcode - context.header.opcodeBase;
        int addressIncrement = adjustedOpcode / context.header.lineRange * context.header.minInstructionLength;
        int lineIncrement = context.header.lineBase + adjustedOpcode % context.header.lineRange;
        context.reg.line += (long)lineIncrement;
        context.reg.address += (long)addressIncrement;
        context.reg.isBasicBlock = false;
        return true;
    }
}

