/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.elf;

import com.crashlytics.reloc.com.google.common.base.Function;
import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.tools.utils.dwarf.DebugLineEntry;
import com.crashlytics.tools.utils.elf.ElfDataParser;
import com.crashlytics.tools.utils.elf.ElfFileHeader;
import com.crashlytics.tools.utils.elf.ElfSectionHeader;
import com.crashlytics.tools.utils.elf.ElfSymbol;
import com.crashlytics.tools.utils.io.ByteReader;
import com.crashlytics.tools.utils.io.RandomAccessFileInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ElfData {
    private final ElfFileHeader _elfFileHeader;
    private final List<ElfSectionHeader> _elfSectionHeaders;
    private final List<ElfSymbol> _elfSymbols;
    private final Optional<List<DebugLineEntry>> _debugLineEntries;
    private final Optional<String> _armVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElfData parse(File input) throws IOException {
        ByteReader reader = null;
        try {
            reader = new ByteReader(new RandomAccessFileInputStream(input));
            ElfData elfData = new ElfDataParser(reader).parse();
            return elfData;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public ElfData(ElfFileHeader fileHeader, List<ElfSectionHeader> sectionHeaders, List<ElfSymbol> symbols, Optional<List<DebugLineEntry>> debugLineEntries, Optional<String> armVersion) {
        this._elfFileHeader = fileHeader;
        this._elfSectionHeaders = Collections.unmodifiableList(sectionHeaders);
        this._elfSymbols = Collections.unmodifiableList(symbols);
        this._debugLineEntries = debugLineEntries.transform(new Function<List<DebugLineEntry>, List<DebugLineEntry>>(){

            @Override
            public List<DebugLineEntry> apply(List<DebugLineEntry> input) {
                return Collections.unmodifiableList(input);
            }
        });
        this._armVersion = armVersion;
    }

    public ElfFileHeader getElfFileHeader() {
        return this._elfFileHeader;
    }

    public List<ElfSectionHeader> getElfSectionHeaders() {
        return this._elfSectionHeaders;
    }

    public List<ElfSymbol> getElfSymbols() {
        return this._elfSymbols;
    }

    public Optional<List<DebugLineEntry>> getDebugLineEntries() {
        return this._debugLineEntries;
    }

    public Optional<String> getArmVersion() {
        return this._armVersion;
    }
}

