/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.examples;

import io.fabric8.certmanager.client.CertManagerClient;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;

public class ClientFactory {
    private ClientFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static CertManagerClient newClient(String[] args) {
        ConfigBuilder config = new ConfigBuilder();
        for (int i = 0; i < args.length - 1; ++i) {
            String key = args[i];
            String value = args[i + 1];
            if (key.equals("--api-server")) {
                config = (ConfigBuilder)config.withMasterUrl(value);
            }
            if (key.equals("--token")) {
                config = (ConfigBuilder)config.withOauthToken(value);
            }
            if (key.equals("--username")) {
                config = (ConfigBuilder)config.withUsername(value);
            }
            if (key.equals("--password")) {
                config = (ConfigBuilder)config.withPassword(value);
            }
            if (!key.equals("--namespace")) continue;
            config = (ConfigBuilder)config.withNamespace(value);
        }
        return (CertManagerClient)new KubernetesClientBuilder().withConfig(config.build()).build().adapt(CertManagerClient.class);
    }

    public static String getOptions(String[] args, String name, String defaultValue) {
        for (int i = 0; i < args.length - 1; ++i) {
            String key = args[i];
            String value = args[i + 1];
            if (!key.equals(name)) continue;
            return value;
        }
        return defaultValue;
    }
}

