/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBindingFluent;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class ACMEExternalAccountBindingFluentImpl<A extends ACMEExternalAccountBindingFluent<A>>
extends BaseFluent<A>
implements ACMEExternalAccountBindingFluent<A> {
    private String keyAlgorithm;
    private String keyID;
    private SecretKeySelectorBuilder keySecretRef;

    public ACMEExternalAccountBindingFluentImpl() {
    }

    public ACMEExternalAccountBindingFluentImpl(ACMEExternalAccountBinding instance) {
        this.withKeyAlgorithm(instance.getKeyAlgorithm());
        this.withKeyID(instance.getKeyID());
        this.withKeySecretRef(instance.getKeySecretRef());
    }

    @Override
    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @Override
    public A withKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return (A)this;
    }

    @Override
    public Boolean hasKeyAlgorithm() {
        return this.keyAlgorithm != null;
    }

    @Override
    @Deprecated
    public A withNewKeyAlgorithm(String arg0) {
        return this.withKeyAlgorithm(new String(arg0));
    }

    @Override
    public String getKeyID() {
        return this.keyID;
    }

    @Override
    public A withKeyID(String keyID) {
        this.keyID = keyID;
        return (A)this;
    }

    @Override
    public Boolean hasKeyID() {
        return this.keyID != null;
    }

    @Override
    @Deprecated
    public A withNewKeyID(String arg0) {
        return this.withKeyID(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretKeySelector getKeySecretRef() {
        return this.keySecretRef != null ? this.keySecretRef.build() : null;
    }

    @Override
    public SecretKeySelector buildKeySecretRef() {
        return this.keySecretRef != null ? this.keySecretRef.build() : null;
    }

    @Override
    public A withKeySecretRef(SecretKeySelector keySecretRef) {
        this._visitables.get((Object)"keySecretRef").remove(this.keySecretRef);
        if (keySecretRef != null) {
            this.keySecretRef = new SecretKeySelectorBuilder(keySecretRef);
            this._visitables.get((Object)"keySecretRef").add(this.keySecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeySecretRef() {
        return this.keySecretRef != null;
    }

    @Override
    public A withNewKeySecretRef(String key, String name) {
        return this.withKeySecretRef(new SecretKeySelector(key, name));
    }

    @Override
    public ACMEExternalAccountBindingFluent.KeySecretRefNested<A> withNewKeySecretRef() {
        return new KeySecretRefNestedImpl();
    }

    @Override
    public ACMEExternalAccountBindingFluent.KeySecretRefNested<A> withNewKeySecretRefLike(SecretKeySelector item) {
        return new KeySecretRefNestedImpl(item);
    }

    @Override
    public ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editKeySecretRef() {
        return this.withNewKeySecretRefLike(this.getKeySecretRef());
    }

    @Override
    public ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editOrNewKeySecretRef() {
        return this.withNewKeySecretRefLike(this.getKeySecretRef() != null ? this.getKeySecretRef() : new SecretKeySelectorBuilder().build());
    }

    @Override
    public ACMEExternalAccountBindingFluent.KeySecretRefNested<A> editOrNewKeySecretRefLike(SecretKeySelector item) {
        return this.withNewKeySecretRefLike(this.getKeySecretRef() != null ? this.getKeySecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACMEExternalAccountBindingFluentImpl that = (ACMEExternalAccountBindingFluentImpl)o;
        if (this.keyAlgorithm != null ? !this.keyAlgorithm.equals(that.keyAlgorithm) : that.keyAlgorithm != null) {
            return false;
        }
        if (this.keyID != null ? !this.keyID.equals(that.keyID) : that.keyID != null) {
            return false;
        }
        return !(this.keySecretRef != null ? !this.keySecretRef.equals(that.keySecretRef) : that.keySecretRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.keyAlgorithm, this.keyID, this.keySecretRef, super.hashCode());
    }

    public class KeySecretRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<ACMEExternalAccountBindingFluent.KeySecretRefNested<N>>
    implements ACMEExternalAccountBindingFluent.KeySecretRefNested<N>,
    Nested<N> {
        SecretKeySelectorBuilder builder;

        KeySecretRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        KeySecretRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ACMEExternalAccountBindingFluentImpl.this.withKeySecretRef(this.builder.build());
        }

        @Override
        public N endKeySecretRef() {
            return this.and();
        }
    }
}

