/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.v1.decorator.AddAdditionPrinterColumnDecorator;
import io.fabric8.crd.generator.v1.decorator.CustomResourceDefinitionVersionDecorator;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersionFluent;
import java.util.List;

public class SortPrinterColumnsDecorator
extends CustomResourceDefinitionVersionDecorator<CustomResourceDefinitionVersionFluent<?>> {
    public SortPrinterColumnsDecorator(String name, String version) {
        super(name, version);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionVersionFluent<?> version) {
        List columns = version.buildAdditionalPrinterColumns();
        if (columns != null && !columns.isEmpty()) {
            columns.sort((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getJsonPath(), o2.getJsonPath()));
        }
        version.withAdditionalPrinterColumns(columns);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{CustomResourceDefinitionVersionDecorator.class, AddAdditionPrinterColumnDecorator.class};
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomResourceDefinitionVersionDecorator other = (CustomResourceDefinitionVersionDecorator)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals(other.getVersion()));
    }

    public String toString() {
        return this.getClass().getName() + " [name:" + this.getName() + ", version:" + this.getVersion() + "]";
    }
}

