/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class AuthConfig {
    public static final AuthConfig EMPTY_AUTH_CONFIG = new AuthConfig("", "", "", "");
    private String authEncoded;

    public AuthConfig(Map<String, String> params) {
        this.authEncoded = this.createAuthEncoded(params);
    }

    public AuthConfig(String user, String password, String email, String auth) {
        HashMap<String, String> params = new HashMap<String, String>();
        this.putNonNull(params, "username", user);
        this.putNonNull(params, "password", password);
        this.putNonNull(params, "email", email);
        this.putNonNull(params, "auth", auth);
        this.authEncoded = this.createAuthEncoded(params);
    }

    public AuthConfig(String credentialsDockerEncoded, String email) {
        String credentials = new String(Base64.decodeBase64((String)credentialsDockerEncoded));
        String[] parsedCreds = credentials.split(":", 2);
        HashMap<String, String> params = new HashMap<String, String>();
        this.putNonNull(params, "username", parsedCreds[0]);
        this.putNonNull(params, "password", parsedCreds[1]);
        this.putNonNull(params, "email", email);
        this.authEncoded = this.createAuthEncoded(params);
    }

    public String toHeaderValue() {
        return this.authEncoded;
    }

    private String createAuthEncoded(Map<String, String> params) {
        JSONObject ret = new JSONObject();
        this.add(params, ret, "username");
        this.add(params, ret, "password");
        this.add(params, ret, "email");
        this.add(params, ret, "auth");
        try {
            return Base64.encodeBase64String((byte[])ret.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return Base64.encodeBase64String((byte[])ret.toString().getBytes());
        }
    }

    private void add(Map<String, String> params, JSONObject ret, String key) {
        if (params.containsKey(key)) {
            ret.put(key, (Object)params.get(key));
        }
    }

    private void putNonNull(Map ret, String key, String value) {
        if (value != null) {
            ret.put(key, value);
        }
    }
}

